use hahn;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;

$round = ($a) -> {return cast((Math::Round(cast($a as float),-2)) as string)};
$match = Re2::Match('[.]');
$matchd = Re2::Match('[.]\d$');
$replace = Re2::Replace('[.]');
$dt_format = DateTime::Format('%Y-%m-%d');
$DASHBOARD = '//home/taxi-delivery/analytics/production/ndd/dash_transactions_tracker';


$data = (
SELECT
    request_code,
    corp_client_id,
    payment_type,
    external_order_id,
    operator_id,
    mapped_event_type,
    payment_method,
    event_instant_dt,
    delivery_cost,
    employer_code,
    items_price_old,
    payment_order_number,
    $dt_format(DateTime::ParseIso8601(max(pon_status_last_update_dt))) AS pon_status_last_update_dt,
    max_by(pon_status, pon_status_last_update_dt) as pon_status,
    request_id,
    cargo_payments_history_tt,
    payment_dt,
    refused_price,
    cp_amount,
    delivery,
    refused_price_modified,
    refuse,
    1 as bar
from 
    `//home/taxi-delivery/analytics/production/ndd/post_pay_table`
where
    event_instant_dt is not null
group by 
    request_id,
    request_code,
    corp_client_id,
    payment_type,
    external_order_id,
    operator_id,
    mapped_event_type,
    case
        when request_code in ('1-251-82909', '1-251-82955', '1-251-82961', '21233792', '21244768')
        then 'cash_on_receipt'
        else payment_method
        end as payment_method,
    event_instant_dt,
    delivery_cost,
    employer_code,
    items_price_old,
    payment_order_number,
    $dt_format(DateTime::FromSeconds(cast(cargo_payments_history_tt as uint32))) as cargo_payments_history_tt,
    $dt_format(DateTime::FromSeconds(cast(cargo_payments_history_tt + 3600*3 as uint32))) as payment_dt,
    refused_price,
    case
        when amount like '%.%' and $match($round(amount))
        then case
            when $matchd($round(amount)) 
            then $replace($round(amount), '') || '0'
            else $replace($round(amount), '')
            end
        else case
            when amount like '%.%' 
            then $round(amount) || '00'
            else amount || '00'
            end
        end as cp_amount,
    delivery_cost/100 as delivery,
    if(items_price_old = 0, 0, refused_price) as refused_price_modified,
    refused_price / 100 as refuse

);

$data_step2 = (

SELECT 
    a.*,
    coalesce(cast(cp_amount as INT32),0) / 100 as cp_amount_num,
    (items_price_old - refused_price_modified) / 100 as items_price,
    (items_price_old - refused_price_modified + delivery_cost) / 100 as total_price
from $data as a
);

insert into $DASHBOARD WITH TRUNCATE 
select
    a.*,
    If(
        DateTime::ToDays(CurrentUtcDate() - cast(event_instant_dt as date)) < 2
        or (DateTime::GetDayOfWeek(cast(event_instant_dt as date)) in (5,6,7)
            and DateTime::GetDayOfWeek(CurrentUtcDate()) == 1
            and DateTime::ToDays(CurrentUtcDate() - cast(event_instant_dt as date)) < 4)
        or total_price = cp_amount_num,
        Null,
        total_price - cp_amount_num) as diff
from $data_step2 as a;
