USE chyt.hahn/taxi-delivery;

insert into
"<append=true>//home/taxi-delivery/analytics/production/ndd/leomax/returns" 
select 
    today() as report_date,
    delivery_address,
    request_code, employer_code, arrived_at_sc_dttm, if(was_delivering_dttm is null, 'Отменен', 'Отказ во время доставки') as status,
    DAYOFWEEK(today()) as today,
    date_diff,   workweek

from (
SELECT
    request_code, employer_code, delivery_address,
    MAX(if(operator_lp_status = 'SORTING_CENTER_AT_START', tech_event_instant_ddtm, null)) as arrived_at_sc_dttm,
    MAX(if(operator_lp_status = 'RETURN_PREPARING', tech_event_instant_ddtm, null)) as cancelled_dttm,
    MAX(if(operator_lp_status = 'DELIVERY_TRANSPORTATION_RECIPIENT', tech_event_instant_ddtm, null)) as was_delivering_dttm,
    --
    MAX(if(operator_lp_status = 'SORTING_CENTER_RETURN_ARRIVED', tech_event_instant_ddtm, null)) as returned_to_shop_dttm
    
FROM `//home/taxi-delivery/analytics/production/ndd/requests_datamart`
WHERE 
    1=1
    AND employer_code in ('ptv', 'tov')
    -- 
    AND operator_id = 'yd'
GROUP BY 
    request_code, employer_code, delivery_address
    HAVING 1=1
    AND arrived_at_sc_dttm is not null 
    AND cancelled_dttm is not null
    AND returned_to_shop_dttm is null
) as original 
left join 
(SELECT
     left(operator_station_id, 3) as employer_code, 
    if(monday > 0, '1', '0') || if(tuesday > 0, '1', '0') || if(wednesday > 0, '1', '0') || if(thursday > 0, '1', '0') || if(friday > 0, '1', '0') || if(saturday > 0, '1', '0') || if(sunday > 0, '1', '0')
    as workweek
    , multiIf(substr(workweek, if((DAYOFWEEK(today())+1) < 7,(DAYOFWEEK(today())+1), (DAYOFWEEK(today())+1+1))  mod 7 + 1, 1) = '1', 1,
              substr(workweek, if((DAYOFWEEK(today())+2) < 7,(DAYOFWEEK(today())+2), (DAYOFWEEK(today())+2+1))  mod 7 + 1, 1) = '1', 2, 
              substr(workweek, if((DAYOFWEEK(today())+3) < 7,(DAYOFWEEK(today())+3), (DAYOFWEEK(today())+3+1))  mod 7 + 1, 1) = '1', 3,
              substr(workweek, if((DAYOFWEEK(today())+4) < 7,(DAYOFWEEK(today())+4), (DAYOFWEEK(today())+4+1))  mod 7 + 1, 1) = '1', 4,
              substr(workweek, if((DAYOFWEEK(today())+5) < 7,(DAYOFWEEK(today())+5), (DAYOFWEEK(today())+5+1))  mod 7 + 1, 1) = '1', 5,
              substr(workweek, if((DAYOFWEEK(today())+6) < 7,(DAYOFWEEK(today())+6), (DAYOFWEEK(today())+6+1))  mod 7 + 1, 1) = '1', 6,
              7) as date_diff
    --, monday, tuesday, wednesday, thursday, friday, saturday, sunday
FROM `//home/taxi-delivery/analytics/production/ndd/zaborka_volumes`
where employer_code in ('ptv', 'tov')) as work_days 
on work_days.employer_code = original.employer_code
where request_code not in (select distinct request_code from 
"//home/taxi-delivery/analytics/production/ndd/leomax/returns")