use hahn;
PRAGMA yt.InferSchema;
PRAGMA yt.Owners = 'svkorolev';

$start_date = "2022-01-01";

$last_pmt_history_id = 0;
$payment_history_path = "//home/taxi/production/features/oebs/pmt_export/pmt_history";
$tlog_groups_dir = "//home/taxi/production/features/oebs/pmt_export/tlog_groups_history";
$cashless_dir = "//home/taxi/production/export/tlog/payments";

$moscow_date = ($datetime_str_with_tz) -> {
    $make_date_str = DateTime::Format("%Y-%m-%d");
    RETURN $make_date_str(
        AddTimezone(
            DateTime::MakeDatetime(
                DateTime::ParseIso8601($datetime_str_with_tz)
            ),
            "Europe/Moscow"
        )
    )
};

$tlog_group_schema = Struct<
    CLIENT_ID:Int64,
    BILLING_CONTRACT_ID:Int64?,
    SERVICE_ID:Int64?,
    K_CURRENCY_CODE:String,
    STATUS:String,
    SOURCE_TYPE:String,
    SOURCE_TABNAME:String,
    TRANSACTION_ID_MIN:Int64?,
    TRANSACTION_ID_MAX:Int64?,
    TRANSACTION_COUNT:Int64,
    K_ALIAS:String,
    PAYMENT_ID:Int64?,
    PAYMENT_BATCH_ID:Int64?,
    REWARD_DATA_LINE_ID:Int64?,
    TAX_RATE:Double?,
    PROC_AMOUNT_W_VAT_APPLIED:Double?,
    ACCOUNTING_DATE:String?,
    GROUP_ID:Int64?,
    GROUP_TYPE:String,
    GROUP_HISTORY_ID:Int64?,
    TRANSACTION_TYPE:String?,
    TERMINAL_ID:String?,
    ATTRIBUTE1:String?,
    ATTRIBUTE2:String?,
    ATTRIBUTE3:String?,
    ATTRIBUTE4:String?,
    ATTRIBUTE5:String?,
>;

$CARGO_PAYMENTS_VIEW = "//home/taxi/production/replica/postgres/cargo_payments/billing_tasks_history";

$time_cast = ($history_timestamp) -> {
    return CAST($history_timestamp as Uint32) 
};

$cargo_payments = (
    SElECT
        String::ReplaceAll(order_id, ' ', '') as request_id
        , amount
        , state as status
        , `type` as payment_type
        , CAST(payment_instant as Int64) as history_timestamp
        , CAST(billing_doc_id as Int64) as billing_doc_id
    FROM 
        $CARGO_PAYMENTS_VIEW
    where 
        Datetime::FromSeconds($time_cast(history_timestamp)) >= Timestamp('2021-06-29T00:00:00.000000Z')
);

$tlog_payments = (
    SELECT
        T.amount as amount
        , T.currency as currency
        , T.event_time as event_time
        , T.transaction_time as transaction_time
        , T.invoice_date as invoice_date
        , String::ReplaceAll(CAST(Yson::LookupString(
                T.payload, "operation_id", Yson::Options(false AS Strict)
            ) AS Utf8), ' ', '') AS operation_id
        , T.client_id as client_id
        , T.service_id as service_id
        , T.transaction_type as transaction_type
        , C.billing_doc_id as billing_doc_id
        , CAST(
                Yson::LookupInt64(T.payload, "terminal_id",
                Yson::Options(false AS Strict)) as String) as terminal_id
        , T.transaction_id as transaction_id
        , T.contract_id as contract_id
    FROM RANGE($cashless_dir, $start_date) AS T
    inner join 
        $cargo_payments as C
        ON C.billing_doc_id = Yson::LookupInt64(T.payload,"base_doc_id")
)
;

$payments_with_last_status = (
    SELECT         
        P1.PAYMENT_ID AS payment_id,
        P1.PMT_HIST_ID AS history_id,
        P1.PAYMENT_AMOUNT AS total,
        P1.FIRST_EXPORT_DATE AS export_date,
        P1.LAST_UPDATE_DATE AS last_update_dt,
        P1.PAYMENT_STATUS as payment_status,
        P1.PAYMENT_ORDER_NUMBER as payment_order_number
    FROM RANGE($payment_history_path, $start_date) as P1
  /*  WHERE P1.PAYMENT_ORDER_NUMBER in (select distinct payment_order_number
    from 
    `//home/taxi-delivery/analytics/production/ndd/post_pay_table`
    where delivery_dt >= '2022-02-01') -- сюда нлмер платежки текстом
or P1.PAYMENT_ORDER_NUMBER in ('27818')
*/
);

$tlog_group_max_versions = (
    SELECT
        G.PAYMENT_ID AS PAYMENT_ID,
        G.GROUP_ID AS GROUP_ID,
        MAX(G.GROUP_HISTORY_ID) AS GROUP_HISTORY_ID
    FROM RANGE($tlog_groups_dir, $start_date)
        WITH SCHEMA $tlog_group_schema AS G
    GROUP BY G.PAYMENT_ID, G.GROUP_ID
);

$tlog_groups = (
    SELECT G.*
    FROM RANGE($tlog_groups_dir, $start_date)
        WITH SCHEMA $tlog_group_schema AS G
    RIGHT JOIN $tlog_group_max_versions AS G2 ON
            G.PAYMENT_ID = G2.PAYMENT_ID
        AND G.GROUP_ID = G2.GROUP_ID
        AND G.GROUP_HISTORY_ID = G2.GROUP_HISTORY_ID
    WHERE
            G.PAYMENT_ID IS NOT NULL
        AND G.STATUS LIKE "%_FULL"
);

$filtered_transactions =(
    SELECT
        CAST(G.PAYMENT_ID AS UInt64) AS payment_id,
        CAST(T.amount AS Utf8) AS orig_amount,
        CAST(T.currency AS Utf8) AS currency,
        CAST(T.event_time AS Utf8) AS event_time,
        CAST(T.transaction_time AS Utf8) AS transaction_time,
        CAST(T.invoice_date AS Utf8) AS invoice_time,
        T.operation_id as operation_id
        , T.billing_doc_id as billing_doc_id
    FROM $tlog_groups AS G
    JOIN $tlog_payments AS T
        ON T.client_id = CAST(G.CLIENT_ID AS String)
            AND T.service_id = G.SERVICE_ID
            AND T.currency = G.K_CURRENCY_CODE
            AND T.transaction_type = G.TRANSACTION_TYPE
            AND T.terminal_id = G.TERMINAL_ID
    WHERE
        G.SOURCE_TYPE = "PAYMENT"
    AND T.transaction_id BETWEEN G.TRANSACTION_ID_MIN AND G.TRANSACTION_ID_MAX
    AND (
        COALESCE(T.contract_id, CAST(G.BILLING_CONTRACT_ID as String)) =
            CAST(G.BILLING_CONTRACT_ID as String)
    )
    AND $moscow_date(T.event_time) = $moscow_date(G.ACCOUNTING_DATE)
);

$pon_tmp = (
SELECT 
        T.operation_id AS request_id,
        T.billing_doc_id as billing_doc_id,
        T.orig_amount AS orig_amount,
        P.last_update_dt as last_update_dt,
        P.export_date as export_dt,
        P.payment_status AS payment_status,
        P.payment_order_number as payment_order_number
FROM $filtered_transactions AS T
JOIN $payments_with_last_status AS P ON T.payment_id = P.payment_id
)
;

insert into 
`//home/taxi-delivery/analytics/dev/ndd/post_pay_table_missing_orders_new`
WITH TRUNCATE 
select p.*, rd.* from $pon_tmp as p
/*left join 
(select distinct billing_doc_id, meta_order_id
from 
`//home/taxi/production/replica/postgres/cargo_payments/billing_tasks_history`
) as bth */
-- on cast(p.billing_doc_id as string) = cast(bth.billing_doc_id as string)
left join 
(select  request_id, MAX_BY(mapped_event_type, `event_instant_ddtm`) as status, corp_client_id, request_code, employer_code
from 
`//home/taxi-delivery/analytics/production/ndd/requests_datamart`
group by 
    request_id, corp_client_id, request_code, employer_code
) as rd 
on rd.request_id = p.request_id