use hahn;

$features = ($meta_data) -> { 
    return Yson::YPath(Yson::Parse($meta_data), "/features") 
};

$capture = Re2::Capture("cargo-pricing.+")
;

$billing_features_string = ($meta_data, $feature) -> {
    return Yson::YPathString(ListSkipWhile(Yson::ConvertToList($features($meta_data)), ($x) -> {
        return Yson::ConvertToString(DictLookup(Yson::ConvertToDict($x), 'class_name')) != 'billing'
    })[0], '/resource_billing_feature/' || $feature)
};

$requests = (
    select DISTINCT 
        request_id, 
        request_code
    FROM
        range(`//home/taxi/testing/export/taxi-logistic-platform-production/requests_history`, '2021-08-20')
)
;

$resources = (
SELECT
    request_id,
    $capture($billing_features_string(`unpacked_data`, 'cargo_pricing'))._0 as cargo_pricing
FROM range(`//home/taxi/testing/export/taxi-logistic-platform-production/resources_history`, '2021-08-20')
);


$cargo_pricing = (
    SELECT
    `id`,
    Yson::ParseJson(Yson::ConvertToString(`pricing_schedule`)).delivery.return_price_pct as return_price_pct,
FROM hahn.`home/taxi/production/replica/postgres/cargo_tariffs/tariff_compositions`
);


insert into 
`//home/taxi-delivery/analytics/dev/ndd/return_price`
WITH TRUNCATE 
select * 
from 
$requests as r 
left join 
$resources as re 
on re.request_id = r.request_id
left join 
$cargo_pricing as cp 
on cp.id = re.cargo_pricing
