USE chyt.hahn/taxi-delivery;

select count(1) as value
from
(
select  event_instant_dt, dateDiff('day', toDate(event_instant_dt), today()),  case when 
    toDate(event_instant_dt) = today() or (toDayOfWeek(toDate(event_instant_dt)) in (5,6,7) 
                                           and toDayOfWeek(today()) = 1
                                           and (dateDiff('day', toDate(event_instant_dt), today()) < 4
                                                or items_price_old - refused_price + delivery_cost - cp_amount_num = 0))
                                                then null 
    else items_price_old - refused_price + delivery_cost - cp_amount_num end as result,
 items_price_old - refused_price + delivery_cost as total_price, cp_amount_num
from 
(
select event_instant_dt, items_price_old, 
case when items_price_old == 0 then 0 else refused_price end as refused_price
, delivery_cost, toInt64(cp_amount) as cp_amount_num
from 
(
SELECT
    T."request_code",
    T."corp_client_id",
    T."external_order_id",
    T."operator_id",
    T."mapped_event_type",
    T."payment_method",
    T."event_instant_dt",
    T."delivery_cost",
    T."employer_code",
    T."items_price_old",
    T."payment_order_number",
    toDate(substring(T."pon_status_last_update_dt", 1, 10)) AS "pon_status_last_update_dt",
    T."pon_status",
    T."request_id"
    , MAX(toDate("export_dt")) as cargo_payments_history_tt
    , T."refused_price"
    --, MAX(T."amount") as amount
   , case when toString(T."amount") like '%.%'  and match(toString(round(toFloat64(T."amount") * 1, 2)), '[.]')
       then case when match(toString(round(toFloat64(T."amount") * 1, 2)), '[.]\d$')  
           then replaceRegexpAll(toString(round(toFloat64(T."amount") * 1, 2)), '[.]', '') || '0'
           else replaceRegexpAll(toString(round(toFloat64(T."amount") * 1, 2)), '[.]', '')
               end
       else case when toString(T."amount") like '%.%' 
           then toString(round(toFloat64(T."amount") * 1, 2)) || '00'
           else toString(T."amount") 
           end
        end as cp_amount
from 
"//home/taxi-delivery/analytics/production/ndd/post_pay_table" as T
where 
    1=1
    and T."event_instant_dt" is not null
group by 
cp_amount,
T."pon_status",
   "pon_status_last_update_dt",
    T."request_id",
    T."request_code",
    T."corp_client_id",
    T."external_order_id",
    T."operator_id",
    T."mapped_event_type",
    T."payment_method",
    T."event_instant_dt",
    T."delivery_cost",
    T."employer_code",
    T."items_price_old",
    T."payment_order_number"
, T."refused_price"
having payment_method in ('card_on_receipt', 'cash_on_receipt')
)
)
where result > 0
and toDate(event_instant_dt) >= toDate(timestamp_sub(DAY, 5, now()))
)