use chyt.hahn/taxi-delivery;

insert into "//home/taxi-delivery/analytics/production/ndd/alerts/no_yd_id"
select 
    created_at
    , employer_code 
    , request_code
    , request_id
    , operator_id
    , status
from (
    select 
        (now() - toDateTime(created_at)) / 60 as diff
        , created_at
        , employer_code
        , case when external_order_id is null then 1 else 0 end as external_order_id_null
        , request_code
        , request_id
        , operator_id
        , status
    from (
        SELECT 
            toDateTime(created_at) as created_at,
            employer_code,
            request_id,
            request_code,
            argMax(status, history_event_id) as status
        from 
            concatYtTablesRange("//home/taxi/testing/export/taxi-logistic-platform-production/requests_history", toString(yesterday()))
        where employer_code <> 'beru'
            and toDateTime(created_at) >= timestamp_sub(MINUTE, 60, now())
        group by created_at, employer_code, request_id, request_code
    ) as r
    left join (
        select 
            request_id
            , operator_id
            , max(external_order_id) as external_order_id
        from 
            concatYtTablesRange("//home/taxi/testing/export/taxi-logistic-platform-production/planned_transfers_history", toString(yesterday()))
        group by 
            request_id
            , operator_id
        having operator_id is not null
    ) as p 
    on r.request_id = p.request_id
)
where 1=1
    and diff > 30
    and external_order_id_null = 1
    and request_code not in (
        select request_code 
        from "//home/taxi-delivery/analytics/production/ndd/alerts/no_yd_id_processed"
    )
    and request_code not in (
        select request_code 
        from "//home/taxi-delivery/analytics/production/ndd/alerts/no_yd_id"
    )
    and operator_id in ('yd_new', 'self_pickup');
