use chyt.hahn/taxi-delivery;

select 
sum(external_order_id) as value
from 
(
select (now() - toDateTime(created_at)) / 60 as diff
, case when external_order_id is null then 1 else 0 end as external_order_id
, request_code
, operator_id
from 
(
SELECT 
distinct
toDateTime(created_at) as created_at,
request_id,
request_code
from 
concatYtTablesRange("//home/taxi/testing/export/taxi-logistic-platform-production/requests_history", toString(yesterday()))
where employer_code <> 'beru'
and toDateTime(created_at) >= timestamp_sub(MINUTE, 60, now())
) as r
left join 
(
    select 
    request_id
    , operator_id
    , max(external_order_id) as external_order_id
    from 
        concatYtTablesRange("//home/taxi/testing/export/taxi-logistic-platform-production/planned_transfers_history", toString(yesterday()))
    group by 
        request_id
        , operator_id
) as p 
on r.request_id = p.request_id
)
where 
diff > 20
and request_code not in (select DISTINCT request_code from 
concatYtTablesRange("//home/taxi/testing/export/taxi-logistic-platform-production/requests_history", toString(yesterday()))
where employer_code <> 'beru'
and toDateTime(created_at) >= timestamp_sub(MINUTE, 60, now())
and status = 'returned'
)
and operator_id = 'top-delivery'
