import os
import json
import requests
from requests.adapters import HTTPAdapter
from urllib3.util.retry import Retry

import yt.wrapper as yt

from projects.common.clients.tvm import TVMClient

TRACKER_URL = 'https://st-api.yandex-team.ru'
OAUTH_TOKEN = os.environ.get('ST_TOKEN')

def make_http_session():
    session = requests.Session()

    session.headers = {
        'Authorization' : f'OAuth {OAUTH_TOKEN}'
    }
    
    retry = Retry(
        total=10,
        backoff_factor=0.1,
        status_forcelist=(500, 502, 503, 504),
        allowed_methods=('POST',),
    )
    session.mount('https://', HTTPAdapter(max_retries=retry))
    return session

def dummy_test(session):
    resp = session.get(url=TRACKER_URL + '/v2/myself', verify=False)
    
    return resp.json()['login']

def create_ticket(session, request_code, request_id):
#     QUEUE = 'IKHOMYANINTEST'
    QUEUE = 'DELOUT'
    TITLE = 'Не прорастает заказ Яндекс Доставки'
#     FOLLOWERS = [
#         'emilsharafiev'
#     ]
    FOLLOWERS = [
        'ikhomyanin',
        'emilsharafiev'
    ]
    TAGS = [
        # 'CombiGo', 
        'контур#ДоставкаНаружу',
        'support'
    ]
    TYPE = 'task'
    PRIORITY = 'normal'
    
    description = f'''
    **Ссылка на заказ в ЛП:**
    https://tariff-editor.taxi.yandex-team.ru/dragon-orders?cluster=platform&request_code={request_code}

    **Ссылка на логи в Кибане:**
    https://kibana.taxi.yandex-team.ru/app/kibana#/discover?_g=(refreshInterval:(pause:!t,value:0),time:(from:now-15h,to:now))&_a=(columns:!(_source),interval:auto,query:(language:kuery,query:'request_id%20:%20{request_id}'),sort:!(!('@timestamp',desc)))
    
    **Как найти нужные логи в Кибане:**
    1. Ищем request от лог платформы в OpenApi (delivery-options или post order)
    2. Находим response, там же будет лежать трассировка (x-ya-market-request-id)

    Тикет сгенерирован автоматически в рамках https://st.yandex-team.ru/LOGDATA-1911
    ''' 
    
    payload = {
        "queue": QUEUE,
        "summary": TITLE,
        'description': description,
        "tags": TAGS,
        "followers": FOLLOWERS,
        "type": TYPE,
        "priority": PRIORITY
    }
    
    create_ticket = session.post(url=TRACKER_URL + f'/v2/issues', data = json.dumps(payload))
    print(create_ticket.json())
    ticket_key = create_ticket.json()['key']
        
    return ticket_key

def create_table(table_path):
    SCHEMA = [
        {"name" : "created_at", "type" : "int64", "strict": "false"}, 
        {"name" : "employer_code", "type" : "string", "strict": "false"}, 
        {"name" : "request_code", "type" : "string", "strict": "false"},
        {"name" : "request_id", "type" : "string", "strict": "false"},
        {"name" : "operator_id", "type" : "string", "strict": "false"},
        {"name" : "status", "type" : "string", "strict": "false"},
        {"name" : "ticket_key", "type" : "string", "strict": "false"},
        {"name" : "ticket_link", "type" : "string", "strict": "false"}
    ]
    yt.config["proxy"]["url"] = "hahn.yt.yandex.net"
    yt.create("table", table_path, attributes={"schema": SCHEMA}, force=True)
    
def save_results(table_path, results):
    YT_TABLE_PATH = table_path
    yt.write_table(
        yt.TablePath(YT_TABLE_PATH, append=True),
        results,
    )
    
# def main():
#     print('Hello')
    
def main():
    session = make_http_session()
    print('SESSION CREATED - ' + dummy_test(session))
    yt.config['proxy']['url'] = 'hahn.yt.yandex.net'
    REQUESTS_PATH = '//home/taxi-delivery/analytics/production/ndd/alerts/no_yd_id'
    PROCESSED_REQUESTS_PATH = '//home/taxi-delivery/analytics/production/ndd/alerts/no_yd_id_processed'

    processed_requests = list(yt.read_table(PROCESSED_REQUESTS_PATH))
    processed_request_codes = []
    for request in processed_requests:
        processed_request_codes.append(request['request_code'])

    requests = list(yt.read_table(REQUESTS_PATH))
    print('GOT REQUESTS')
    
    new_records = []

    for request in requests:
        request_code = request['request_code']
        request_id = request['request_id']
        
        if request_code not in processed_request_codes:
            ticket_key = create_ticket(session, request_code, request_id)
            print(f'CREATED TICKET FOR REQUEST CODE - {request_code}')

            record = {
                **request,
                'ticket_key': ticket_key,
                'ticket_link': 'https://st.yandex-team.ru/' + ticket_key
            }

            new_records.append(record)
        
    save_results(PROCESSED_REQUESTS_PATH, new_records)
    print('RESULTS SAVED')
    
if __name__ == '__main__':
    main()
