import os

import requests
from requests.adapters import HTTPAdapter
from urllib3.util.retry import Retry

import yt.wrapper as yt

TRACKER_URL = 'https://st-api.yandex-team.ru'
OAUTH_TOKEN = OAUTH_TOKEN = os.environ.get('ST_TOKEN')

def make_http_session():
    session = requests.Session()

    session.headers = {
        'Authorization' : f'OAuth {OAUTH_TOKEN}'
    }
    
    retry = Retry(
        total=10,
        backoff_factor=0.1,
        status_forcelist=(500, 502, 503, 504),
        allowed_methods=('POST',),
    )
    session.mount('https://', HTTPAdapter(max_retries=retry))
    return session

def get_ticket(session, ticket_key):
    ticket = session.get(url=TRACKER_URL + f'/v2/issues/{ticket_key}')
    
    return ticket.json()

def save_results(table_path, results):
    YT_TABLE_PATH = table_path
    yt.write_table(
        YT_TABLE_PATH,
        results,
    )
    
def main():
    yt.config['proxy']['url'] = 'hahn.yt.yandex.net'
    PROCESSED_REQUESTS_PATH = '//home/taxi-delivery/analytics/production/ndd/alerts/no_yd_id_processed'
    processed_requests = list(yt.read_table(PROCESSED_REQUESTS_PATH))
    
    session = make_http_session()
    
    tickets_with_statuses = []
    for request in processed_requests:
        ticket_key = request['ticket_key']

        ticket = get_ticket(session, ticket_key)

        tickets_with_statuses.append({
            'ticket_key': ticket_key,
            'ticket_status_key': ticket['status']['key']
        })
        
    SAVE_TO = '//home/taxi-delivery/analytics/production/ndd/alerts/no_yd_id_ticket_status'
    save_results(SAVE_TO, tickets_with_statuses)
    
if __name__ == '__main__':
    main()