use chyt.hahn/taxi-delivery;


--create table "//home/taxi-delivery/analytics/production/ndd/waiting_operator_time" engine=YtTable() as

insert into "<append=true>//home/taxi-delivery/analytics/production/ndd/waiting_operator_time" 
select employer_code, toDateTime(created_at) as created_at,
request_code,
operator_id,
toDateTime(p.status_dttm) as status_dttm,
status_dttm - created_at as diff_sec
 from  
(
SELECT 
toDateTime(created_at) as created_at,
employer_code,
request_id,
request_code
from 
concatYtTablesRange("//home/taxi/testing/export/taxi-logistic-platform-production/requests_history", '2022-04-01')
where employer_code <> 'beru'
group by created_at, employer_code, request_id, request_code
) as r
left join 
(
    select 
    request_id
    , operator_id
    , argMin(`history_timestamp`, `history_event_id`) as status_dttm 
    from 
        concatYtTablesRange("//home/taxi/testing/export/taxi-logistic-platform-production/planned_transfers_history", '2022-04-01')
    where `external_order_id` is not null
    group by 
        request_id
        , operator_id
        having operator_id is not null
) as p 
on r.request_id = p.request_id
where status_dttm is not null
and created_at > '2022-04-01'
and request_code not in (select distinct request_code from "//home/taxi-delivery/analytics/production/ndd/waiting_operator_time")