use hahn; 
PRAGMA AnsiInForEmptyOrNullableItemsCollections;

$NDD_MAIN = '//home/taxi-delivery/analytics/dev/ndd/ndd_main_dash'; 
$TS = '//home/taxi-delivery/analytics/production/k2/ts_datamart'; 
$K2 = '//home/taxi-delivery/analytics/production/k2/k2_datamart';
$HELL = '//home/taxi-delivery/analytics/dev/ndd/not_only_logplatform';

$SAVE_TO = '//home/taxi-delivery/analytics/production/ndd/all_ndd_deliveries_datalens/aggregated_ndd_deliveries';

$req_info = (
    select 
        request_id
        , min(substring(utc_event_dttm, 0, 10)) as event_instant_dt
        , employer_code
        , product 
        , brand_name
    from $NDD_MAIN
    where 1=1
        and mapped_event_type  in ('Доставлен', 'Доставлен частично')
        and employer_code  != 'Eva'
    group by request_id 
        , employer_code
        , brand_name
        , case 
            when request_id is not null then 'External clients'
            else NULL 
        end as product
        
);

$req_agg = (
    select count( distinct request_id) as cnt_deliveries
        , dt_delivered
        , employer_code
        , product
        , brand_name
    from $req_info 
    group by 
        event_instant_dt as dt_delivered 
        , employer_code
        , product
        , brand_name

);
$ts_info = (
    select DISTINCT 
        order_id
        , market_order_id
        , (substring(msk_delivered_dttm,0,10)) as dt_delivered
        , msk_delivered_dttm
        --, employer_code
        , pickup_or_lavka
        , case 
            when operator_tag_list = 'WIDE_INTERVAL' then 'Wide slot'
            when operator_tag_list = 'DEFERRED_COURIER' then 'Time slot'
            else NULL 
        end as product
    from $TS
    where msk_delivered_dttm is not null
);

$ts_info_agg = (
    select 
        order_id
        , dt_delivered
        , pickup_or_lavka
        , market_order_id
        , max_by(product, msk_delivered_dttm) as product
    from $ts_info
    group by order_id
        , dt_delivered
        , pickup_or_lavka
        , market_order_id
);


$k2_info = (
    select DISTINCT 
        order_id
        , market_order_id
        , (substring(msk_delivered_dttm,0,10)) as dt_delivered 
        , msk_delivered_dttm
        , employer_code
        , pickup_or_lavka
        , case 
            when order_id is not null then 'K2'
            else NULL 
        end as product
    from $K2
    where msk_delivered_dttm is not null
    and order_id not in (select order_id from $ts_info_agg)
);


$ts_cnt = (
    select 
        dt_delivered
        , product
        , count(DISTINCT market_order_id) as cnt_deliveries
    from $ts_info_agg 
    group by dt_delivered
        , product
);

$k2_cnt = (
    select 
        dt_delivered
        , employer_code
        , product 
        , count(DISTINCT market_order_id) as cnt_deliveries
    from  $k2_info
    group by dt_delivered
        , employer_code
        , product 

);


$not_only_logplatform = 
    (
    select 
        dt_delivered
        , employer_code
        , product
        , SUM(cnt_deliveries) as cnt_deliveries
    from $HELL
    where type in ('Клиенты: Cainiao (внешняя курьерка)', 'Маркет NDD')
    group by  
        shiftDate as dt_delivered
        , case 
            when type = 'Клиенты: Cainiao (внешняя курьерка)' then 'tsa (внешняя курьерка)'
            else NULL 
        end as employer_code
        , case 
            when type = 'Клиенты: Cainiao (внешняя курьерка)' then 'External clients'
            when type = 'Маркет NDD' then 'Market NDD'
            else null 
        end as product
);


$together = 
    (select * 
    from $req_agg

    union all 

    select * 
    from $ts_cnt 

    union all 

    select * 
    from $k2_cnt

    union all 

    select 
        dt_delivered
            , employer_code
            , product
            , cnt_deliveries
    from $not_only_logplatform
); 

INSERT INTO $SAVE_TO WITH TRUNCATE 

SELECT 
    t.*
    , CASE 
        when product = 'Wide slot' or product = 'Time slot' or product =  'K2' then 'Market K2'
        when product = 'Market NDD' then 'Market NDD'
        when product = 'External clients' then 'External clients' 
        else NULL 
    end as agg_product
 from $together as t

