use hahn; 
PRAGMA AnsiInForEmptyOrNullableItemsCollections;

-- про ЧП: https://wiki.yandex-team.ru/users/kanaglic/tracking-status-mapping/

-- откат с чс в по клику 
-- (
-- select 
--     distinct
--     external_order_id
-- from 
-- concatYtTablesRange("//home/taxi/testing/export/taxi-logistic-platform-market-production/operator_events_history", toString(toDate(timestamp_sub(DAY, 7, now()))))
-- where 
-- class_name = 'move_until_demand'
-- ) as oehmu

$parse = DateTime::Parse('%Y-%m-%dT%H:%M:%S');
$now = CurrentUtcDatetime();
$datetime_parse_tz = DateTime::Parse("%Y-%m-%d %H:%M:%S %Z");
$datetime_parse = DateTime::Format("%Y-%m-%d %H:%M:%S");
$today = CurrentUtcDate();
$today_str = cast($today as string);
$yasterday_str = cast($today - Interval('P1D') as string); 


$operator_tag_list_ts = [
    'DEFERRED_COURIER'
    , 'WIDE_INTERVAL'
];

$cube = '//home/market/production/mstat/analyst/regular/cubes_vertica/cube_new_order_dict';
$accept_time_on_lavki = '//home/taxi-delivery/analytics/dev/k2/accept_time_on_lavki';
-- $operator_events_history = '//home/taxi/testing/export/taxi-logistic-platform-market-production/operator_events_history';


-- K2
$K2request_log = '//home/delivery-dwh/ods/logistic_platform/request_log';
$K2planned_transfer_log = '//home/delivery-dwh/ods/logistic_platform/planned_transfer_log';
$K2operator_event_log = '//home/delivery-dwh/ods/logistic_platform/operator_event_log';

-- TS 
$TSrequest_log = '//home/delivery-dwh/ods/logistic_platform_market/request_log';
$TSplanned_transfer_log = '//home/delivery-dwh/ods/logistic_platform_market/planned_transfer_log';
$TSoperator_event_log = '//home/delivery-dwh/ods/logistic_platform_market/operator_event_log';

$month_start = '2022-01-01';
$now = CurrentUtcDatetime();

$SAVE_TO = '//home/taxi-delivery/analytics/production/ndd/collecting_strange_statuses/monitoring_profitability_of_statuses';

$SAVE_TO_2 = '//home/taxi-delivery/analytics/production/ndd/collecting_strange_statuses/monitoring_profitability_of_statuses_history';


--K2

$request_logK2 = (
    select 
        request_id
        , request_code
        , utc_created_dttm
        , utc_event_dttm
        , ListHead(Yson::ConvertToStringList(operator_tag_list)) as operator_tag_list
    from range($K2request_log, $month_start)
    where ListHead(Yson::ConvertToStringList(operator_tag_list)) = 'ON_DEMAND'
    and substring(utc_created_dttm,0,10) > $month_start

);
$planned_transfer_logK2 = (
    select 
        request_id
        , MAX(external_order_id) as external_order_id
    from range($K2planned_transfer_log, $month_start)
    group by request_id
);
$together = (
    select 
        req.request_id as request_id
        , request_code
        , utc_created_dttm
        , utc_event_dttm
        , operator_tag_list
        , external_order_id
    from $request_logK2 as req
    left join $planned_transfer_logK2 as plan on req.request_id = plan.request_id
);


$total_k2 = (
    select
        request_id
        , if (request_id is not null, 'k2', null) as product
        , request_code
        , some(utc_created_dttm) as utc_created_dttm
        , some(t.utc_event_dttm) as utc_event_dttm
        , some(operator_tag_list) as operator_tag_list
        , some(t.external_order_id) as external_order_id
        , some(event_status) as event_status
        , some(operator_code) as operator_code
        , some(operator_comment) as operator_comment
        , some(operator_event_type) as operator_event_type
        , some(event.utc_event_dttm) as utc_event_dttm_log
        , max( if (operator_event_type = 'in_depot', event.utc_event_dttm, null)) as utc_time_in_depot
        , min( if (operator_event_type = 'in_depot', event.utc_event_dttm, null)) as utc_time_in_depot_min
        , some( if (operator_event_type = 'canceled', event.utc_event_dttm, null)) as utc_time_canceled
        , max( if (operator_event_type = 'delivered', event.utc_event_dttm, null)) as utc_time_delivered
        , some( if (operator_event_type = 'delivered_finish', event.utc_event_dttm, null)) as utc_time_delivered_finish
        , some( if (operator_event_type = 'ordered', event.utc_event_dttm, null)) as utc_time_ordered
        , some( if (operator_event_type = 'performer_lookup', event.utc_event_dttm, null)) as utc_time_performer_lookup
        , some( if (operator_event_type = 'returned_to_vendor', event.utc_event_dttm, null)) as utc_time_returned_to_vendor
        , some( if (operator_event_type = 'auto_ordered', event.utc_event_dttm, null)) as utc_time_auto_ordered
        , max( if (operator_event_type = 'ready_for_delivery', event.utc_event_dttm, null)) as utc_ready_for_delivery
        , max( if (operator_event_type = 'repeated', event.utc_event_dttm, null)) as utc_repeated
        , max( if (operator_event_type = 'courier_assigned', event.utc_event_dttm, null)) as utc_courier_assigned
        , max( if (operator_event_type = 'delivering', event.utc_event_dttm, null)) as utc_delivering
    from $together as t 
    left join range($K2operator_event_log,$month_start) as event on t.external_order_id = event.external_order_id
    group by t.request_id as request_id
        , t.request_code as request_code

);


-- TS
$request_logTS = (
    select 
        request_id
        , request_code
        , utc_created_dttm
        , utc_event_dttm
        , case 
            WHEN ListHas(Yson::ConvertToStringList(operator_tag_list), "WIDE_INTERVAL") = true then 'WIDE_INTERVAL'
            when ListHas(Yson::ConvertToStringList(operator_tag_list), "DEFERRED_COURIER") = true then 'DEFERRED_COURIER'
            else NULL 
        end as operator_tag_list
    from range($TSrequest_log, $month_start)
    where 1=1 --ListHead(Yson::ConvertToStringList(operator_tag_list)) in $operator_tag_list_ts
    -- and  (Yson::YPathString(operator_tag_list, '/operator_tags/0') = 'DEFERRED_COURIER'
    --  or Yson::YPathString(operator_tag_list, '/operator_tags/1') = 'WIDE_INTERVAL')
    and substring(utc_created_dttm,0,10) > $month_start

);
$planned_transfer_logTS = (
    select 
        request_id
        , MAX(external_order_id) as external_order_id
    from range($TSplanned_transfer_log, $month_start)
    group by request_id
);
$togetherTS = (
    select 
        req.request_id as request_id
        , request_code
        , utc_created_dttm
        , utc_event_dttm
        , operator_tag_list
        , external_order_id
    from $request_logTS as req
    left join $planned_transfer_logTS as plan on req.request_id = plan.request_id
);


$total_ts = (
    select
        request_id
        , if (request_id is not null, 'timeslot or wideslot', null) as product
        , request_code
        , some(utc_created_dttm) as utc_created_dttm
        , some(t.utc_event_dttm) as utc_event_dttm
        , some(operator_tag_list) as operator_tag_list
        , some(t.external_order_id) as external_order_id
        , some(event_status) as event_status
        , some(operator_code) as operator_code
        , some(operator_comment) as operator_comment
        , some(operator_event_type) as operator_event_type
        , some(event.utc_event_dttm) as utc_event_dttm_log
        , max( if (operator_event_type = 'in_depot', event.utc_event_dttm, null)) as utc_time_in_depot
        , min( if (operator_event_type = 'in_depot', event.utc_event_dttm, null)) as utc_time_in_depot_min
        , some( if (operator_event_type = 'canceled', event.utc_event_dttm, null)) as utc_time_canceled
        , max( if (operator_event_type = 'delivered', event.utc_event_dttm, null)) as utc_time_delivered
        , some( if (operator_event_type = 'delivered_finish', event.utc_event_dttm, null)) as utc_time_delivered_finish
        , some( if (operator_event_type = 'ordered', event.utc_event_dttm, null)) as utc_time_ordered
        , some( if (operator_event_type = 'performer_lookup', event.utc_event_dttm, null)) as utc_time_performer_lookup
        , some( if (operator_event_type = 'returned_to_vendor', event.utc_event_dttm, null)) as utc_time_returned_to_vendor
        , some( if (operator_event_type = 'auto_ordered', event.utc_event_dttm, null)) as utc_time_auto_ordered
        , max( if (operator_event_type = 'ready_for_delivery', event.utc_event_dttm, null)) as utc_ready_for_delivery
        , max( if (operator_event_type = 'repeated', event.utc_event_dttm, null)) as utc_repeated
        , max( if (operator_event_type = 'courier_assigned', event.utc_event_dttm, null)) as utc_courier_assigned
        , max( if (operator_event_type = 'delivering', event.utc_event_dttm, null)) as utc_delivering
    from $togetherTS as t 
    left join range($TSoperator_event_log,$month_start) as event on t.external_order_id = event.external_order_id
    group by t.request_id as request_id
        , t.request_code as request_code

);

$total_all = (

    select * 
    from $total_k2

    union all 

    select * 
    from $total_ts

);

$cube_info = (
    select 
        id
        , max(delivery_attribute_delivery_arrived_pickup_point_45_datetime) as delivery_attribute_delivery_arrived_pickup_point_45_datetime
        , max(delivery_attribute_delivery_transmitted_to_recipient_49_datetime) as delivery_attribute_delivery_transmitted_to_recipient_49_datetime
        , max(delivery_attribute_delivery_delivered_50_datetime) as delivery_attribute_delivery_delivered_50_datetime
        , max(delivery_attribute_delivery_courier_search_31_datetime) as delivery_attribute_delivery_courier_search_31_datetime
        , max (delivery_attribute_delivery_courier_found_32_datetime) as delivery_attribute_delivery_courier_found_32_datetime
        , max(delivery_attribute_delivery_courier_in_transit_to_sender_33_datetime) as delivery_attribute_delivery_courier_in_transit_to_sender_33_datetime
        , max(delivery_attribute_delivery_transportation_recipient_48_datetime) as delivery_attribute_delivery_transportation_recipient_48_datetime
        , max(delivery_attribute_canceled_410_datetime) as delivery_attribute_canceled_410_datetime
        , max(delivery_attribute_return_arrived_delivery_70_datetime) as delivery_attribute_return_arrived_delivery_70_datetime
    from $cube
    group by id
);

$with_info_from_market = (
    select  
        t.*
        , delivery_attribute_delivery_arrived_pickup_point_45_datetime
        , delivery_attribute_delivery_transmitted_to_recipient_49_datetime
        , delivery_attribute_delivery_delivered_50_datetime
        , delivery_attribute_delivery_courier_search_31_datetime
        , delivery_attribute_delivery_courier_found_32_datetime
        , delivery_attribute_delivery_courier_in_transit_to_sender_33_datetime
        , delivery_attribute_delivery_transportation_recipient_48_datetime
        , delivery_attribute_canceled_410_datetime
        , delivery_attribute_return_arrived_delivery_70_datetime
    from $total_all as t
    left join $cube_info as c on t.request_code = cast(c.id as string)
);

$sec_info = (
    Select 
        w.* 
        , cast(a.delivered_to_lavka as String) as delivered_to_lavka
        , a.order_id as order_id
        , DateTime::ToSeconds(DateTime::MakeTzDatetime(DateTime::Update($parse(delivery_attribute_delivery_arrived_pickup_point_45_datetime), "Europe/Moscow" as Timezone))) as SEC_delivery_arrived_pickup_point_45
        , DateTime::ToSeconds(DateTime::MakeTzDatetime(DateTime::Update($parse(delivery_attribute_delivery_transmitted_to_recipient_49_datetime), "Europe/Moscow" as Timezone))) as SEC_delivery_transmitted_to_recipient_49
        , DateTime::ToSeconds(DateTime::MakeTzDatetime(DateTime::Update($parse(delivery_attribute_delivery_delivered_50_datetime), "Europe/Moscow" as Timezone))) as SEC_delivery_attribute_delivery_delivered_50
        , DateTime::ToSeconds(DateTime::MakeTzDatetime(DateTime::Update($parse(delivery_attribute_delivery_courier_search_31_datetime), "Europe/Moscow" as Timezone))) as SEC_delivery_attribute_delivery_courier_search_31_datetime
        , DateTime::ToSeconds(DateTime::MakeTzDatetime(DateTime::Update($parse(delivery_attribute_delivery_courier_found_32_datetime), "Europe/Moscow" as Timezone))) as SEC_delivery_attribute_delivery_courier_found_32_datetime
        , DateTime::ToSeconds(DateTime::MakeTzDatetime(DateTime::Update($parse(delivery_attribute_delivery_courier_in_transit_to_sender_33_datetime), "Europe/Moscow" as Timezone))) as SEC_delivery_attribute_delivery_courier_in_transit_to_sender_33_datetime
        , DateTime::ToSeconds(DateTime::MakeTzDatetime(DateTime::Update($parse(delivery_attribute_delivery_transportation_recipient_48_datetime), "Europe/Moscow" as Timezone))) as SEC_delivery_attribute_delivery_transportation_recipient_48_datetime
        , DateTime::ToSeconds(DateTime::MakeTzDatetime(DateTime::Update($parse(delivery_attribute_return_arrived_delivery_70_datetime), "Europe/Moscow" as Timezone))) as SEC_delivery_attribute_return_arrived_delivery_70_datetime
        , DateTime::ToSeconds(DateTime::MakeDatetime(DateTime::ParseIso8601(a.delivered_to_lavka))) as SEC_delivered_to_lavka
        , DateTime::ToSeconds(DateTime::MakeDatetime(DateTime::ParseIso8601(utc_time_in_depot))) as SEC_time_in_depot
        , DateTime::ToSeconds(DateTime::MakeDatetime(DateTime::ParseIso8601(utc_time_in_depot_min))) as SEC_time_in_depot_min
        , DateTime::ToSeconds(DateTime::MakeDatetime(DateTime::ParseIso8601(utc_time_canceled))) as SEC_time_canceled
        , DateTime::ToSeconds(DateTime::MakeDatetime(DateTime::ParseIso8601(utc_time_delivered))) as SEC_time_delivered
        , DateTime::ToSeconds(DateTime::MakeDatetime(DateTime::ParseIso8601(utc_time_delivered_finish))) as SEC_time_delivered_finish
        , DateTime::ToSeconds(DateTime::MakeDatetime(DateTime::ParseIso8601(utc_time_ordered))) as SEC_time_ordered
        , DateTime::ToSeconds(DateTime::MakeDatetime(DateTime::ParseIso8601(utc_time_performer_lookup))) as SEC_time_performer_lookup
        , DateTime::ToSeconds(DateTime::MakeDatetime(DateTime::ParseIso8601(utc_time_returned_to_vendor))) as SEC_time_returned_to_vendor
        , DateTime::ToSeconds(DateTime::MakeDatetime(DateTime::ParseIso8601(utc_time_auto_ordered))) as SEC_time_auto_ordered
        , DateTime::ToSeconds(DateTime::MakeDatetime(DateTime::ParseIso8601(utc_repeated))) as SEC_time_repeated
        , case 
            when operator_code = 'lavka' and product = 'k2' then 'k2_lavka'
            when operator_code = 'taxi-external' and product = 'k2' then 'k2_taxi-external'
            else 'not k2'
        end as k2_info
    from $with_info_from_market as w 
    left join $accept_time_on_lavki as a on w.request_code = a.order_id

);



$statuses = 
    (SELECT 
        request_id
        , product
        , request_code
        , operator_tag_list
        , operator_code
        , k2_info
        , case 
        -- Заказ отгрузила маркет курьерка, но не отправили 45ЧП в течение 24 часов
            when delivered_to_lavka is not null
                 and delivery_attribute_delivery_arrived_pickup_point_45_datetime = '1970-01-01T00:00:00' 
                 and DateTime::ToSeconds($now) - SEC_delivered_to_lavka > 86400
            then 'заказ на лавке без 45ЧП'

        -- Было событие, что посылка на лавке (in_depot/ 45ЧП) и отправили 410ЧП
            when utc_time_in_depot is not null
                 and delivery_attribute_canceled_410_datetime != '1970-01-01T00:00:00' 
                 then 'Было событие, что посылка на лавке (in_depot/ 45ЧП) и отправили 410ЧП'
        
        -- После 49ЧП не появился 50ЧП и прошло более 25 часов
         
            when delivery_attribute_delivery_transmitted_to_recipient_49_datetime != '1970-01-01T00:00:00'
            
            -- and substring(delivery_attribute_delivery_transmitted_to_recipient_49_datetime, 0,10) != $yasterday_str
            and delivery_attribute_delivery_delivered_50_datetime = '1970-01-01T00:00:00' 
            and delivery_attribute_return_arrived_delivery_70_datetime = '1970-01-01T00:00:00'
            and utc_time_delivered > utc_time_in_depot
            and DateTime::ToSeconds($now) - SEC_delivery_transmitted_to_recipient_49 > 90000 
                then 'После 49ЧП не появился 50ЧП и прошло более 25 часов'
            

        -- уточнения по 4 пункту: После ordered от лавки (performer_lookup от cargo) не пришел delivered или in_depot через 3 часа (для широких и часовых слотов после auto_ordered или 37ЧП) для K2
        -- K2
            when -- utc_time_performer_lookup is not null
                utc_time_ordered is not null 
                    and utc_time_delivered is null
                    and utc_time_canceled is null 
                -- and (utc_time_ordered > utc_time_in_depot 
                --         or utc_time_ordered > utc_time_delivered)
                --     or (utc_courier_assigned > utc_time_in_depot
                --                 or  utc_courier_assigned > utc_time_delivered)
                --     or (utc_ready_for_delivery > utc_time_in_depot
                --                 or utc_ready_for_delivery > utc_time_delivered)
                --     or (utc_delivering > utc_time_in_depot 
                --             or utc_delivering > utc_time_delivered)
                
                and DateTime::ToSeconds($now) - SEC_time_ordered > 10800 then 'K2: После ordered от лавки не пришел delivered или in_depot через 3 часа'
            

    -- уточнения по 4 пункту: После ordered от лавки (performer_lookup от cargo) не пришел delivered или in_depot через 3 часа (для широких и часовых слотов после auto_ordered или 37ЧП) для ЧС и ШС
            when utc_time_auto_ordered is not null
                and utc_time_delivered is null
                    and utc_time_canceled is null 
                    -- and (utc_time_auto_ordered > utc_time_in_depot 
                    --         or utc_time_auto_ordered > utc_time_delivered)
                    --     or (utc_courier_assigned > utc_time_in_depot
                    --             or  utc_courier_assigned > utc_time_delivered)
                    --     or (utc_ready_for_delivery > utc_time_in_depot
                    --             or utc_ready_for_delivery > utc_time_delivered)
                    --     or (utc_delivering > utc_time_in_depot 
                    --         or utc_delivering > utc_time_delivered)
                    and DateTime::ToSeconds($now) - SEC_time_auto_ordered > 10800 then 'ЧС/ШС: После auto_ordered от лавки (performer_lookup от cargo) не пришел delivered или in_depot через 3 часа. Застрял на 48ЧП'


        --Для широких слотов+ЧС: Заказ не уехал с лавки (статус доставлено/ отмены) > 72 часов со статуса in_depot, для К2 пока 144 часа, потом поменяем на 72
            when 
                 (utc_time_delivered is null or utc_time_in_depot > utc_time_delivered)
                    and utc_time_canceled  is null
                and DateTime::ToSeconds($now) - SEC_time_in_depot_min > 259200
            then 'c момента статуса in_depot прошло более 72 часов'
                

        -- После canceled от Лавки не пришел returned_to_vendor в течение 72 часов (уточняю)
            when utc_time_canceled is not null and utc_time_returned_to_vendor is null and DateTime::ToSeconds($now) - SEC_time_canceled > 259200 then 'После canceled от Лавки не пришел returned_to_vendor в течение 72 часов'

        -- Для часовых/широких слотов не произошел автовызов курьера, при этом не было отката в по клику
            when product = 'timeslot or wideslot' 
            and utc_time_auto_ordered is null 
            and substring(utc_time_in_depot,0,10) != substring(utc_time_ordered,0,10)       
            then 'не произошел автовызов курьера, при этом не было отката в по клику в тот же день'
            
            
            else 'good'
        end as current_situation_on_the_order
        , utc_created_dttm
        , utc_time_ordered
        , delivered_to_lavka
        , delivery_attribute_delivery_arrived_pickup_point_45_datetime
        , utc_time_in_depot
        , utc_time_performer_lookup
        , utc_time_auto_ordered
        , delivery_attribute_delivery_transmitted_to_recipient_49_datetime
        , delivery_attribute_delivery_delivered_50_datetime
        , $datetime_parse(DateTime::FromSeconds(DateTime::ToSeconds(DateTime::MakeTzDatetime(DateTime::Update($parse(delivery_attribute_delivery_delivered_50_datetime), "Europe/Moscow" as Timezone))))) as utc_delivery_attribute_delivery_delivered_50_datetime
        , $datetime_parse(DateTime::FromSeconds(DateTime::ToSeconds(DateTime::MakeTzDatetime(DateTime::Update($parse(delivery_attribute_delivery_transmitted_to_recipient_49_datetime), "Europe/Moscow" as Timezone))))) as utc_delivery_attribute_delivery_transmitted_to_recipient_49_datetime
        , $datetime_parse(DateTime::FromSeconds(DateTime::ToSeconds(DateTime::MakeTzDatetime(DateTime::Update($parse(delivery_attribute_delivery_arrived_pickup_point_45_datetime), "Europe/Moscow" as Timezone))))) as utc_delivery_attribute_delivery_arrived_pickup_point_45_datetime
        , $datetime_parse(DateTime::FromSeconds(DateTime::ToSeconds(DateTime::MakeTzDatetime(DateTime::Update($parse(delivery_attribute_delivery_transportation_recipient_48_datetime), "Europe/Moscow" as Timezone))))) as utc_delivery_attribute_delivery_transportation_recipient_48_datetime
        , $datetime_parse(DateTime::FromSeconds(DateTime::ToSeconds(DateTime::MakeTzDatetime(DateTime::Update($parse(delivery_attribute_delivery_courier_in_transit_to_sender_33_datetime), "Europe/Moscow" as Timezone))))) as utc_delivery_attribute_delivery_courier_in_transit_to_sender_33_datetime
        , $datetime_parse(DateTime::FromSeconds(DateTime::ToSeconds(DateTime::MakeTzDatetime(DateTime::Update($parse(delivery_attribute_delivery_courier_found_32_datetime), "Europe/Moscow" as Timezone))))) as utc_delivery_attribute_delivery_courier_found_32_datetime
        , $datetime_parse(DateTime::FromSeconds(DateTime::ToSeconds(DateTime::MakeTzDatetime(DateTime::Update($parse(delivery_attribute_delivery_courier_search_31_datetime), "Europe/Moscow" as Timezone))))) as utc_delivery_attribute_delivery_courier_search_31_datetime
        , $datetime_parse(DateTime::FromSeconds(DateTime::ToSeconds(DateTime::MakeTzDatetime(DateTime::Update($parse(delivery_attribute_return_arrived_delivery_70_datetime), "Europe/Moscow" as Timezone))))) as utc_delivery_attribute_return_arrived_delivery_70_datetime
        , $datetime_parse(DateTime::FromSeconds(DateTime::ToSeconds(DateTime::MakeTzDatetime(DateTime::Update($parse(delivery_attribute_canceled_410_datetime), "Europe/Moscow" as Timezone))))) as utc_delivery_attribute_canceled_410_datetime
        , $datetime_parse(DateTime::FromSeconds(
                DateTime::ToSeconds(
                    DateTime::MakeTzDatetime(
                        DateTime::Update(
                            cast(delivered_to_lavka as DateTime)
                            , "Europe/Moscow" as Timezone
                        )
                    )
                )
        )) as utc_delivered_to_lavka
        , utc_time_delivered
        , utc_time_canceled
        , utc_time_delivered_finish
        , utc_time_returned_to_vendor
    from $sec_info
);

$statusess = 
    (select s.*
        , request_id || "_" || current_situation_on_the_order as request_id_current_situation_on_the_order
    from $statuses as s
    where 1=1
    and k2_info != 'k2_taxi-external')
;

insert into $SAVE_TO WITH TRUNCATE 
select * from $statusess;

-- способ сохранить все статусы без изменений 

$save_table = 
    (select *
    from $statusess 
    where request_id_current_situation_on_the_order not in (select request_id_current_situation_on_the_order from $SAVE_TO_2)
);

INSERT INTO $SAVE_TO_2
select * from $save_table;
