use hahn;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;
-- LOGDATA-1373
-- author: ikhomyanin

-- Стоимость услуг по приему платежей - ???

$REQUEST_HISTORY = '//home/taxi/testing/export/taxi-logistic-platform-production/requests_history';
$RESOURCES_HISTORY = '//home/taxi/testing/export/taxi-logistic-platform-production/resources_history';
$PLANNED_NODES_HISTORY = '//home/taxi/testing/export/taxi-logistic-platform-production/planned_nodes_history';
$OPERATOR_EVENTS_HISTORY = '//home/taxi/testing/export/taxi-logistic-platform-production/operator_events_history';
$PLANNED_TRANSFERS_HISTORY = '//home/taxi/testing/export/taxi-logistic-platform-production/planned_transfers_history';
$NDD_CALCULATIONS = '//home/taxi/production/replica/postgres/cargo_pricing/ndd_calculations';
$PAYMENTS_HISTORY = '//home/taxi/testing/export/taxi-logistic-platform-production/payment_history';
$BILLING_TASKS_HISTORY = '//home/taxi/production/replica/postgres/cargo_payments/billing_tasks_history';
$POST_PAY_TABLE = '//home/taxi-delivery/analytics/production/ndd/post_pay_table';

$REQUEST_DATAMART = '//home/taxi-delivery/analytics/production/ndd/requests_datamart';

$SAVE_TO = '//home/taxi-delivery/analytics/production/ndd/delivered_requests';

$FINAL_STATUS = (
    'external_order_finished'
    , 'external_order_canceled'
);

$START_DATE = '2022-01-01';

$dttm_format = DateTime::Format('%Y-%m-%d %H:%M:%S');
$dttm_from_seconds = ($sec) -> {
    return $dttm_format(DateTime::FromSeconds(cast($sec as uint32)));
};

$features = ($meta_data) -> { 
    return Yson::YPath(Yson::Parse($meta_data), "/features") 
};

$get_physical = ($meta_data) -> {
    return ListSkipWhile(Yson::ConvertToList($features($meta_data)), ($x) -> {
        return Yson::ConvertToString(DictLookup(Yson::ConvertToDict($x), 'class_name')) != 'physical'
    })
};

$pay_method = ($meta_data) -> {
    return Yson::YPathString(ListSkipWhile(Yson::ConvertToList($features($meta_data)), ($x) -> {
        return Yson::ConvertToString(DictLookup(Yson::ConvertToDict($x), 'class_name')) != 'billing';
    })[0], '/resource_billing_feature/payment_method');
};

$delivery_cost = ($meta_data) -> {
    return Yson::YPathUint64(ListSkipWhile(Yson::ConvertToList($features($meta_data)), ($x) -> {
        return Yson::ConvertToString(DictLookup(Yson::ConvertToDict($x), 'class_name')) != 'billing'
    })[0], '/resource_billing_feature/delivery_cost');
};

$cargo_pricing = ($meta_data) -> {
    return Yson::YPathString(ListSkipWhile(Yson::ConvertToList($features($meta_data)), ($x) -> {
        return Yson::ConvertToString(DictLookup(Yson::ConvertToDict($x), 'class_name')) != 'billing';
    })[0], '/resource_billing_feature/cargo_pricing');
};

$extract_calculation_id = ($cargo_pricing) -> {
    $first_part = substring($cargo_pricing, find($cargo_pricing, 'cargo-pricing/ndd/v1/'));
    $second_part = substring($first_part, 0, find($first_part, ' '));

    return $second_part;
};

$extract_items_from_box = ($meta_data) -> {
    return Yson::YPathList($meta_data, '/resource_physical_feature/items')
};

$get_all_items = ($meta_data) -> {
    return ListFlatten(ListMap($get_physical($meta_data), $extract_items_from_box));
};

$extract_total_price = ($meta_data) -> {
    return Yson::YPathUint64($meta_data, '/unit_price') * Yson::YPathUint64($meta_data, '/count')
};
$extract_total_assessed_price = ($meta_data) -> {
    return Yson::YPathUint64($meta_data, '/assessed_unit_price') * Yson::YPathUint64($meta_data, '/count')
};

$all_prices = ($meta_data) -> {
    return ListMap($meta_data, $extract_total_price);
};
$all_assessed_prices = ($meta_data) -> {
    return ListMap($meta_data, $extract_total_assessed_price);
};

$extract_weight_from_box = ($meta_data) -> {
    return Yson::YPathInt64($meta_data, '/resource_physical_feature/weight')
};

$get_all_weight = ($meta_data) -> {
    return (ListMap($get_physical($meta_data), $extract_weight_from_box));
};

$all_weight = ($meta_data) -> {
    return ListSum($meta_data);
};

$coords_x = ($meta_data) -> { 
    return Yson::YPathDouble(Yson::Parse($meta_data), "/node_location/temporary_location/coord/x") 
};
$coords_y = ($meta_data) -> { 
    return Yson::YPathDouble(Yson::Parse($meta_data), "/node_location/temporary_location/coord/y") 
};

$extract_address = ($meta_data) -> {
    $country = coalesce(Yson::YPathString($meta_data, '/node_location/temporary_location/details/country'), ''); 
    $settlement = coalesce(Yson::YPathString($meta_data, '/node_location/temporary_location/details/settlement'), '');
    $street = coalesce(Yson::YPathString($meta_data, '/node_location/temporary_location/details/street'), ''); 
    $house = coalesce(Yson::YPathString($meta_data, '/node_location/temporary_location/details/house'), ''); 
    $room = coalesce(Yson::YPathString($meta_data, '/node_location/temporary_location/details/room'), ''); 

    $full_address = coalesce(Yson::YPathString($meta_data, '/node_location/temporary_location/details/full_address'), '');

    -- СХЕМА, ПО КОТОРОЙ СКЛЕИВАЕТСЯ АДРЕС
    $address = $country || ', ' || $settlement || ', ' || $street || ', ' || $house || ', ' || $room;

    return coalesce($full_address, $address);
};

$extract_policy = ($unpacked_data) -> {
    return Yson::YPathString($unpacked_data, '/requested_processing_interval/policy');
};
 
$policy_mapping = ($policy) -> {
    $mapped = case 
        when $policy = 'min_by_request' then 'По запросу пользователя (по клику)'
        when $policy = 'interval_with_fees' then 'Максимально близко к интервалу'
        when $policy = 'interval_strict' then 'Точно в интервал'
        when $policy = 'AFAP' then 'Экспресс'
        when $policy = 'self_pickup' then 'ПВЗ'
        else 'ERROR'
    end;

    return $mapped;
};

$requests = (
    select request_id
        , some(employer_code) as employer_code
        , some(request_code) as request_code
        , Yson::YPathString(max_by(unpacked_data, history_event_id), '/corp_client_id') as corp_client_id
        , max_by(status, history_event_id) as last_status
        , $dttm_from_seconds(max_by(history_timestamp, history_event_id)) as utc_last_status_update_dttm
        , $dttm_from_seconds(some(created_at)) as utc_created_dttm
        , max_by(unpacked_data, history_event_id) as requests_unpacked_data
    from range($REQUEST_HISTORY, $START_DATE)
    where 1=1
        and employer_code != 'beru'
    group by request_id
    having substring($dttm_from_seconds(some(created_at)), 0, 10) >= $START_DATE
);

$resources = (
    select request_id
        , max_by(unpacked_data, history_event_id) as resources_unpacked_data
        , $pay_method(max_by(unpacked_data, history_event_id)) as payment_method
        , $delivery_cost(max_by(unpacked_data, history_event_id)) as delivery_cost
        , ListSum($all_prices($get_all_items(max_by(unpacked_data, history_event_id)))) as items_price
        , ListAggregate($all_prices($get_all_items(max_by(unpacked_data, history_event_id))), AggregationFactory("Count")) as items_cnt
        , ListSum($all_assessed_prices($get_all_items(max_by(unpacked_data, history_event_id)))) as items_assessed_price
        , $all_weight($get_all_weight(max_by(unpacked_data, history_event_id))) as weight
        , $extract_calculation_id($cargo_pricing(max_by(unpacked_data, history_event_id))) as cargo_pricing_id
    from range($RESOURCES_HISTORY, $START_DATE)
    group by request_id
);

$nodes = (
    select request_id
        , max_by(unpacked_data, history_event_id) as nodes_unpacked_data
        , $extract_policy(max_by(unpacked_data, history_event_id)) as policy
        , $policy_mapping($extract_policy(max_by(unpacked_data, history_event_id))) as policy_mapping
        , $coords_x(max_by(unpacked_data, history_event_id)) as x_coord
        , $coords_y(max_by(unpacked_data, history_event_id)) as y_coord
        , $extract_address(max_by(unpacked_data, history_event_id)) as address
    from range($PLANNED_NODES_HISTORY, $START_DATE)
    where 1=1
        and (
            Yson::YPathString(unpacked_data, '/node_code') = 'n_to' 
            or 
            Yson::YPathString(unpacked_data, '/node_code') = 'node_to'
        )
    group by request_id
);

$request_operator_order = (
    SELECT  external_order_id,
            SOME(request_id) as request_id
    FROM RANGE($PLANNED_TRANSFERS_HISTORY, $START_DATE)
    GROUP BY external_order_id
);

$delivered = (
    select
        external_order_id
        , min($dttm_from_seconds(event_instant)) as utc_delivered_dttm
    from RANGE($OPERATOR_EVENTS_HISTORY, $START_DATE)
    where
        class_name in $FINAL_STATUS
    group by external_order_id
);

$parse_yson_from_string_yson = ($string_yson) -> {
    return Yson::ParseJson(Cast(Yson::ConvertToString($string_yson) as Json));
};

$extract_stages_increment = ($stages) -> {
    $totals = ListMap(
        Yson::ConvertToList($stages), 
        ($x) -> {
            return cast(Yson::YPathString($x, '/dump/total') as Double)
        }
    );

    $stage_names = ListMap(
        Yson::ConvertToList($stages), 
        ($x) -> {
            return Yson::YPathString($x, '/stage_name')
        }
    );

    $previous_totals = ListExtend(AsList(0), $totals);
    $previous_totals_wo_last = ListTake($previous_totals, ListLength($previous_totals) - 1);

    $zipped = ListZip($totals, $previous_totals_wo_last);

    $final = ListMap($zipped, ($pair) -> {
        return Math::Round($pair.0 - $pair.1, -2);
    });

    return ListZip($stage_names, $final);
};

$stage_payment = ($stage_increments, $stage) -> {
    $stage_pair = ListFilter($stage_increments, ($pair) -> {
        return $pair.0 = $stage;
    });

    return ListHead($stage_pair).1;
};

$calculations = (
    select id
        , 1.0 * Yson::YPathDouble($parse_yson_from_string_yson(price), '/total') / 100   as price_total
        , 1.0 * Yson::YPathDouble($parse_yson_from_string_yson(price), '/total_without_vat') / 100  as price_total_without_vat
        , $stage_payment(
            $extract_stages_increment(
                $parse_yson_from_string_yson(calc_stages_dump)
            ), 
            'AddPhysical'
        ) as AddPhysical_amount
        , $stage_payment($extract_stages_increment($parse_yson_from_string_yson(calc_stages_dump)), 'AddReturn') as AddReturn_amount
        , $stage_payment($extract_stages_increment($parse_yson_from_string_yson(calc_stages_dump)), 'AddIntake') as AddIntake_amount
        , $stage_payment($extract_stages_increment($parse_yson_from_string_yson(calc_stages_dump)), 'AddItems') as AddItems_amount
        , $stage_payment($extract_stages_increment($parse_yson_from_string_yson(calc_stages_dump)), 'AddVat') as AddVat_amount
        , tariff_id
    from $NDD_CALCULATIONS
);

$payments = (
    select request_id
        , some(if(account_type = 'full_price', amount, null)) as full_price_amount
        , some(if(account_type = 'full_price', currency, null)) as full_price_currency
        , some(if(account_type = 'full_price', status, null)) as full_price_status
        , some(if(account_type = 'delivery', amount, null)) as delivery_amount
        , some(if(account_type = 'delivery', currency, null)) as delivery_currency
        , some(if(account_type = 'delivery', status, null)) as delivery_status
    from range($PAYMENTS_HISTORY, $START_DATE)
    where 1=1
        and status in ('Approved', 'approved')
    group by request_id
);

$billing = (
    select order_id as request_id
        , billing_doc_id
        , Yson::ParseJson(Cast(Yson::ConvertToString(meta) as Json)) as meta
        , Yson::YPathString(Yson::ParseJson(Cast(Yson::ConvertToString(meta) as Json)), '/tariff') as tariff
        , Yson::YPathString(Yson::ParseJson(Cast(Yson::ConvertToString(meta) as Json)), '/geo_data/zone_id') as zone_id 
        , Yson::YPathString(Yson::ParseJson(Cast(Yson::ConvertToString(meta) as Json)), '/payment_method') as billing_payment_method
    from $BILLING_TASKS_HISTORY
    where 1=1
        and state in ('Approved', 'approved')
);

$postpayments = (
    select request_id
        , min(pon_status_last_update_dt) as pon_status_last_update_dt
        , min_by(payment_order_number, pon_status_last_update_dt) as payment_order_number
        , min_by(pon_amount, pon_status_last_update_dt) as pon_amount
        , min_by(pon_billing_doc_id, pon_status_last_update_dt) as pon_billing_doc_id
    from $POST_PAY_TABLE
    where 1=1
        and pon_status != 'CREATED'
        and pon_status is not null
    group by request_id
);

$final_df = (
    select *
    from $requests as requests
    left join $resources as resources on requests.request_id = resources.request_id
    left join $nodes as nodes on requests.request_id = nodes.request_id
    left join $request_operator_order as roo on requests.request_id = roo.request_id
    left join $delivered as delivered on roo.external_order_id = delivered.external_order_id
    left join $calculations as calculations on resources.cargo_pricing_id = calculations.id
    left join $payments as payments on payments.request_id = requests.request_id
    left join $billing as billing on payments.request_id = billing.request_id
    left join $postpayments as postpay on postpay.request_id = requests.request_id
);

insert into $SAVE_TO with truncate
select AddIntake_amount
    , AddItems_amount
    , AddItems_amount as corp_assessed_price_cost_rub -- Стоимость услуг оценочной стоимости
    , AddPhysical_amount
    , AddReturn_amount
    , AddVat_amount
    , AddVat_amount as corp_vat_cost_rub
    , AddIntake_amount + AddReturn_amount + AddPhysical_amount as corp_delivery_cost_rub -- Стоимость услуг доставки
    , address as delivery_address -- Адрес доставки
    , cargo_pricing_id as cargo_pricing_calculation_id
    , corp_client_id -- Corp_id
    , 1.0 * delivery_amount / 100 as cargo_payments_delivery_amount
    , 1.0 * delivery_cost / 100 as user_delivery_cost_rub -- Из низ за доставку (стоимость доставки для получателя)
    , employer_code -- префикс клиента
    , 1.0 * full_price_amount / 100 as cargo_payments_full_price_amount -- Принято с получателя
    , 1.0 * items_assessed_price / 100 as items_assessed_price_rub -- Оценочная стоимость
    , items_cnt
    , 1.0 * items_price / 100 as items_price_rub
    , last_status -- Финальный статус заказа
    , payment_method -- Способ оплаты
    , policy
    , policy_mapping -- Тип доставки (до двери, до ПВЗ, до ПСТ, по клику, SDD)
    , price_total as corp_total_cost_w_vat -- Суммарная стоимость доставки для корп клиента
    , price_total_without_vat as corp_total_cost_wo_vat -- Суммарная стоимость доставки для корп клиента без НДС
    , request_code -- Номер заказ (внешний)
    , external_order_id -- Номер заказ (тоже внешний)
    , request_id -- Request id 
    , tariff_id as cargo_pricing_tariff_id
    , utc_created_dttm
    , utc_delivered_dttm -- Дата доставки
    , utc_last_status_update_dttm
    , 1.0 * weight / 1000 as weight_kg -- Вес
    , x_coord as delivery_point_longitude
    , y_coord as delivery_point_latitude
    , zone_id -- Тарифная зона доставки
    , pon_status_last_update_dt
    , payment_order_number
    , pon_amount
    , pon_billing_doc_id
from $final_df;
