use hahn;

$STATION_TAGS = '//home/taxi/testing/export/taxi-logistic-platform-production/station_tags_history';
$STATIONS_HISTORY = '//home/taxi/testing/export/taxi-logistic-platform-production/stations_history';

$SAVE_TO = '//home/taxi-delivery/analytics/production/ndd/delivery_geo/all_edges';

$DAYS_GO_BACK = 14;

$START_DATE = cast(CurrentUtcDate() - Interval('P1D')*$DAYS_GO_BACK as String);

-- 1. Вытаскиваем все нужные теги
$TAG_NAMES = (
    'yd_new_supply_promise_reservation'
    , 'abstract_supply_promise_ydNEW_reservation'
);

$tags_raw = (
    select *
    from range($STATION_TAGS, $START_DATE)
    where 1=1
        and tag_name in $TAG_NAMES
);

-- 2. Берем актуальное состояние тега
$tags_raw_reduced = (
    select tag_id
        , max(history_event_id) as history_event_id
        , max_by(history_timestamp, history_event_id) as history_timestamp
        , max_by(class_name, history_event_id) as class_name
        , max_by(history_action, history_event_id) as history_action
        , max_by(object_id, history_event_id) as object_id
        , max_by(tag_name, history_event_id) as tag_name
        , max_by(unpacked_data, history_event_id) as unpacked_data
    from $tags_raw
    group by tag_id
);

-- 3. Парсим reservations

$parse_reservation = ($reservation) -> {
    $class_name = Yson::YPathString($reservation, '/area/class_name');
    $deliveries_limit = Yson::YPathInt64($reservation, '/deliveries_limit');
    $delivering_policy = Yson::YPathString($reservation, '/delivering_policy');
    $hr_interval = Yson::YPathString($reservation, '/interval/hr_interval');
    $id = coalesce(
        Yson::YPathString($reservation, '/area/station_area_object/station_id')
        , cast(Yson::YPathInt64($reservation, '/area/geo_id_area_object/geo_id') as String)
        , Yson::YPathString($reservation, '/area/polygon_area_object/polygon_name')
    );

    $struct = AsStruct(
        $class_name as class_name,
        $deliveries_limit AS deliveries_limit,
        $delivering_policy AS delivering_policy,
        $hr_interval as delivery_interval,
        $id as id
    );

    return $struct;
};

$extract_reservations = ($dropoff_reservations) -> {
    $reservations = ListMap($dropoff_reservations, $parse_reservation);

    return $reservations;
};

$tags_raw_reduced_parsed = (
    select class_name
        , history_action
        , history_event_id
        , history_timestamp
        , object_id
        , tag_id
        , tag_name
        , Yson::YPathString(unpacked_data, '/operator_id') as operator_id
        , Yson::YPathString(unpacked_data, '/pickup_interval') as pickup_interval
        , Yson::YPathString(unpacked_data, '/status') as status
        , $extract_reservations(Yson::YPathList(unpacked_data, '/dropoff_reservations')) as dropoff_reservations
    from $tags_raw_reduced
);

-- 4. Раскладываем резервейшены по строкам

$flattened = (
    select class_name as tag_class_name
        , dropoff_reservations
        , history_action
        , history_event_id
        , history_timestamp
        , object_id
        , operator_id
        , pickup_interval
        , status
        , tag_id
        , tag_name
    from $tags_raw_reduced_parsed
    flatten list by dropoff_reservations
);

$flattened_2 = (
    select *
    from $flattened
    flatten columns
);

-- 5. Получаем все трансферы

$all_transfers = (
    select class_name as destination_class_name
        , id as destination_id
        , delivering_policy
        , delivery_interval
        , object_id as source_station_id
        , operator_id
        , pickup_interval
        , status
    from $flattened_2
    where 1=1
        and substring(pickup_interval, 0, 10) >= cast(CurrentUtcDate() as String)
);

-- 6. Вытаскиваем типы станций

$all_stations = (
    select station_id
        , Yson::YPathDouble(max_by(unpacked_data, history_event_id), '/location/y') as latitude
        , Yson::YPathDouble(max_by(unpacked_data, history_event_id), '/location/x') as longitude
        , case 
            when Yson::YPathString(max_by(unpacked_data, history_event_id), '/station_full_name') is not null and Yson::YPathString(max_by(unpacked_data, history_event_id), '/station_full_name') != '' then Yson::YPathString(max_by(unpacked_data, history_event_id), '/station_full_name')
            else max_by(station_name, history_event_id)
        end as station_name
        -- , coalesce(Yson::YPathString(max_by(unpacked_data, history_event_id), '/station_full_name'), max_by(station_name, history_event_id)) as station_name
        , Yson::YPathString(max_by(unpacked_data, history_event_id), '/station_type') as station_type
    from range($STATIONS_HISTORY)
    group by station_id
);

-- 7. Клеим станции к трансферам

$all_transfers_meta = (
    select t1.*
        , s1.station_name as source_station_name
        , s1.station_type as source_station_type
        , s1.latitude as source_station_latitude
        , s1.longitude as source_station_longitude
        , s2.station_name as destination_station_name
        , s2.station_type as destination_station_type
        , s2.latitude as destination_station_latitude
        , s2.longitude as destination_station_longitude
    from $all_transfers as t1
    left join $all_stations as s1 on t1.source_station_id = s1.station_id
    left join $all_stations as s2 on t1.destination_id = s2.station_id
);

insert into $SAVE_TO with truncate
select *
from $all_transfers_meta;
