use hahn;

$ALL_EDGES = '//home/taxi-delivery/analytics/production/ndd/delivery_geo/all_edges';
$SAVE_TO = '//home/taxi-delivery/analytics/production/ndd/delivery_geo/all_routes';

$find_type = ($id, $type) -> {
    $parents = Geo::GetParents(cast($id as Int32));

    $parents_with_meta = ListMap(
        $parents, 
        ($parent) -> {
            return Geo::RegionById($parent);
        }
    );

    $type_region = ListFilter(
        $parents_with_meta, 
        ($parent) -> {
            return $parent.type = $type;
        }
    )[0];

    return $type_region;
};

$last_mile = (
    select *
    from $ALL_EDGES
    where 1=1
        and (destination_station_type != 'warehouse' or destination_station_type is null)
);

$mid_mile = (
    select *
    from $ALL_EDGES
    where 1=1
        and destination_station_type = 'warehouse'
);

$last_mile_distinct = (
    select distinct destination_class_name
        , destination_id
        , destination_station_latitude
        , destination_station_longitude
        , destination_station_name
        , destination_station_type
        , operator_id
        , source_station_id
        , source_station_latitude
        , source_station_longitude 
        , source_station_name
        , source_station_type
    from $last_mile
);

$mid_mile_distinct = (
    select distinct destination_class_name
        , destination_id
        , destination_station_latitude
        , destination_station_longitude
        , destination_station_name
        , destination_station_type
        , operator_id
        , source_station_id
        , source_station_latitude
        , source_station_longitude 
        , source_station_name
        , source_station_type
    from $mid_mile
);

$last_mile_pretty = (
    select 
    -- source point
        source_station_type as source_type 
        , source_station_id as source_id
        , source_station_name as source_name
        , $find_type(
            Geo::RegionByLocation(
                source_station_latitude 
                , source_station_longitude
            ).id
            , 5
        ).name as source_region 

    -- mid mile point 
        , null as mid_type
        , null as mid_id
        , null as mid_name
        , null as mid_region

    -- last mile point 
        , CASE 
            when destination_class_name = 'station' then destination_station_type
            else destination_class_name
        end as destination_type 
        , destination_id as destination_id
        , CASE 
            when destination_class_name = 'station' then destination_station_name
            when destination_class_name = 'geo_id_area' then Geo::RegionById(cast(destination_id as Int32)).name
            when destination_class_name = 'polygon' then destination_id
            else 'ERROR'
        end as destination_name
        , CASE 
            when destination_class_name = 'station' 
                then $find_type(
                    Geo::RegionByLocation(
                        destination_station_latitude 
                        , destination_station_longitude
                    ).id
                    , 5
                ).name
            when destination_class_name = 'geo_id_area' then $find_type(cast(destination_id as Int32), 5).name
            when destination_class_name = 'polygon' then 'UNKNOWN REGION FOR POLYGON'
            else 'ERROR'
        end as destination_region

        , null as mid_mile_operator_id
        , operator_id as last_mile_operator_id

        , false as has_mid_mile_flg
    from $last_mile_distinct
);

$mid_mile_pretty = (
    select 
    -- source point
        mm.source_station_type as source_type 
        , mm.source_station_id as source_id
        , mm.source_station_name as source_name
        , $find_type(
            Geo::RegionByLocation(
                mm.source_station_latitude 
                , mm.source_station_longitude
            ).id
            , 5
        ).name as source_region

    -- mid mile point 
        , mm.destination_station_type as mid_type
        , mm.destination_id as mid_id
        , mm.destination_station_name as mid_name
        , $find_type(
            Geo::RegionByLocation(
                mm.destination_station_latitude 
                , mm.destination_station_longitude
            ).id
            , 5
        ).name as mid_region

    -- last mile point 
        , CASE 
            when lm.destination_class_name = 'station' then lm.destination_station_type
            else lm.destination_class_name
        end as destination_type 
        , lm.destination_id as destination_id
        , CASE 
            when lm.destination_class_name = 'station' then lm.destination_station_name
            when lm.destination_class_name = 'geo_id_area' then Geo::RegionById(cast(lm.destination_id as Int32)).name
            when lm.destination_class_name = 'polygon' then lm.destination_id
            else 'ERROR'
        end as destination_name
        , CASE 
            when lm.destination_class_name = 'station' 
                then $find_type(
                    Geo::RegionByLocation(
                        lm.destination_station_latitude 
                        , lm.destination_station_longitude
                    ).id
                    , 5
                ).name
            when lm.destination_class_name = 'geo_id_area' then $find_type(cast(lm.destination_id as Int32), 5).name
            when lm.destination_class_name = 'polygon' then 'UNKNOWN REGION FOR POLYGON'
            else 'ERROR'
        end as destination_region

        , mm.operator_id as mid_mile_operator_id
        , lm.operator_id as last_mile_operator_id

        , true as has_mid_mile_flg
    from $mid_mile_distinct as mm 
    left join $last_mile_distinct as lm on mm.destination_id = lm.source_station_id
);

$final = (
    select *
    from $last_mile_pretty
    union all 
    select *
    from $mid_mile_pretty
);

INSERT INTO $SAVE_TO WITH TRUNCATE 
select *
from $final;
