use hahn;
pragma DqEngine = 'disable';

$ALL_EDGES = '//home/taxi-delivery/analytics/production/ndd/delivery_geo/all_edges';
$SAVE_TO = '//home/taxi-delivery/analytics/production/ndd/delivery_geo/all_routes_children';

$delivery_duration = ($pickup_interval, $delivery_interval) -> {
    $pickup_date = cast(substring($pickup_interval, 0, 10) as Date);
    $delivery_date = cast(substring($delivery_interval, 0, 10) as Date);

    return DateTime::ToDays($delivery_date - $pickup_date) + 1;
};

$mid_mile = (
    select *
    from $ALL_EDGES
    where 1=1
        and source_station_type = 'warehouse'
        and destination_station_type = 'warehouse'
);

$last_mile = (
    select *
    from $ALL_EDGES
    where 1=1
        and source_station_type = 'warehouse'
        and destination_class_name = 'geo_id_area'
);

$mid_mile_pretty = (
    select mm.source_station_id as source_station_id
        , mm.source_station_name as source_station_name
        , mm.source_station_latitude as source_station_latitude
        , mm.source_station_longitude as source_station_longitude

        , mm.destination_id as mid_station_id
        , mm.destination_station_name as mid_station_name
        , mm.destination_station_latitude as mid_station_latitude
        , mm.destination_station_longitude as mid_station_longitude

        , lm.destination_id as destination_geo_id

        , mm.pickup_interval as pickup_interval
        , lm.delivery_interval as delivery_interval
        , mm.delivery_interval as mid_mile_arrival
        , lm.pickup_interval as mid_mile_departure

        , lm.operator_id as last_mile_operator_id
        , mm.operator_id as mid_mile_operator_id

        , true as has_mid_mile_flg
    from $mid_mile as mm 
    left join $last_mile as lm on mm.destination_id = lm.source_station_id
    where 1=1
        and substring(mm.delivery_interval, 0, 19) < substring(lm.pickup_interval, 0, 19)
);

$last_mile_pretty = (
    select source_station_id
        , source_station_name
        , source_station_latitude
        , source_station_longitude

        , null as mid_station_id
        , null as mid_station_name
        , null as mid_station_latitude
        , null as mid_station_longitude

        , destination_id as destination_geo_id

        , pickup_interval
        , delivery_interval

        , null as mid_mile_arrival
        , null as mid_mile_departure

        , operator_id as last_mile_operator_id
        , null as mid_mile_operator_id

        , false as has_mid_mile_flg
    from $last_mile
);

$all_routes = (
    select * from $mid_mile_pretty
    union all
    select * from $last_mile_pretty
);

$all_routes_processed = (
    select t1.*
        , $delivery_duration(t1.pickup_interval, t1.delivery_interval) as delivery_duration
        , Geo::RegionById(cast(destination_geo_id as Int32)).name as destination_geo_name
    from $all_routes as t1
);

$raw = (
    select t1.*
        , Geo::GetSubtree(cast(t1.destination_geo_id as Int32)) as children_region_id
    from $all_routes_processed as t1
);

$raw_flattened = (
    select *
    from $raw
    flatten by children_region_id
);

insert into $SAVE_TO WITH TRUNCATE 
select t1.*
    , Geo::RegionById(t1.children_region_id).name as childer_region_name
from $raw_flattened as t1;
