use hahn;

$save_to = '//home/taxi-delivery/analytics/production/ndd/delivery_geo/delivery_intervals_short';

$parse = DateTime::Parse('%Y-%m-%dT%H:%M:%S');
$format_hm = DateTime::Format('%H:%M');
$format_dt = DateTime::Format('%Y-%m-%d');
$interval_duration = ($x) -> {
    $start = DateTime::ToSeconds(DateTime::MakeDatetime($parse(substring($x, 0, 19))));
    $finish = DateTime::ToSeconds(DateTime::MakeDatetime($parse(substring($x, 28, 19))));
    return $finish - $start
};
$add_tz = ($datetime, $timezone) -> {
    $tz = AddTimezone(DateTime::MakeDatetime($parse($datetime)), $timezone);
    return $tz;
};

$a = (
    select
        source_station_name
        , source_station_id
        , destination_geo_id
        , Geo::RoundRegionById(cast(destination_geo_id as Int32), 'city').name as delivery_region_name
        , Geo::RegionById(cast(destination_geo_id as Int32)).timezone_name as delivery_timezone
        , substring(delivery_interval, 0, 10) as delivery_date
        , substring(pickup_interval, 0, 10) as pickup_date
        , substring(pickup_interval, 0, 19) as pickup_datetime
        , substring(delivery_interval, 0, 19) as interval_from_utc
        , substring(delivery_interval, 28, 19) as interval_to_utc
        , $interval_duration(delivery_interval) as interval_duration_sec
        , delivery_duration
    from 
        `//home/taxi-delivery/analytics/production/ndd/delivery_geo/all_routes_children` as t1
    left only join `//home/taxi-delivery/analytics/production/ndd/midponint_stations` as t2
        on t1.source_station_id = t2.source_station_id
);


$b = (
    SELECT
        source_station_name
        , source_station_id
        , destination_geo_id
        , delivery_region_name
        , delivery_timezone
        , min(pickup_date) over w1 as min_pickup_date
        , pickup_date
        , pickup_datetime
        , interval_from_utc
        , interval_to_utc
        , interval_duration_sec
        , max(interval_duration_sec) over w2 as max_interval_duration_sec
        , delivery_duration
        , min(delivery_duration) over w3 as min_delivery_duration
    from
        $a
    window
        w1 as (partition by source_station_name, source_station_id, delivery_region_name, delivery_duration)
        , w2 as (partition by source_station_name, source_station_id, delivery_region_name, delivery_duration, pickup_date)
        , w3 as (partition by source_station_id, delivery_region_name)
);


INSERT INTO $save_to WITH TRUNCATE
select
    source_station_name
    , source_station_id
    , AGGREGATE_LIST_DISTINCT(destination_geo_id) as geo_id_list
    , delivery_region_name
    , delivery_timezone
    , delivery_duration
    , pickup_date
    , delivery_date
    , interval_from_local
    , interval_to_local
    , max(pickup_datetime) as pickup_datetime_utc
    , interval_duration_sec
from $b
where
    pickup_date = min_pickup_date
    and interval_duration_sec = max_interval_duration_sec
    and delivery_duration = min_delivery_duration
group by 
    source_station_name
    , source_station_id
    , delivery_region_name
    , delivery_duration
    , delivery_timezone
    , pickup_date
    , $format_dt($add_tz(interval_from_utc, delivery_timezone)) as delivery_date
    , $format_hm($add_tz(interval_from_utc, delivery_timezone)) as interval_from_local
    , $format_hm($add_tz(interval_to_utc, delivery_timezone)) as interval_to_local
    , interval_duration_sec
;
