/*
    Ticket: LOGDATA-1913

    Author: ikhomyanin@

    Stream: NDD

    About: Find regions without intervals from Market
*/

use hahn;

$HARDCODE_REGIONS = '//home/taxi-delivery/analytics/production/ndd/delivery_intervals/hardcode_regions';
$INTERVALS = '//home/taxi-delivery/analytics/production/ndd/delivery_intervals/tags_flattened';

$SAVE_TO = '//home/taxi-delivery/analytics/production/ndd/delivery_intervals/missing_interval';

$transfrom_intervals = ($interval) -> {
    $start = ListHead(String::SplitToList(ListHead(String::SplitToList($interval, '/')), '+'));
    $end = ListHead(String::SplitToList(ListLast(String::SplitToList($interval, '/')), '+'));

    $start = case 
        when length($start) == 4 then "0" || $start
        when length($start) == 5 then $start
        else 'ERROR'
    end;

    return $start || '-' || $end;
};

$map_schedule = ($schedule) -> {
    $daily = case 
                when $schedule = 'Ежедневно' then [1,2,3,4,5,6,7]
                else null
            end;

    $days = String::SplitToList($schedule, '; ');

    $mapped = ListMap(
        $days,
        ($x) -> {
            $map = case 
                when $x = 'Пн' then 1
                when $x = 'Вт' then 2
                when $x = 'Ср' then 3
                when $x = 'Чт' then 4
                when $x = 'Пт' then 5
                when $x = 'Сб' then 6
                when $x = 'Вс' then 7
                else -1
            end;

            return $map;
        }
    );

    return coalesce($daily, $mapped);
};

$get_day_of_week = ($date) -> {
    $parse = DateTime::Parse('%Y-%m-%d');

    return DateTime::GetDayOfWeek($parse($date))
};

$sorting_centers = (
    select AGGREGATE_LIST_DISTINCT(station_full_name) as sc 
    from $INTERVALS
);

$days_of_week_mapping = ($x) -> {
    $day = case 
        when $x == 1 then 'Пн'
        when $x == 2 then 'Вт'
        when $x == 3 then 'Ср'
        when $x == 4 then 'Чт'
        when $x == 5 then 'Пт'
        when $x == 6 then 'Сб'
        when $x == 7 then 'Вс'
        else 'ERROR'
    end;

    return $day
};

$hardcode_intervals_flattened = (
    select *
    from (
        select geo_id
            , geo_name
            , $transfrom_intervals(delivery_interval) as delivery_interval
            , $map_schedule(city_delivery_schedule) as schedule
            , city_delivery_schedule as city_delivery_schedule
        from $HARDCODE_REGIONS
    )
    flatten by schedule
);

$hardcode_intervals_flattened_sc = (
    select *
    from (
        select *
        from $hardcode_intervals_flattened as t1
        cross join (
            select * 
            from $sorting_centers
        ) as t2
    ) 
    flatten by sc
);

$intervals_reduced = (
    select $get_day_of_week(delivery_interval_date) as delivery_interval_day
        , delivery_interval_msk
        , geo_id
        , station_full_name
    from $INTERVALS
    where 1=1
);

INSERT INTO $SAVE_TO WITH TRUNCATE 
select t1.delivery_interval as delivery_interval
    , t1.schedule as schedule
    , $days_of_week_mapping(t1.schedule) as delivery_day_of_week
    , t1.geo_id as geo_id
    , Geo::RegionById(cast(t1.geo_id as Int32)).population as population
    , t1.geo_name as geo_name
    , t1.sc as station_full_name
    , CASE 
        when t2.station_full_name is null then true
        else false 
    end as missing_interval
    , t1.city_delivery_schedule as city_delivery_schedule
from $hardcode_intervals_flattened_sc as t1 
left join $intervals_reduced as t2 
    on t1.geo_id = t2.geo_id 
    and t1.delivery_interval = t2.delivery_interval_msk 
    and t1.schedule = t2.delivery_interval_day
    and t1.sc = t2.station_full_name;
    