import os
from datetime import datetime
import uuid

import yt.clickhouse as chyt
import yt.wrapper as yt

import pandas as pd
from pandas import ExcelWriter

from typing import List

import smtplib
from email.message import EmailMessage
from email.mime.text import MIMEText
from email.mime.application import MIMEApplication
from email.mime.multipart import MIMEMultipart

import yt.wrapper as yt

def send_email(from_email: str, to_email: List[str], 
               email_text: str, email_subject: str, file: str) -> None:
    """Функция отправляет имейл от from_email на список адресатов 
    из to_email с текстом email_text и темой email_subject"""
    MAIL_HOST = 'outbound-relay.yandex.net'
    
    msg = MIMEMultipart()
    text_part = MIMEText(email_text, 'plain', _charset="utf-8")
    msg['Subject'] = email_subject
    msg['From'] = from_email
    msg['To'] = ', '.join(to_email)
    msg.attach(text_part)
    
    with open(file, "rb") as f:
        part = MIMEApplication(
                f.read()
                , subtype='xlsx'
                , Name=file
            )
    msg.attach(part)
    
    conn = smtplib.SMTP(MAIL_HOST)
    conn.sendmail(from_email, to_email, msg.as_string())
    conn.quit()
    
    
if __name__=='__main__':
    s = """
SELECT
        --distinct 
        employer_code,
        request_code,
        barcode as id,
        --reason, 
        cancel_reason as reason,
        --`sla.cp48_datetime`, `sla.original_delivery_to_datetime`, 
        MAX(`cancelled_datetime`) as canceled_datetime
    FROM `//home/taxi-delivery/analytics/dev/ndd/market_courier_delivery_1h`
    where 
    1=1
    group by 
        employer_code,
        request_code,
        id,
        reason
       -- `sla.cp48_datetime`,
        -- `sla.original_delivery_to_datetime`
    having  toDate(canceled_datetime)  = yesterday()
    and reason is not null
    """

    token = str(os.environ['YT_TOKEN'])
    client = yt.YtClient("hahn", token=token)

    result = chyt.execute(s, alias="*taxi-delivery", client=client)

    df = pd.DataFrame(result)

    mapd = {'SHOP_CANCELLED': 'Отмена по просьбе Отправителя',
           'DELIVERY_SERVICE_UNDELIVERED': 'Отмена по просьбе СД'}

    df['reason'] = df['reason'].map(mapd)

    df.rename(index=str, columns={'request_code': 'Номер заказа ЛП'
                             , 'id': 'Номер заказа LOM'
                             , 'reason': 'Причина переноса'
                             , 'employer_code': 'Код клиента'
                             , 'new_date': 'Новая дата доставки'}, inplace=True)



    writer = ExcelWriter(f'Отмены.xlsx')
    df[['Номер заказа ЛП', 'Номер заказа LOM', 'Причина переноса', 'Код клиента']].to_excel(writer,index=False)
    writer.close()
    list_emails = ['next_day_delivery@go.yandex.ru', 'svkorolev@yandex-team.ru']
    send_email(
    'next_day_delivery@go.yandex.ru',
    list_emails,
    email_subject='Отмены МК',
    email_text="""
    Добрый день,
    В приложении список заказов отмененных вчера.
    """,
    file=f'Отмены.xlsx'
    )
