import os
from datetime import datetime
import uuid
import json

import yt.clickhouse as chyt
import yt.wrapper as yt

import pandas as pd
from pandas import ExcelWriter

from typing import List

import smtplib
from email.message import EmailMessage
from email.mime.text import MIMEText
from email.mime.application import MIMEApplication
from email.mime.multipart import MIMEMultipart

import yt.wrapper as yt

def send_email(from_email: str, to_email: List[str], 
               email_text: str, email_subject: str, file: str) -> None:
    """Функция отправляет имейл от from_email на список адресатов 
    из to_email с текстом email_text и темой email_subject"""
    MAIL_HOST = 'outbound-relay.yandex.net'
    
    msg = MIMEMultipart()
    text_part = MIMEText(email_text, 'plain', _charset="utf-8")
    msg['Subject'] = email_subject
    msg['From'] = from_email
    msg['To'] = ', '.join(to_email)
    msg.attach(text_part)
    
    with open(file, "rb") as f:
        part = MIMEApplication(
                f.read()
                , subtype='xlsx'
                , Name=file
            )
    msg.attach(part)
    
    conn = smtplib.SMTP(MAIL_HOST)
    conn.sendmail(from_email, to_email, msg.as_string())
    conn.quit()
    
    
if __name__=='__main__':
    
    s = """
    select * from "//home/taxi-delivery/analytics/dev/ndd/emails_data"
"""

    token = str(os.environ['YT_TOKEN'])
    client = yt.YtClient("hahn", token=token)

    result = chyt.execute(s, alias="*taxi-delivery", client=client)

    df = pd.DataFrame(result)
    if len(df) > 0:
        df.rename(index=str, columns={'request_code': 'Номер заказа'
                                    , 'status': 'Статус'}, inplace=True)

        with open('./emails_config.json', 'r') as file:
            config = json.loads(file.read())
        for employer_code in df['employer_code'].unique():
            writer = ExcelWriter(f'Необеспеченные заказы {employer_code}.xlsx')
            df['Номер заказа'][df['employer_code'] == employer_code].to_excel(writer,index=False)
            writer.close()
            list_emails = ['next_day_delivery@go.yandex.ru', 'logndd@dostavka.yandex.ru']
            if employer_code in config:
                list_emails += config[employer_code]
            send_email(
            'next_day_delivery@go.yandex.ru',
            list_emails,
            email_subject='Необеспеченные заказы',
            email_text="""
Добрый день,

На склад не поступили заказы, приложенные в файле.

Просим Вас отклонить эти заявки или же перенести их на актуальную для получателя дату.
            """,
            file=f'Необеспеченные заказы {employer_code}.xlsx'
            )   

    

