import os
from datetime import datetime
import uuid

import yt.clickhouse as chyt
import yt.wrapper as yt

import pandas as pd

import datetime

from typing import List

import smtplib
from email.message import EmailMessage
from email.mime.text import MIMEText
from email.mime.application import MIMEApplication
from email.mime.multipart import MIMEMultipart


def send_email(from_email: str, to_email: List[str], 
               email_text: str, email_subject: str, file: str) -> None:
    """Функция отправляет имейл от from_email на список адресатов 
    из to_email с текстом email_text и темой email_subject"""
    MAIL_HOST = 'outbound-relay.yandex.net'
    
    msg = MIMEMultipart()
    text_part = MIMEText(email_text, 'plain', _charset="utf-8")
    msg['Subject'] = email_subject
    msg['From'] = from_email
    msg['To'] = ', '.join(to_email)
    msg.attach(text_part)
    
    with open(file, "rb") as f:
        part = MIMEApplication(
                f.read()
                , subtype='xlsx'
                , Name=file
            )
    msg.attach(part)
    
    conn = smtplib.SMTP(MAIL_HOST)
    conn.sendmail(from_email, to_email, msg.as_string())
    conn.quit()

def save_results(table_path, results):
    YT_TABLE_PATH = table_path
    yt.write_table(
        yt.TablePath(YT_TABLE_PATH, append=True),
        results,
    )
        
if __name__=='__main__':
    yt.config['proxy']['url'] = 'hahn.yt.yandex.net'
    s = f"""
            select
                *
            from
                "//home/taxi-delivery/analytics/production/ndd/leomax/jewelry"
        except
            select
                *
            from
                "//home/taxi-delivery/analytics/production/ndd/leomax/jewelry_sentemail"
        """

    token = os.environ.get('YT_TOKEN')
    client = yt.YtClient("hahn", token=token)

    result = chyt.execute(s, alias="*taxi-delivery", client=client)
    df = pd.DataFrame(result)
    df.to_csv(f"leomax_{datetime.datetime.today().strftime('%d%b%Y')}.csv", index=False, sep=';')
    if len(df) > 0:
        list_emails = [
            'victorsemin@yandex-team.ru',
            'emilsharafiev@yandex-team.ru',
            'leomax@landpro.site',
            'ikhomyanin@yandex-team.ru'
            ]
        send_email(
                'next_day_delivery@go.yandex.ru',
                list_emails,
                email_subject=f'Отчет по ювелирке — {datetime.datetime.today().strftime("%d%b")}',
                email_text="""
                Добрый день,
                В приложении отчет по реализации ювелирки.
                """,
                file=f"leomax_{datetime.datetime.today().strftime('%d%b%Y')}.csv"
                )
        save_results("//home/taxi-delivery/analytics/production/ndd/leomax/jewelry_sentemail", result)
    else:
        list_emails = [
            'victorsemin@yandex-team.ru',
            'emilsharafiev@yandex-team.ru'
            'leomax@landpro.site',
            'ikhomyanin@yandex-team.ru'
            ]
        send_email(
                'next_day_delivery@go.yandex.ru',
                list_emails,
                email_subject=f'[пусто] Отчет по ювелирке — {datetime.datetime.today().strftime("%d%b")}',
                email_text="""
                Добрый день, сегодня без реализованной ювелирки
                """,
                file=f"leomax_{datetime.datetime.today().strftime('%d%b%Y')}.csv"
                )
