import os
from datetime import datetime
import uuid

import yt.clickhouse as chyt
import yt.wrapper as yt

import pandas as pd

import datetime
import openpyxl
from openpyxl.workbook import Workbook
from openpyxl.styles import Fill, PatternFill, Border, Side, Alignment, Protection, Font

from typing import List

import smtplib
from email.message import EmailMessage
from email.mime.text import MIMEText
from email.mime.application import MIMEApplication
from email.mime.multipart import MIMEMultipart


def send_email(from_email: str, to_email: List[str], 
               email_text: str, email_subject: str, file: str) -> None:
    """Функция отправляет имейл от from_email на список адресатов 
    из to_email с текстом email_text и темой email_subject"""
    MAIL_HOST = 'outbound-relay.yandex.net'
    
    msg = MIMEMultipart()
    text_part = MIMEText(email_text, 'plain', _charset="utf-8")
    msg['Subject'] = email_subject
    msg['From'] = from_email
    msg['To'] = ', '.join(to_email)
    msg.attach(text_part)
    
    with open(file, "rb") as f:
        part = MIMEApplication(
                f.read()
                , subtype='xlsx'
                , Name=file
            )
    msg.attach(part)
    
    conn = smtplib.SMTP(MAIL_HOST)
    conn.sendmail(from_email, to_email, msg.as_string())
    conn.quit()
    
        
if __name__=='__main__':


    s = """
    select replaceRegexpAll(request_code, '-\d', '') as request_code,
         argMax(mapped_event_type, event_instant_ddtm) as status,
          MAX(event_instant_ddtm) as status_ddtm,
          argMax(phone, event_instant_ddtm) as phone
    from
    "//home/taxi-delivery/analytics/production/ndd/requests_datamart"
    where toDate(planned_delivery_dt) = yesterday()
    and employer_code = 'ptv' -- 'ptv' 'tov'
    and request_code not in (select distinct request_code  from 
    "//home/taxi-delivery/analytics/production/ndd/requests_datamart" where mapped_event_type in ('Доставлен', 'Доставлен частично'))
    group by 
    request_code
        """

    token = str(os.environ['YT_TOKEN'])
    client = yt.YtClient("hahn", token=token)

    result = chyt.execute(s, alias="*taxi-delivery", client=client)

    df = pd.DataFrame(result)

    if df.shape[0] > 0:
        df.rename(index=str, columns={"status_ddtm":"Дата текущего статуса", 
                                  "request_code": "Номер заказа",
                                  "status":'Текущий статус',
                                  "phone": 'Телефон получателя'}, inplace=True)
        today1 = datetime.datetime.today().strftime("%d.%m.%Y")
        df[['Дата текущего статуса', 'Номер заказа', 'Текущий статус', 'Телефон получателя']].to_excel(f'Шоп_тв_статусы_{today1}.xlsx', index=False, sheet_name='TDSheet', startrow=12, startcol=0 )

        wb = openpyxl.load_workbook(f'Шоп_тв_статусы_{today1}.xlsx')
        ws = wb.active


        if df.shape[0] > 0:
            ws.merge_cells('A8:F8')
            ws.merge_cells('A9:F9')
            ws.merge_cells('A10:F10')
            ws.merge_cells('A11:F11')
            ws.merge_cells('A12:F12')

            for j in range(113+df.shape[0]):
                ws.row_dimensions[j].height = 12.75

            ws.column_dimensions['A'].width = 17
            ws.column_dimensions['B'].width = 17
            ws.column_dimensions['C'].width = 17
            ws.column_dimensions['D'].width = 17


            align_left_table =  Alignment(horizontal='center', vertical='center', wrap_text=True )
            align_left_table_text =  Alignment(horizontal='left', vertical='center', wrap_text=True )

            border_left_table = Border(left=Side(style='thin'), 
                                 right=Side(style='thin'), 
                                 top=Side(style='thin'), 
                                 bottom=Side(style='thin'))
            fill_left_table = PatternFill(start_color='EAE5D8',
                               end_color='EAE5D8',
                               fill_type='solid')

            for i in ['A', 'B', 'C', 'D']: #, 'E', 'F', 'I', 'J']:
                ws[i+'13'].font = Font(size=8, bold=True, color='594304', name='Arial' )
                ws[i+'13'].alignment = align_left_table
                ws[i+'13'].border = border_left_table
                ws[i+'13'].fill = fill_left_table



            for j in range(df.shape[0]):
                ws.row_dimensions[6+j].height = 10
                for i in ['A', 'B', 'C', 'D']: #, 'E', 'F']:
                    ws[i+str(14+j)].font = Font(size=8, name='Arial' )
                    ws[i+str(14+j)].alignment = align_left_table
                    ws[i+str(14+j)].border = border_left_table

            end_table = 13 + df.shape[0]


            strt_date = datetime.datetime.strptime('2022-02-18', "%Y-%m-%d")
            today = datetime.datetime.today()
            difference = today - strt_date

            ws['A8'] = f'Отчет по статусам заказов  № {str(1+difference.days)} от {datetime.datetime.today().strftime("%d.%m.%Y")}г.'
            wb.save(f'Шоп_тв_статусы_{today1}.xlsx')


            list_emails = [ 'Irina.Ivanova@leomax.ru', 'Client.service@leomax.ru',
                         'victorsemin@yandex-team.ru', 'vzuykova@yandex-team.ru', 
                            'eroyan@yandex-team.ru', 'podyablonsky@yandex-team.ru', 
                           'svkorolev@yandex-team.ru', 'ikhomyanin@yandex-team.ru']
            send_email(
            'next_day_delivery@go.yandex.ru',
            list_emails,
            email_subject='Статусы Шоп ТВ Яндекс Доставка',
            email_text="""
            Добрый день,
            В приложении список заказов, по которым не было доставки вчера.
            """,
            file=f'Шоп_тв_статусы_{today1}.xlsx'
            )
            
    s = """
    select replaceRegexpAll(request_code, '-\d', '') as request_code,
         argMax(mapped_event_type, event_instant_ddtm) as status,
          MAX(event_instant_ddtm) as status_ddtm,
          argMax(phone, event_instant_ddtm) as phone
    from
    "//home/taxi-delivery/analytics/production/ndd/requests_datamart"
    where toDate(planned_delivery_dt) = yesterday()
    and employer_code = 'tov' -- 'ptv' 'tov'
    and request_code not in (select distinct request_code  from 
    "//home/taxi-delivery/analytics/production/ndd/requests_datamart" where mapped_event_type in ('Доставлен', 'Доставлен частично'))
    group by 
    request_code
        """

    token = str(os.environ['YT_TOKEN'])
    client = yt.YtClient("hahn", token=token)

    result = chyt.execute(s, alias="*taxi-delivery", client=client)

    df = pd.DataFrame(result)

    if df.shape[0] > 0:
        df.rename(index=str, columns={"status_ddtm":"Дата текущего статуса", 
                                  "request_code": "Номер заказа",
                                  "status":'Текущий статус',
                                  "phone": 'Телефон получателя'}, inplace=True)
        today1 = datetime.datetime.today().strftime("%d.%m.%Y")
        df[['Дата текущего статуса', 'Номер заказа', 'Текущий статус', 'Телефон получателя']].to_excel(f'Товары_Почтой_статусы_{today1}.xlsx', index=False, sheet_name='TDSheet', startrow=12, startcol=0 )

        wb = openpyxl.load_workbook(f'Товары_Почтой_статусы_{today1}.xlsx')
        ws = wb.active


        if df.shape[0] > 0:
            ws.merge_cells('A8:F8')
            ws.merge_cells('A9:F9')
            ws.merge_cells('A10:F10')
            ws.merge_cells('A11:F11')
            ws.merge_cells('A12:F12')

            for j in range(113+df.shape[0]):
                ws.row_dimensions[j].height = 12.75

            ws.column_dimensions['A'].width = 17
            ws.column_dimensions['B'].width = 17
            ws.column_dimensions['C'].width = 17
            ws.column_dimensions['D'].width = 17


            align_left_table =  Alignment(horizontal='center', vertical='center', wrap_text=True )
            align_left_table_text =  Alignment(horizontal='left', vertical='center', wrap_text=True )

            border_left_table = Border(left=Side(style='thin'), 
                                 right=Side(style='thin'), 
                                 top=Side(style='thin'), 
                                 bottom=Side(style='thin'))
            fill_left_table = PatternFill(start_color='EAE5D8',
                               end_color='EAE5D8',
                               fill_type='solid')

            for i in ['A', 'B', 'C', 'D']: #, 'E', 'F', 'I', 'J']:
                ws[i+'13'].font = Font(size=8, bold=True, color='594304', name='Arial' )
                ws[i+'13'].alignment = align_left_table
                ws[i+'13'].border = border_left_table
                ws[i+'13'].fill = fill_left_table



            for j in range(df.shape[0]):
                ws.row_dimensions[6+j].height = 10
                for i in ['A', 'B', 'C', 'D']: #, 'E', 'F']:
                    ws[i+str(14+j)].font = Font(size=8, name='Arial' )
                    ws[i+str(14+j)].alignment = align_left_table
                    ws[i+str(14+j)].border = border_left_table

            end_table = 13 + df.shape[0]


            strt_date = datetime.datetime.strptime('2022-02-18', "%Y-%m-%d")
            today = datetime.datetime.today()
            difference = today - strt_date

            ws['A8'] = f'Отчет по статусам заказов  № {str(1+difference.days)} от {datetime.datetime.today().strftime("%d.%m.%Y")}г.'
            wb.save(f'Товары_Почтой_статусы_{today1}.xlsx')


            list_emails = ['Irina.Ivanova@leomax.ru', 'Client.service@leomax.ru', 
                        'victorsemin@yandex-team.ru', 'vzuykova@yandex-team.ru', 
                            'eroyan@yandex-team.ru', 'podyablonsky@yandex-team.ru', 
                           'svkorolev@yandex-team.ru', 'ikhomyanin@yandex-team.ru']
            send_email(
            'next_day_delivery@go.yandex.ru',
            list_emails,
            email_subject='Статусы Товары Почтой Яндекс Доставка',
            email_text="""
            Добрый день,
            В приложении список заказов, по которым не было доставки вчера.
            """,
            file=f'Товары_Почтой_статусы_{today1}.xlsx'
            )
