import os
from datetime import datetime
import uuid

import yt.clickhouse as chyt
import yt.wrapper as yt

import pandas as pd

import datetime
import openpyxl
from openpyxl.workbook import Workbook
from openpyxl.styles import Fill, PatternFill, Border, Side, Alignment, Protection, Font

from typing import List

import smtplib
from email.message import EmailMessage
from email.mime.text import MIMEText
from email.mime.application import MIMEApplication
from email.mime.multipart import MIMEMultipart


def send_email(from_email: str, to_email: List[str], 
               email_text: str, email_subject: str, file: str) -> None:
    """Функция отправляет имейл от from_email на список адресатов 
    из to_email с текстом email_text и темой email_subject"""
    MAIL_HOST = 'outbound-relay.yandex.net'
    
    msg = MIMEMultipart()
    text_part = MIMEText(email_text, 'plain', _charset="utf-8")
    msg['Subject'] = email_subject
    msg['From'] = from_email
    msg['To'] = ', '.join(to_email)
    msg.attach(text_part)
    
    with open(file, "rb") as f:
        part = MIMEApplication(
                f.read()
                , subtype='xlsx'
                , Name=file
            )
    msg.attach(part)
    
    conn = smtplib.SMTP(MAIL_HOST)
    conn.sendmail(from_email, to_email, msg.as_string())
    conn.quit()
    
        
if __name__=='__main__':
    s = """
select money_sent_dt, delivery_dt, round(sum(amount), 2) as amount, request_code, payment_order_number
    , left(datamart.created_dttm, 10) as created_dttm from (
    SELECT
        MIN(toString(toDate(replaceRegexpAll(replaceRegexpAll(`pon_status_last_update_dt`, 'T', ' '), 'Z', '')))) as money_sent_dt,
        toDateTime(`cargo_payments_history_tt`) as hhtt,
        delivery_dt,
        argMin(toFloat64(`pon_amount`), `pon_status_last_update_dt`) as amount,
        argMin(`pon_status`, pon_status_last_update_dt) as pon_status,
        `payment_order_number`,
        replaceRegexpAll(request_code, '-\d', '') as request_code
    FROM `//home/taxi-delivery/analytics/production/ndd/post_pay_table`
    where employer_code in ('tov') --('mtv') --('ptv')
    and payment_method in ('cash_on_receipt', 'card_on_receipt')
    --and toString(toDateTime(replaceRegexpAll(replaceRegexpAll(`pon_status_last_update_dt`, 'T', ' '), 'Z', ''))) between toString(yesterday()) || ' 17:00:00' and 
    --toString(today()) || ' 17:00:00'
    
    and payment_order_number is not null
    group by hhtt, delivery_dt,

        `payment_order_number`, request_code
    having money_sent_dt = toString(yesterday()) ) as post_pay
    left join 
    (select DISTINCT request_code, created_dttm from 
    "//home/taxi-delivery/analytics/production/ndd/requests_datamart") as datamart 
    on datamart.request_code = post_pay.request_code
    where pon_status in ('TRANSMITTED', 'CONFIRMED')
     group by  money_sent_dt, delivery_dt, request_code, created_dttm, payment_order_number
     having amount > 0
        """

    token = str(os.environ['YT_TOKEN'])
    client = yt.YtClient("hahn", token=token)

    result = chyt.execute(s, alias="*taxi-delivery", client=client)

    df = pd.DataFrame(result)
    
    if df.shape[0] > 0:
        df['money_sent_dt'] = df['money_sent_dt'].apply(lambda x: datetime.datetime.strptime(x[:10], "%Y-%m-%d"))
        df['created_dttm'] = df['created_dttm'].apply(lambda x: datetime.datetime.strptime(x[:10], "%Y-%m-%d"))
        df['delivery_dt'] = df['delivery_dt'].apply(lambda x: datetime.datetime.strptime(x[:10], "%Y-%m-%d"))



        df['money_sent_dt'] = df['money_sent_dt'].apply(lambda x: x.strftime("%d.%m.%Y")).apply(str)
        df['created_dttm'] = df['created_dttm'].apply(lambda x: x.strftime("%d.%m.%Y")).apply(str)
        df['delivery_dt'] = df['delivery_dt'].apply(lambda x: x.strftime("%d.%m.%Y")).apply(str)
        
        df.rename(index=str, columns={"money_sent_dt":"Дата платежа (возврат)", 
                                "request_code": "Номер заказа",
                                "payment_order_number":'Номер П\П',
                                "amount": 'Сумма',
                                "delivery_dt": 'Дата оплаты клиентом',
                                "created_dttm": 'Дата заказа'}, inplace=True)
        
        
        today1 = (datetime.datetime.today() - datetime.timedelta(days=1)).strftime("%d.%m.%Y")
        df[['Номер заказа', 'Дата заказа', 'Сумма', 'Дата оплаты клиентом', 
            'Дата платежа (возврат)', 'Номер П\П']].to_excel(f'Toвары_почтой_{today1}.xlsx', index=False,                        sheet_name='TDSheet', startrow=12, startcol=0 )
        
        wb = openpyxl.load_workbook(f'Toвары_почтой_{today1}.xlsx')
        ws = wb.active
        
        if df.shape[0] > 0:
            ws.merge_cells('A8:F8')
            ws.merge_cells('A9:F9')
            ws.merge_cells('A10:F10')
            ws.merge_cells('A11:F11')
            ws.merge_cells('A12:F12')

            for j in range(113+df.shape[0]):
                ws.row_dimensions[j].height = 12.75

            #ws.row_dimensions[1].height = 30
            #ws.row_dimensions[4].height = 30
            #ws.row_dimensions[5].height = 30

            ws.column_dimensions['A'].width = 17
            ws.column_dimensions['B'].width = 17
            ws.column_dimensions['C'].width = 17
            ws.column_dimensions['D'].width = 17
            ws.column_dimensions['E'].width = 17
            ws.column_dimensions['F'].width = 17
            #ws.column_dimensions['I'].width = 14
            #ws.column_dimensions['J'].width = 50

            align_left_table =  Alignment(horizontal='center', vertical='center', wrap_text=True )
            align_left_table_text =  Alignment(horizontal='left', vertical='center', wrap_text=True )

            border_left_table = Border(left=Side(style='thin'), 
                                right=Side(style='thin'), 
                                top=Side(style='thin'), 
                                bottom=Side(style='thin'))
            fill_left_table = PatternFill(start_color='EAE5D8',
                            end_color='EAE5D8',
                            fill_type='solid')

            for i in ['A', 'B', 'C', 'D', 'E', 'F']:
                ws[i+'13'].font = Font(size=8, bold=True, color='594304', name='Arial' )
                ws[i+'13'].alignment = align_left_table
                ws[i+'13'].border = border_left_table
                ws[i+'13'].fill = fill_left_table



            for j in range(df.shape[0]):
                ws.row_dimensions[6+j].height = 10
                for i in ['A', 'B', 'C', 'D', 'E', 'F']:
                    ws[i+str(14+j)].font = Font(size=8, name='Arial' )
                    ws[i+str(14+j)].alignment = align_left_table
                    ws[i+str(14+j)].border = border_left_table

            ws['A9'].font = Font(size=8, name='Arial' )
            ws['A9'] = 'Агент: ООО "Яндекс.Доставка"'

            ws['A10'].font = Font(size=8, name='Arial' )
            ws['A10'] = 'Принципал: ООО "Товары Почтой"					'

            ws['A11'].font = Font(size=8, name='Arial' )
            ws['A11'] = 'Договор: №3311014/22					'

            #ws['I13'] = 'Заголовок'
            #ws['I13'].font = Font(size=8, bold=True, color='594304', name='Arial' )
            #ws['I13'].alignment = align_left_table
            #ws['I13'].border = border_left_table
            #ws['I13'].fill = fill_left_table

            #for i in ['I13', 'I14', 'I15', 'I16', 'I17', 'I18']:
            #    ws[i].alignment = align_left_table
            #    ws[i].border = border_left_table
            #    ws[i].fill = fill_left_table
            #    ws[i].font = Font(size=8, bold=True, color='594304', name='Arial' )

            #for i in ['J13', 'J14', 'J15', 'J16', 'J17', 'J18']:
            #    ws[i].alignment = align_left_table_text
            #    ws[i].border = border_left_table
            #    ws[i].font = Font(size=8, name='Arial' )

            #ws['J13'] = 'Примечание'
            #ws['I13'] = 'Номер заказа'
            #ws['J13'] = 'номер заказ из системы Леомакс'
            #ws['I14'] = 'Дата заказа'
            #ws['J14'] = 'Дата отгрузки заказа со склада Леомакс'
            #ws['I15'] = 'Сумма'
            #ws['J15'] = 'Сумма, которую взяли с клиента, она же оценочная стоимость'
            #ws['I16'] = 'Дата оплаты клиентом'
            #ws['J16'] = 'Дата вручения заказа клиенту'
            #ws['I17'] = 'Дата Платежа (возврат)'
            #ws['J17'] = 'Дата перечисления денег на р/с Леомакс, она же дата платежного поручения'
            #ws['I18'] = 'Номер П/П'
            #ws['J18'] = 'Номер платежного поручения'



            end_table = 13 + df.shape[0]
            ws['A'+ str(end_table + 2)] = f"Итого: сумма к перечислению {str(int((df['Сумма'].sum() // 1)))} руб {'%02d' % (round(df['Сумма'].sum() % 1, 2) * 100)} коп."
            ws['A'+ str(end_table + 2)].font = Font(size=9, name='Cambria')
            ws['A'+ str(end_table + 2)].alignment = Alignment(vertical='bottom', wrap_text=True)
            ws.merge_cells('A'+str(end_table+2)+':F'+str(end_table+3))

            ws.merge_cells('B'+str(end_table+4)+':D'+str(end_table+4))
            ws['A'+str(end_table+4)] = 'Агент:'
            ws['A'+str(end_table+4)].font = Font(size=10, name='Cambria')
            ws['A'+str(end_table+4)].alignment = Alignment(vertical='center', wrap_text=True)

            ws['E'+str(end_table+4)] = 'Принципал:'
            ws['E'+str(end_table+4)].font = Font(size=10, name='Cambria')
            ws['E'+str(end_table+4)].alignment = Alignment(vertical='center', wrap_text=True)
            ws.merge_cells('E'+str(end_table+4)+':F'+str(end_table+4))

            ws['E'+str(end_table+5)] = 'ООО "Товары Почтой"'
            ws['E'+str(end_table+5)].font = Font(size=10, name='Cambria', bold=True)
            ws['E'+str(end_table+5)].alignment = Alignment(vertical='top', wrap_text=True)

            ws['E'+str(end_table+6)] = 'ОГРН 1187746282789'
            ws['E'+str(end_table+6)].font = Font(size=9, name='Cambria')
            ws['E'+str(end_table+6)].alignment = Alignment(vertical='center', horizontal='left', wrap_text=True)

            ws['E'+str(end_table+7)] = 'Генеральный директор'
            ws['E'+str(end_table+7)].font = Font(size=10, name='Cambria')
            ws['E'+str(end_table+7)].alignment = Alignment(vertical='center', horizontal='left', wrap_text=True)
            ws.merge_cells('E'+str(end_table+7)+':F'+str(end_table+7))

            ws['A'+str(end_table+7)] = 'Генеральный директор'
            ws['A'+str(end_table+7)].font = Font(size=10, name='Cambria')
            ws['A'+str(end_table+7)].alignment = Alignment(vertical='center', horizontal='left', wrap_text=True)
            ws.merge_cells('A'+str(end_table+7)+':B'+str(end_table+7))
            ws.merge_cells('A'+str(end_table+8)+':B'+str(end_table+8))

            ws['E'+str(end_table+9)] = '______________   / Симонова С.Л./'
            ws['E'+str(end_table+9)].font = Font(size=10, name='Cambria')
            ws['E'+str(end_table+9)].alignment = Alignment(vertical='center', horizontal='left')

            strt_date = datetime.datetime.strptime('2022-04-07', "%Y-%m-%d")
            today = datetime.datetime.today()
            difference = today - strt_date

            ws['A8'] = f'Отчет по перечислениям  денежных средств  № {str(1+difference.days)} от {today1}г.'
            wb.save(f'Toвары_почтой_{today1} перечисления.xlsx')
            
            list_emails = ['Irina.Ivanova@leomax.ru', 'Client.service@leomax.ru', 'vzuykova@yandex-team.ru',
            'victorsemin@yandex-team.ru', 'vzuykova@yandex-team.ru', 
                           'eroyan@yandex-team.ru', 'podyablonsky@yandex-team.ru',
                             'svkorolev@yandex-team.ru', 'ikhomyanin@yandex-team.ru']
            send_email(
            'next_day_delivery@go.yandex.ru',
            list_emails,
            email_subject='Перечисления Товары Почтой Яндекс Доставка',
            email_text="""
            Добрый день,
            В приложении список перечислений денежных средств.
            """,
            file=f'Toвары_почтой_{today1} перечисления.xlsx'
            )
        
