import os
from datetime import datetime
import uuid

import yt.clickhouse as chyt
import yt.wrapper as yt

import pandas as pd
from pandas import ExcelWriter

from typing import List

import smtplib
from email.message import EmailMessage
from email.mime.text import MIMEText
from email.mime.application import MIMEApplication
from email.mime.multipart import MIMEMultipart

import yt.wrapper as yt

def send_email(from_email: str, to_email: List[str], 
               email_text: str, email_subject: str, file: str) -> None:
    """Функция отправляет имейл от from_email на список адресатов 
    из to_email с текстом email_text и темой email_subject"""
    MAIL_HOST = 'outbound-relay.yandex.net'
    
    msg = MIMEMultipart()
    text_part = MIMEText(email_text, 'plain', _charset="utf-8")
    msg['Subject'] = email_subject
    msg['From'] = from_email
    msg['To'] = ', '.join(to_email)
    msg.attach(text_part)
    
    with open(file, "rb") as f:
        part = MIMEApplication(
                f.read()
                , subtype='xlsx'
                , Name=file
            )
    msg.attach(part)
    
    conn = smtplib.SMTP(MAIL_HOST)
    conn.sendmail(from_email, to_email, msg.as_string())
    conn.quit()
    
    
if __name__=='__main__':
    s = """
select 
    employer_code,
    request_code,
    id,
    reason,
    new_date, 
    resch_dttm,
    resch_reason, 
    multiIf(resch_reason like '%озвон%', 'Недозвон',
        resch_reason like '%По%осьбе%иент%', 'По просьбе клиента',
        resch_reason like '%далось%вал%', 'Не удалось доставить в интервал',
        resch_reason like '%аспор%18%', 'Нет паспорта/18 лет',
        resch_reason like '%Яндекс%Достав%', 'По просьбе СД',
        resch_reason like '%Заказ был принят на СЦ%', 'Поздно принят на СЦ',
        resch_reason like '%координат%', 'Изменение координат из ПИ',
        resch_reason like '%Клиент через Где курьер%', 'Клиент через Где курьер',
        'Другая причина'
        ) as resch_reason_short
from 
(
select 
        employer_code,
        request_code,
        barcode as id,
        reason,
        left(`new_delivery_date_time_to`, 10) as new_date,
        argMax(`resc_context`, `resc_dttm`) as resch_reason,
        MAX(resc_dttm) as resch_dttm,
        MAX(`cancelled_datetime`) as canceled_datetime
        FROM `//home/taxi-delivery/analytics/dev/ndd/market_courier_delivery_1h`
    where 
    1=1
    group by 
        employer_code,
        request_code,
        id,
        reason,
        new_date
    having  toDate(resc_dttm)  = yesterday()
    and reason is not null
)
    """

    token = str(os.environ['YT_TOKEN'])
    client = yt.YtClient("hahn", token=token)

    result = chyt.execute(s, alias="*taxi-delivery", client=client)

    df = pd.DataFrame(result)

    mapd = {'DELIVERY_DATE_UPDATED_BY_RECIPIENT': 'Перенос по просьбе Получателя',
           'DELIVERY_DATE_UPDATED_BY_DELIVERY': 'Перенос по просьбе СД',
           'DELIVERY_DATE_UPDATED_BY_SHOP': 'Перенос по просьбе Отправителя'}

    df['reason'] = df['reason'].map(mapd)

    df.rename(index=str, columns={'request_code': 'Номер заказа ЛП'
                             , 'id': 'Номер заказа LOM'
                             , 'reason': 'Причина переноса LOM'
                             , 'employer_code': 'Код клиента'
                             , 'new_date': 'Новая дата доставки'
                             , 'resch_dttm': 'Дата переноса (UTC)'
                             , 'resch_reason': 'Причина переноса ПИ'
                             , 'resch_reason_short': 'Тип переноса ПИ'},
                             inplace=True)



    writer = ExcelWriter(f'Переносы.xlsx')
    df['ЛП ссылка'] = 'https://tariff-editor.taxi.yandex-team.ru/dragon-orders?cluster=platform&request_code='+df['Номер заказа ЛП']
    df[['Номер заказа ЛП', 'Номер заказа LOM', 'Причина переноса LOM', 'Код клиента', 'Новая дата доставки', 'Дата переноса (UTC)', 'Причина переноса ПИ', 'Тип переноса ПИ']].to_excel(writer,index=False)
    writer.close()
    list_emails = ['next_day_delivery@go.yandex.ru', 'svkorolev@yandex-team.ru']
    send_email(
    'next_day_delivery@go.yandex.ru',
    list_emails,
    email_subject='Переносы МК',
    email_text="""
    Добрый день,
    В приложении список заказов перенесенных вчера.
    """,
    file=f'Переносы.xlsx'
    )
