import os
from datetime import datetime
import uuid

import yt.clickhouse as chyt
import yt.wrapper as yt

import pandas as pd

import datetime
import openpyxl
from openpyxl.workbook import Workbook
from openpyxl.styles import Fill, PatternFill, Border, Side, Alignment, Protection, Font

from typing import List

import smtplib
from email.message import EmailMessage
from email.mime.text import MIMEText
from email.mime.application import MIMEApplication
from email.mime.multipart import MIMEMultipart


def send_email(from_email: str, to_email: List[str], 
               email_text: str, email_subject: str, file: str) -> None:
    """Функция отправляет имейл от from_email на список адресатов 
    из to_email с текстом email_text и темой email_subject"""
    MAIL_HOST = 'outbound-relay.yandex.net'
    
    msg = MIMEMultipart()
    text_part = MIMEText(email_text, 'plain', _charset="utf-8")
    msg['Subject'] = email_subject
    msg['From'] = from_email
    msg['To'] = ', '.join(to_email)
    msg.attach(text_part)
    
    with open(file, "rb") as f:
        part = MIMEApplication(
                f.read()
                , subtype='xlsx'
                , Name=file
            )
    msg.attach(part)
    
    conn = smtplib.SMTP(MAIL_HOST)
    conn.sendmail(from_email, to_email, msg.as_string())
    conn.quit()
    
        
if __name__=='__main__':
    s = f"""
select 
    distinct
    request_code
    , substring(coalesce(delivered, return, cancelled), 1, 10) as created
    , substring(delivery_at_start, 1, 10) as delivery_at_start
    , multiIf(cancelled > delivered, 'Отменен'
            , return > delivering and delivering is not null, 'Отказ во время доставки'
            , delivered is not null, 'Выполнен', null
    ) as status 
    , weight 
    , `items_assessed_price`*0.01 as items_assessed_price
    , name
    , total_without_vat * 0.01 * 1.2 as tariff 
    , delivery_address
    , round(`items_assessed_price` * 0.005 * 1.2, 2) as insurance 
    , sms 
    , call 
from (
SELECT
    replaceRegexpAll(request_code, '-\d', '') as request_code
    , request_id
    , weight 
    , (delivery_cost + `items_assessed_price`) as items_assessed_price
    , first_name || ' ' || last_name as name 
    , null as tariff 
    , delivery_address
    , 0 as sms 
    , 0 as call
    , MIN(case when operator_lp_status = 'CREATED' then event_instant_ddtm else null end) as created
    , MIN(case when operator_lp_status = 'DELIVERY_AT_START' then event_instant_ddtm else null end) as delivery_at_start
    , MIN(case when operator_lp_status = 'DELIVERY_DELIVERED' then event_instant_ddtm else null end) as delivered
    , min(case when operator_lp_status = 'DELIVERY_TRANSPORTATION_RECIPIENT' then event_instant_ddtm else null end) as delivering
    , min(case when operator_lp_status = 'RETURN_PREPARING' then event_instant_ddtm else null end) as return
    , min(case when operator_lp_status = 'CANCELLED' then event_instant_ddtm else null end) as cancelled
FROM `//home/taxi-delivery/analytics/production/ndd/requests_datamart`
where toMonth(toDate(left(created_dttm, 10))) = {datetime.datetime.today().month -1}
and employer_code = 'ptv'
group by 
    request_code
    , request_id
    , weight 
    , `items_assessed_price`
    , first_name || ' ' || last_name as name 
    , null as tariff 
    , delivery_address
    , sms 
    , call 

) as base  
left join 
(select * from "//home/taxi-delivery/analytics/dev/ndd/billing_tasks_agg") as bill 
on bill.request_id = base.request_id
where status is not null
and status <> 'Отказ во время доставки'
        """

    token = str(os.environ['YT_TOKEN'])
    client = yt.YtClient("hahn", token=token)

    result = chyt.execute(s, alias="*taxi-delivery", client=client)

    df = pd.DataFrame(result)
    
    if df.shape[0] > 0:
        
        df.rename(index=str, columns={"delivery_at_start":"Дата отгрузки", 
                                "created": 'Дата',
                                'status': 'Статус заказа',
                                'weight': 'Вес груза',
                                'tariff': 'Тариф',
                                'insurance':'Страховой сбор',
                                'sms': 'СМС',
                                'call':'Прозвон',
                                "request_code": "Номер заказа",
                                "name":'Контактное лицо контрагента',
                                "items_assessed_price": 'Сумма документа',
                                "comission": 'Оплата картой/наличными',
                                "agent_reward_round": 'Агентское вознаграждение',
                                     'agent_reward':' ',
                                     'delivery_address':'Адрес'}, inplace=True)
        
        
        today1 = (datetime.datetime.today() - datetime.timedelta(days=1)).strftime("%d.%m.%Y")
        df[["Номер заказа",'Дата отгрузки','Дата', 'Статус заказа', 'Вес груза', 'Сумма документа', 'Контактное лицо контрагента', 'Тариф', 'Адрес', 'Страховой сбор', 'СМС', 'Прозвон']].to_excel(
            f"Шоп_ТВ_{'%02d' % (datetime.datetime.today().month-1)}.22 тарифы.xlsx", index=False,                    sheet_name='TDSheet', startrow=12, startcol=0 )
        
        wb = openpyxl.load_workbook(f"Шоп_ТВ_{'%02d' % (datetime.datetime.today().month-1)}.22 тарифы.xlsx")
        ws = wb.active
        
        if df.shape[0] > 0:
            ws.merge_cells('A8:F8')
            ws.merge_cells('A9:F9')
            ws.merge_cells('A10:F10')
            ws.merge_cells('A11:F11')
            ws.merge_cells('A12:F12')

            for j in range(113+df.shape[0]):
                ws.row_dimensions[j].height = 12.75

            #ws.row_dimensions[1].height = 30
            #ws.row_dimensions[4].height = 30
            #ws.row_dimensions[5].height = 30

            ws.column_dimensions['A'].width = 17
            ws.column_dimensions['B'].width = 17
            ws.column_dimensions['C'].width = 17
            ws.column_dimensions['D'].width = 17
            ws.column_dimensions['E'].width = 17
            ws.column_dimensions['F'].width = 17
            ws.column_dimensions['G'].width = 17
            ws.column_dimensions['H'].width = 17
            ws.column_dimensions['I'].width = 17
            ws.column_dimensions['J'].width = 17
            ws.column_dimensions['K'].width = 17
            ws.column_dimensions['L'].width = 17

            align_left_table =  Alignment(horizontal='center', vertical='center', wrap_text=True )
            align_left_table_text =  Alignment(horizontal='left', vertical='center', wrap_text=True )

            border_left_table = Border(left=Side(style='thin'), 
                                right=Side(style='thin'), 
                                top=Side(style='thin'), 
                                bottom=Side(style='thin'))
            fill_left_table = PatternFill(start_color='EAE5D8',
                            end_color='EAE5D8',
                            fill_type='solid')

            for i in ['A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L']:
                ws[i+'13'].font = Font(size=8, bold=True, color='594304', name='Arial' )
                ws[i+'13'].alignment = align_left_table
                ws[i+'13'].border = border_left_table
                ws[i+'13'].fill = fill_left_table



            for j in range(df.shape[0]):
                ws.row_dimensions[6+j].height = 14
                for i in ['A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L']:
                    ws[i+str(14+j)].font = Font(size=8, name='Arial' )
                    ws[i+str(14+j)].alignment = align_left_table
                    ws[i+str(14+j)].border = border_left_table

            ws['A9'].font = Font(size=8, name='Arial' )
            ws['A9'] = 'Агент: ООО "Яндекс.Доставка"'

            ws['A10'].font = Font(size=8, name='Arial' )
            ws['A10'] = 'Принципал: ООО "ШОП ТВ"					'

            ws['A11'].font = Font(size=8, name='Arial' )
            ws['A11'] = 'Договор: №3311019/22					'

            end_table = 13 + df.shape[0]
                                    
            ws['A'+ str(end_table + 1)] = f"Итог"
            ws['A'+ str(end_table + 1)].font = Font(size=9, name='Cambria')
            ws['A'+ str(end_table + 1)].alignment = Alignment(vertical='bottom', wrap_text=True)
                                    
            ws['F'+ str(end_table + 1)] = f"{round(df['Сумма документа'].sum(), 2)}"
            ws['F'+ str(end_table + 1)].font = Font(size=9, name='Cambria')
            ws['F'+ str(end_table + 1)].alignment = Alignment(vertical='bottom', wrap_text=True)
                                    
            ws['H'+ str(end_table + 1)] = f"{round(df['Тариф'].sum(), 2)}"
            ws['H'+ str(end_table + 1)].font = Font(size=9, name='Cambria')
            ws['H'+ str(end_table + 1)].alignment = Alignment(vertical='bottom', wrap_text=True)
                                    
            ws['J'+ str(end_table + 1)] = f"{round(df['Страховой сбор'].sum(), 2)}"
            ws['J'+ str(end_table + 1)].font = Font(size=9, name='Cambria')
            ws['J'+ str(end_table + 1)].alignment = Alignment(vertical='bottom', wrap_text=True)
            
            ws['K'+ str(end_table + 1)] = f"{df['СМС'].sum()}"
            ws['K'+ str(end_table + 1)].font = Font(size=9, name='Cambria')
            ws['K'+ str(end_table + 1)].alignment = Alignment(vertical='bottom', wrap_text=True)
            
            ws['L'+ str(end_table + 1)] = f"{df['Прозвон'].sum()}"
            ws['L'+ str(end_table + 1)].font = Font(size=9, name='Cambria')
            ws['L'+ str(end_table + 1)].alignment = Alignment(vertical='bottom', wrap_text=True)
                                    
            tariff_plus_insurance = df['Тариф'].sum() + df['Страховой сбор'].sum()
            ws['A'+ str(end_table + 2)] = f"Итого: {df['Сумма документа'].count()} отправления на общую сумму  {str(int((tariff_plus_insurance // 1)))} руб {'%02d' % (round(tariff_plus_insurance % 1, 2) * 100)} коп."
            ws['A'+ str(end_table + 2)].font = Font(size=9, name='Cambria')
            ws['A'+ str(end_table + 2)].alignment = Alignment(vertical='bottom', wrap_text=True)
            ws.merge_cells('A'+str(end_table+2)+':F'+str(end_table+3))

            ws.merge_cells('B'+str(end_table+4)+':D'+str(end_table+4))
            ws['A'+str(end_table+4)] = 'Агент:'
            ws['A'+str(end_table+4)].font = Font(size=10, name='Cambria')
            ws['A'+str(end_table+4)].alignment = Alignment(vertical='center', wrap_text=True)

            ws['E'+str(end_table+4)] = 'Принципал:'
            ws['E'+str(end_table+4)].font = Font(size=10, name='Cambria')
            ws['E'+str(end_table+4)].alignment = Alignment(vertical='center', wrap_text=True)
            ws.merge_cells('E'+str(end_table+4)+':F'+str(end_table+4))

            ws['E'+str(end_table+5)] = 'ООО "ШОП ТВ"'
            ws['E'+str(end_table+5)].font = Font(size=10, name='Cambria', bold=True)
            ws['E'+str(end_table+5)].alignment = Alignment(vertical='top', wrap_text=True)

            ws['E'+str(end_table+6)] = 'ОГРН 5117746036128'
            ws['E'+str(end_table+6)].font = Font(size=9, name='Cambria')
            ws['E'+str(end_table+6)].alignment = Alignment(vertical='center', horizontal='left', wrap_text=True)

            ws['E'+str(end_table+7)] = 'Генеральный директор'
            ws['E'+str(end_table+7)].font = Font(size=10, name='Cambria')
            ws['E'+str(end_table+7)].alignment = Alignment(vertical='center', horizontal='left', wrap_text=True)
            ws.merge_cells('E'+str(end_table+7)+':F'+str(end_table+7))

            ws['A'+str(end_table+7)] = 'Генеральный директор'
            ws['A'+str(end_table+7)].font = Font(size=10, name='Cambria')
            ws['A'+str(end_table+7)].alignment = Alignment(vertical='center', horizontal='left', wrap_text=True)
            ws.merge_cells('A'+str(end_table+7)+':B'+str(end_table+7))
            ws.merge_cells('A'+str(end_table+8)+':B'+str(end_table+8))

            ws['E'+str(end_table+9)] = '______________   / Зимин Д.А./'
            ws['E'+str(end_table+9)].font = Font(size=10, name='Cambria')
            ws['E'+str(end_table+9)].alignment = Alignment(vertical='center', horizontal='left')

            strt_date = datetime.datetime.strptime('2022-04-07', "%Y-%m-%d")
            today = datetime.datetime.today()
            difference = today - strt_date

            ws['A8'] = f'Отчет о доставке  № {str(1+difference.days)} от {today1}г.'
            wb.save(f"Шоп_ТВ_{'%02d' % (datetime.datetime.today().month-1)}.22 тарифы.xlsx")
            list_emails = [
            'victorsemin@yandex-team.ru',
            'vzuykova@yandex-team.ru', 
            'bizhov@yandex-team.ru',
            'svkorolev@yandex-team.ru',
            'ikhomyanin@yandex-team.ru']
            
            send_email(
            'next_day_delivery@go.yandex.ru',
            list_emails,
            email_subject='Тарифы Шоп ТВ Яндекс Доставка',
            email_text="""
            Добрый день,
            В приложении отчет по тарифам.
            """,
            file=f"Шоп_ТВ_{'%02d' % (datetime.datetime.today().month-1)}.22 тарифы.xlsx"
            )
    
    s = f"""
select 
    distinct 
    request_code
    , substring(coalesce(delivered, return, cancelled), 1, 10) as created
    , substring(delivery_at_start, 1, 10) as delivery_at_start
    , multiIf(cancelled > delivered, 'Отменен'
            , return > delivering and delivering is not null, 'Отказ во время доставки'
            , delivered is not null, 'Выполнен', null
    ) as status 
    , weight 
    , `items_assessed_price`*0.01 as items_assessed_price
    , name
    , total_without_vat * 0.01 * 1.2 as tariff 
    , delivery_address
    , round(`items_assessed_price` * 0.005 * 1.2, 2) as insurance 
    , sms 
    , call 
from (
SELECT
    replaceRegexpAll(request_code, '-\d', '') as request_code
    , request_id
    , weight 
    , (delivery_cost + `items_assessed_price`) as items_assessed_price
    , first_name || ' ' || last_name as name 
    , null as tariff 
    , delivery_address
    , 0 as sms 
    , 0 as call
    , MIN(case when operator_lp_status = 'CREATED' then event_instant_ddtm else null end) as created
    , MIN(case when operator_lp_status = 'DELIVERY_AT_START' then event_instant_ddtm else null end) as delivery_at_start
    , MIN(case when operator_lp_status = 'DELIVERY_DELIVERED' then event_instant_ddtm else null end) as delivered
    , min(case when operator_lp_status = 'DELIVERY_TRANSPORTATION_RECIPIENT' then event_instant_ddtm else null end) as delivering
    , min(case when operator_lp_status = 'RETURN_PREPARING' then event_instant_ddtm else null end) as return
    , min(case when operator_lp_status = 'CANCELLED' then event_instant_ddtm else null end) as cancelled
FROM `//home/taxi-delivery/analytics/production/ndd/requests_datamart`
where toMonth(toDate(left(created_dttm, 10))) = {datetime.datetime.today().month-1}
and employer_code = 'tov'
group by 
    request_code
    , request_id
    , weight 
    , `items_assessed_price`
    , first_name || ' ' || last_name as name 
    , null as tariff 
    , delivery_address
    , sms 
    , call 

) as base  
left join 
(select * from "//home/taxi-delivery/analytics/dev/ndd/billing_tasks_agg") as bill 
on bill.request_id = base.request_id
where status is not null
and status <> 'Отказ во время доставки'
        """

    token = str(os.environ['YT_TOKEN'])
    client = yt.YtClient("hahn", token=token)

    result = chyt.execute(s, alias="*taxi-delivery", client=client)

    df = pd.DataFrame(result)
    
    if df.shape[0] > 0:
        
        df.rename(index=str, columns={"delivery_at_start":"Дата отгрузки", 
                                "created": 'Дата',
                                'status': 'Статус заказа',
                                'weight': 'Вес груза',
                                'tariff': 'Тариф',
                                'insurance':'Страховой сбор',
                                'sms': 'СМС',
                                'call':'Прозвон',
                                "request_code": "Номер заказа",
                                "name":'Контактное лицо контрагента',
                                "items_assessed_price": 'Сумма документа',
                                "comission": 'Оплата картой/наличными',
                                "agent_reward_round": 'Агентское вознаграждение',
                                     'agent_reward':' ',
                                     'delivery_address':'Адрес'}, inplace=True)
        
        
        today1 = (datetime.datetime.today() - datetime.timedelta(days=1)).strftime("%d.%m.%Y")
        df[["Номер заказа", 'Дата отгрузки', 'Дата','Статус заказа', 'Вес груза', 'Сумма документа', 'Контактное лицо контрагента', 'Тариф', 'Адрес', 'Страховой сбор', 'СМС', 'Прозвон']].to_excel(
            f"Товары_почтой_{'%02d' % (datetime.datetime.today().month-1)}.22 тарифы.xlsx", index=False,                    sheet_name='TDSheet', startrow=12, startcol=0 )
        
        wb = openpyxl.load_workbook(f"Товары_почтой_{'%02d' % (datetime.datetime.today().month-1)}.22 тарифы.xlsx")
        ws = wb.active
        
        if df.shape[0] > 0:
            ws.merge_cells('A8:F8')
            ws.merge_cells('A9:F9')
            ws.merge_cells('A10:F10')
            ws.merge_cells('A11:F11')
            ws.merge_cells('A12:F12')

            for j in range(113+df.shape[0]):
                ws.row_dimensions[j].height = 12.75

            ws.column_dimensions['A'].width = 17
            ws.column_dimensions['B'].width = 17
            ws.column_dimensions['C'].width = 17
            ws.column_dimensions['D'].width = 17
            ws.column_dimensions['E'].width = 17
            ws.column_dimensions['F'].width = 17
            ws.column_dimensions['G'].width = 17
            ws.column_dimensions['H'].width = 17
            ws.column_dimensions['I'].width = 17
            ws.column_dimensions['J'].width = 17
            ws.column_dimensions['K'].width = 17
            ws.column_dimensions['L'].width = 17

            align_left_table =  Alignment(horizontal='center', vertical='center', wrap_text=True )
            align_left_table_text =  Alignment(horizontal='left', vertical='center', wrap_text=True )

            border_left_table = Border(left=Side(style='thin'), 
                                right=Side(style='thin'), 
                                top=Side(style='thin'), 
                                bottom=Side(style='thin'))
            fill_left_table = PatternFill(start_color='EAE5D8',
                            end_color='EAE5D8',
                            fill_type='solid')

            for i in ['A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L']:
                ws[i+'13'].font = Font(size=8, bold=True, color='594304', name='Arial' )
                ws[i+'13'].alignment = align_left_table
                ws[i+'13'].border = border_left_table
                ws[i+'13'].fill = fill_left_table



            for j in range(df.shape[0]):
                ws.row_dimensions[6+j].height = 14
                for i in ['A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L']:
                    ws[i+str(14+j)].font = Font(size=8, name='Arial' )
                    ws[i+str(14+j)].alignment = align_left_table
                    ws[i+str(14+j)].border = border_left_table

            ws['A9'].font = Font(size=8, name='Arial' )
            ws['A9'] = 'Агент: ООО "Яндекс.Доставка"'

            ws['A10'].font = Font(size=8, name='Arial' )
            ws['A10'] = 'Принципал: ООО "Товары почтой"					'

            ws['A11'].font = Font(size=8, name='Arial' )
            ws['A11'] = 'Договор: №3311014/22'

            end_table = 13 + df.shape[0]
                                    
            ws['A'+ str(end_table + 1)] = f"Итог"
            ws['A'+ str(end_table + 1)].font = Font(size=9, name='Cambria')
            ws['A'+ str(end_table + 1)].alignment = Alignment(vertical='bottom', wrap_text=True)
                                    
            ws['F'+ str(end_table + 1)] = f"{round(df['Сумма документа'].sum(), 2)}"
            ws['F'+ str(end_table + 1)].font = Font(size=9, name='Cambria')
            ws['F'+ str(end_table + 1)].alignment = Alignment(vertical='bottom', wrap_text=True)
                                    
            ws['H'+ str(end_table + 1)] = f"{round(df['Тариф'].sum(), 2)}"
            ws['H'+ str(end_table + 1)].font = Font(size=9, name='Cambria')
            ws['H'+ str(end_table + 1)].alignment = Alignment(vertical='bottom', wrap_text=True)
                                    
            ws['J'+ str(end_table + 1)] = f"{round(df['Страховой сбор'].sum(), 2)}"
            ws['J'+ str(end_table + 1)].font = Font(size=9, name='Cambria')
            ws['J'+ str(end_table + 1)].alignment = Alignment(vertical='bottom', wrap_text=True)
            
            ws['K'+ str(end_table + 1)] = f"{df['СМС'].sum()}"
            ws['K'+ str(end_table + 1)].font = Font(size=9, name='Cambria')
            ws['K'+ str(end_table + 1)].alignment = Alignment(vertical='bottom', wrap_text=True)
            
            ws['L'+ str(end_table + 1)] = f"{df['Прозвон'].sum()}"
            ws['L'+ str(end_table + 1)].font = Font(size=9, name='Cambria')
            ws['L'+ str(end_table + 1)].alignment = Alignment(vertical='bottom', wrap_text=True)
                                    
            tariff_plus_insurance = df['Тариф'].sum() + df['Страховой сбор'].sum()
            ws['A'+ str(end_table + 2)] = f"Итого: {df['Сумма документа'].count()} отправления на общую сумму  {str(int((tariff_plus_insurance // 1)))} руб {'%02d' % (round(tariff_plus_insurance % 1, 2) * 100)} коп."
            ws['A'+ str(end_table + 2)].font = Font(size=9, name='Cambria')
            ws['A'+ str(end_table + 2)].alignment = Alignment(vertical='bottom', wrap_text=True)
            ws.merge_cells('A'+str(end_table+2)+':F'+str(end_table+3))

            ws.merge_cells('B'+str(end_table+4)+':D'+str(end_table+4))
            ws['A'+str(end_table+4)] = 'Агент:'
            ws['A'+str(end_table+4)].font = Font(size=10, name='Cambria')
            ws['A'+str(end_table+4)].alignment = Alignment(vertical='center', wrap_text=True)

            ws['E'+str(end_table+4)] = 'Принципал:'
            ws['E'+str(end_table+4)].font = Font(size=10, name='Cambria')
            ws['E'+str(end_table+4)].alignment = Alignment(vertical='center', wrap_text=True)
            ws.merge_cells('E'+str(end_table+4)+':F'+str(end_table+4))

            ws['E'+str(end_table+5)] = 'ООО "Товары почтой"'
            ws['E'+str(end_table+5)].font = Font(size=10, name='Cambria', bold=True)
            ws['E'+str(end_table+5)].alignment = Alignment(vertical='top', wrap_text=True)

            ws['E'+str(end_table+6)] = 'ОГРН 1187746282789'
            ws['E'+str(end_table+6)].font = Font(size=9, name='Cambria')
            ws['E'+str(end_table+6)].alignment = Alignment(vertical='center', horizontal='left', wrap_text=True)

            ws['E'+str(end_table+7)] = 'Генеральный директор'
            ws['E'+str(end_table+7)].font = Font(size=10, name='Cambria')
            ws['E'+str(end_table+7)].alignment = Alignment(vertical='center', horizontal='left', wrap_text=True)
            ws.merge_cells('E'+str(end_table+7)+':F'+str(end_table+7))

            ws['A'+str(end_table+7)] = 'Генеральный директор'
            ws['A'+str(end_table+7)].font = Font(size=10, name='Cambria')
            ws['A'+str(end_table+7)].alignment = Alignment(vertical='center', horizontal='left', wrap_text=True)
            ws.merge_cells('A'+str(end_table+7)+':B'+str(end_table+7))
            ws.merge_cells('A'+str(end_table+8)+':B'+str(end_table+8))

            ws['E'+str(end_table+9)] = '______________   / Симонова С.Л./'
            ws['E'+str(end_table+9)].font = Font(size=10, name='Cambria')
            ws['E'+str(end_table+9)].alignment = Alignment(vertical='center', horizontal='left')

            strt_date = datetime.datetime.strptime('2022-04-07', "%Y-%m-%d")
            today = datetime.datetime.today()
            difference = today - strt_date

            ws['A8'] = f'Отчет о доставке  № {str(1+difference.days)} от {today1}г.'
            wb.save(f"Товары_почтой_{'%02d' % (datetime.datetime.today().month-1)}.22 тарифы.xlsx")
        
            list_emails = [
            'victorsemin@yandex-team.ru',
            'vzuykova@yandex-team.ru', 
            'bizhov@yandex-team.ru',
            'svkorolev@yandex-team.ru',
            'ikhomyanin@yandex-team.ru']
            send_email(
            'next_day_delivery@go.yandex.ru',
            list_emails,
            email_subject='Тарифы Товары Почтой Яндекс Доставка',
            email_text="""
            Добрый день,
            В приложении отчет по тарифам.
            """,
            file=f"Товары_почтой_{'%02d' % (datetime.datetime.today().month-1)}.22 тарифы.xlsx"
            )
