use hahn; 

$REQUEST_DATAMART = '//home/taxi-delivery/analytics/production/ndd/requests_datamart';

$SAVE_TO_1 = '//home/taxi-delivery/analytics/production/ndd/fraud/fraud_by_redemption_agg';
$SAVE_TO_2 = '//home/taxi-delivery/analytics/production/ndd/fraud/fraud_by_redemption';




$phone = 
    (select 
        distinct 
        corp_client_id
        , employer_code
        , request_id
        , phone
        , created_dttm
        , created_dt
        , max(if(mapped_event_type = 'Доставка перенесена' or mapped_event_type = 'Доставка перенесена по просьбе клиента' or mapped_event_type = 'Доставка перенесена службой доставки', event_instant_ddtm, null)) as dttm_delayed
        , max(if(mapped_event_type = 'Доставлен' or mapped_event_type = 'Доставлен частично',event_instant_ddtm, null)) as dttm_delivered
        
    from $REQUEST_DATAMART
    where 1=1
        and payment_method != 'already_paid'
        and phone is not null
    group by  corp_client_id
        , employer_code
        , request_id
        , phone 
        , created_dttm
        , substring(created_dttm,0,10) as created_dt
);

$phone_agg = 
    (select 
        corp_client_id
            , employer_code
            , phone as value_reasons_for_suspicion
            , created_dttm
            , created_dt
            , if(phone is not null, 'phone') as reasons_for_suspicion
            , count_if(dttm_delivered is not null) as cnt_dev
            , count_if(dttm_delivered is null) as cnt_not_dev
            , count(request_id) as cnt_orders
    from $phone
    group by corp_client_id
            , employer_code
            , phone
            , created_dttm
            , created_dt);

$last_name = 
    (select 
        distinct 
        corp_client_id
        , employer_code
        , request_id
        , last_name
        , created_dttm
        , created_dt
        , max(if(mapped_event_type = 'Доставка перенесена' or mapped_event_type = 'Доставка перенесена по просьбе клиента' or mapped_event_type = 'Доставка перенесена службой доставки', event_instant_ddtm, null)) as dttm_delayed
        , max(if(mapped_event_type = 'Доставлен' or mapped_event_type = 'Доставлен частично',event_instant_ddtm, null)) as dttm_delivered
        
    from $REQUEST_DATAMART
    where 1=1
        and payment_method != 'already_paid'
        and last_name is not null
    group by  corp_client_id
        , employer_code
        , request_id
        , last_name 
        , created_dttm
        , substring(created_dttm,0,10) as created_dt
);

$last_name_agg = 
    (select 
        corp_client_id
            , employer_code
            , last_name as value_reasons_for_suspicion
            , created_dttm
            , created_dt
            , if(last_name is not null, 'last_name') as reasons_for_suspicion
            , count_if(dttm_delivered is not null) as cnt_dev
            , count_if(dttm_delivered is null) as cnt_not_dev
            , count(request_id) as cnt_orders
    from $last_name
    where last_name != ""
    group by corp_client_id
            , employer_code
            , last_name
            , created_dttm
            , created_dt);

$delivery_address = 
    (select 
        distinct 
        corp_client_id
        , employer_code
        , request_id
        , delivery_address
        , created_dttm
        , created_dt
        , max(if(mapped_event_type = 'Доставка перенесена' or mapped_event_type = 'Доставка перенесена по просьбе клиента' or mapped_event_type = 'Доставка перенесена службой доставки', event_instant_ddtm, null)) as dttm_delayed
        , max(if(mapped_event_type = 'Доставлен' or mapped_event_type = 'Доставлен частично',event_instant_ddtm, null)) as dttm_delivered
        
    from $REQUEST_DATAMART
    where 1=1
        and payment_method != 'already_paid'
        and delivery_address is not null
    group by  corp_client_id
        , employer_code
        , request_id
        , delivery_address 
        , created_dttm
        , substring(created_dttm,0,10) as created_dt
);

$delivery_address_agg = 
    (select 
        corp_client_id
            , employer_code
            , delivery_address as value_reasons_for_suspicion
            , created_dttm
            , created_dt
            , if(delivery_address is not null, 'delivery_address') as reasons_for_suspicion
            , count_if(dttm_delivered is not null) as cnt_dev
            , count_if(dttm_delivered is null) as cnt_not_dev
            , count(request_id) as cnt_orders
    from $delivery_address
    where delivery_address != ""
    group by corp_client_id
            , employer_code
            , delivery_address
            , created_dttm
            , created_dt);

$email = 
    (select 
        distinct 
        corp_client_id
        , employer_code
        , request_id
        , email
        , created_dttm
        , created_dt
        , max(if(mapped_event_type = 'Доставка перенесена' or mapped_event_type = 'Доставка перенесена по просьбе клиента' or mapped_event_type = 'Доставка перенесена службой доставки', event_instant_ddtm, null)) as dttm_delayed
        , max(if(mapped_event_type = 'Доставлен' or mapped_event_type = 'Доставлен частично',event_instant_ddtm, null)) as dttm_delivered
        
    from $REQUEST_DATAMART
    where 1=1
        and payment_method != 'already_paid'
        and email is not null
    group by  corp_client_id
        , employer_code
        , request_id
        , email 
        , created_dttm
        , substring(created_dttm,0,10) as created_dt
);

$email_agg = 
    (select 
        corp_client_id
            , employer_code
            , email as value_reasons_for_suspicion
            , created_dttm
            , created_dt
            , if(email is not null, 'email') as reasons_for_suspicion
            , count_if(dttm_delivered is not null) as cnt_dev
            , count_if(dttm_delivered is null) as cnt_not_dev
            , count(request_id) as cnt_orders
    from $email
    where email != ""
    group by corp_client_id
            , employer_code
            , email
            , created_dttm
            , created_dt);


insert into $SAVE_TO_1 WITH TRUNCATE 
select * from $phone_agg 
where employer_code != 'Eva'
union all 
select * from $last_name_agg
where employer_code != 'Eva'
union all 
select * from $delivery_address_agg
where employer_code != 'Eva'
union all 
select * from $email_agg
where employer_code != 'Eva'
;


insert into $SAVE_TO_2 WITH TRUNCATE 
select 
    p.* 
    , phone as value_reasons_for_suspicion
from $phone as p 
where employer_code != 'Eva'

union all 

select 
    l.* 
    , last_name as value_reasons_for_suspicion
from $last_name as l
where employer_code != 'Eva'

union all 

select 
    d.* 
    , delivery_address as value_reasons_for_suspicion
from $delivery_address as d
where employer_code != 'Eva'

union all 

select 
    e.*
    , email as value_reasons_for_suspicion
from $email as e
where employer_code != 'Eva'
;


