use hahn;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;

$market_ndd = '//home/market/production/tpl/billing/courier/v_user_shift_aggregated_folder';
$start_date = '2021-01-01';
$sc_avaliability = '//home/taxi-delivery/analytics/production/ndd/market_warehouses/warehouse_avaliability';
$save_to = '//home/taxi-delivery/analytics/production/ndd/market_ndd/comparison';

$deliveries = (
    select
        shiftDate
        , routingVehicleType as routingvehicletype
        , sortingCenterName as sortingcentername
        , case
            when companyName in ('Яндекс.GO', 'Яндекс.Доставка') then 'Яндекс.Доставка'
            else companyName
        end as companyname
        , kgtDelivered
        , mgtDelivered
    from range($market_ndd, $start_date)
);

$totals = (
    select
        shiftDate
        , routingvehicletype
        , sortingcentername
        , sum(kgtDelivered) as kgt_total
        , sum(mgtDelivered) as mgt_total
    from $deliveries
    group by 
        shiftDate
        , routingvehicletype
        , sortingcentername
);

$companies = (
        select
            shiftDate
            , routingvehicletype
            , sortingcentername
            , companyname
            , sum(kgtDelivered) ?? 0 as kgt
            , sum(mgtDelivered) ?? 0 as mgt
        from
            (select * from $deliveries where companyname = 'Яндекс.Доставка') as t1
        left join $sc_avaliability as t2
            on t1.sortingcentername = t2.sortingcentername
            and t1.routingvehicletype = t2.routingVehicleType
        group by
            t1.shiftDate as shiftDate
            , t1.routingvehicletype as routingvehicletype
            , t1.sortingcentername as sortingcentername
            , case
                when shiftDate >= date then companyname
                else 'Яндекс.Доставка (не проф)'
            end as companyname
    union all
        select
            shiftDate
            , routingvehicletype
            , sortingcentername
            , companyname
            , sum(kgtDelivered) ?? 0 as kgt
            , sum(mgtDelivered) ?? 0 as mgt
        from
            $deliveries
        where
            companyname <> 'Яндекс.Доставка'
        group by
            shiftDate
            , routingvehicletype
            , sortingcentername
            , companyname
);


INSERT INTO $save_to WITH TRUNCATE 
select
    t1.shiftDate as shiftDate
    , t1.routingvehicletype as routingvehicletype
    , t1.sortingcentername as sortingcentername
    , t2.companyname as companyname
    , kgt ?? 0 as kgt
    , mgt ?? 0 as mgt
    , kgt_total
    , mgt_total
from $totals as t1
cross join (select distinct companyname from $companies) as t2
left join $companies as t3
        on t1.shiftDate = t3.shiftDate
        and t2.companyname = t3.companyname
        and t1.routingvehicletype = t3.routingvehicletype
        and t1.sortingcentername = t3.sortingcentername
;
