use hahn;



$supply = '//home/taxi-delivery/analytics/production/ndd/market_transit/for_market/supply_metrics';
$money = '//home/taxi-delivery/analytics/production/ndd/market_transit/for_market/money';
$save_to = '//home/taxi-delivery/analytics/production/ndd/market_transit/for_market/shifts';


insert into $save_to WITH TRUNCATE
select
    number_normalized
    , executor_profile_sk
    , full_name
    , start_ether_dttm
    , start_ride_dttm
    , end_ether_dttm
    , trips_ether
    , ether_distance_km
    , driving_distance_km
    , sum(ni_rub) ?? 0 as ni_rub
    , sum(driver_ni_rub) ?? 0 as driver_ni_rub
    , sum(gmv_rub) ?? 0 as gmv_rub
    , sum(park_comission_rub) ?? 0 as park_comission_rub
    , free_time_sec
    , supply_time_sec 
    , orders_rejected_list
    , orders_seen_ether
    , AGGREGATE_LIST(order_id) as orders
    , count(order_id) as cnt_orders
    , AGGREGATE_LIST(case when gmv_rub > 0 then order_id else null end) as trips
    , agglomeration_geo_node_id
    , cnt_user_cancelled_orders
    , cnt_driver_cancelled_orders
from $supply as s
left join $money as m
    on s.executor_profile_sk = m.executor_profile_sk
    and s.calendar_dt = m.calendar_dt
group by
    s.number_normalized as number_normalized
    , s.executor_profile_sk as executor_profile_sk
    , s.full_name as full_name
    , s.start_ether_dttm as start_ether_dttm
    , s.start_ride_dttm as start_ride_dttm
    , s.trips_ether as trips_ether
    , s.end_ether_dttm as end_ether_dttm
    , s.ether_distance_km as ether_distance_km
    , s.free_time_sec as free_time_sec
    , s.free_time_sec + s.driving_time_sec_ether + s.waiting_time_sec_ether + s.transporting_time_sec_ether as supply_time_sec
    , s.orders_rejected_list as orders_rejected_list
    , s.orders_seen_ether as orders_seen_ether
    , s.driving_distance_km as driving_distance_km
    , s.agglomeration_geo_node_id as agglomeration_geo_node_id
    , s.cnt_user_cancelled_orders as cnt_user_cancelled_orders
    , s.cnt_driver_cancelled_orders as cnt_driver_cancelled_orders
;
