use hahn;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;
PRAGMA yson.DisableStrict;
PRAGMA yt.Pool = 'taxi-delivery';


$start_date = '2022-05-30';
$start_month = '2022-05';

$executors = '//home/taxi-dwh/cdm/supply/dim_executor_profile_hist/9999-12';
$tagged_drivers = '//home/taxi-dwh/cdm/executor/dim_executor_profile_tag_list_hist/';
$fct_supply_state_hist = '//home/taxi-dwh/cdm/supply/fct_supply_state_hist';
$fct_order = '//home/taxi-dwh/cdm/marketplace/fct_order';
$fct_order_metric = '//home/taxi-dwh/cdm/marketplace/fct_order_metric';
$candidates = '//home/taxi-dwh/cdm/supply/fct_order_candidate';

$save_to = '//home/taxi-delivery/analytics/production/ndd/market_transit/for_market/supply_metrics';
$save_to2 = '//home/taxi-delivery/analytics/production/ndd/market_transit/for_market/money';

--------ыкльные функции-------------------
$parse = DateTime::Parse("%Y-%m-%d %H:%M:%S");
$delay2hr = ($x) -> (DateTime::ToSeconds(DateTime::MakeDatetime($parse($x)))-7200);
$format = DateTime::Format("%Y-%m-%d");
$fivehrcutoff = ($x) -> {
    return $format(Datetime::FromSeconds(cast($delay2hr($x) as Uint32)));
};

--------Сам скрипт

$tagged_drivers = (
    select 
        full_name,
        t1.executor_profile_sk as executor_profile_sk,
        tag_valid_from_dttm,
        tag_valid_to_dttm
    from
        (
        select
            executor_profile_sk,
            utc_valid_from_dttm as tag_valid_from_dttm,
            utc_valid_to_dttm as tag_valid_to_dttm
        from
            range($tagged_drivers, $start_month)
        where
            'drive_market_street_logistic' in Yson::ConvertToStringList(tag_code_list)
            or 'drive_market_project_a' in Yson::ConvertToStringList(tag_code_list)
            or 'drive_market_atlant'  in Yson::ConvertToStringList(tag_code_list)
            or 'drive_market_vorobushek' in Yson::ConvertToStringList(tag_code_list)
            or 'drive_market_teleportg' in Yson::ConvertToStringList(tag_code_list)
            or 'transit_comission' in Yson::ConvertToStringList(tag_code_list)
            or 'new_transit_commission' in Yson::ConvertToStringList(tag_code_list)
        ) as t1
    left join $executors as t2
        on t1.executor_profile_sk = t2.executor_profile_sk
);


$supply = (
    select
        $fivehrcutoff(utc_valid_from_dttm) as calendar_dt,
        s.executor_profile_sk as executor_profile_sk,
        car_profile_plate_id as number_normalized,
        tariff_class_code,
        executor_status_code,
        duration_sec,
        o.order_id as order_id,
        utc_valid_from_dttm,
        utc_valid_to_dttm,
        full_name,
        corp_client_id,
        distance_km,
        agglomeration_geo_node_id,
        case
            when driver_status = 'cancelled' then 'disp_cancel'
            when driver_status = 'failed' then 'driver_cancel'
            when user_status = 'cancelled' then 'user_cancel'
        else null end as canc_flg
    from $tagged_drivers as oc
    inner join range($fct_supply_state_hist, $start_date) as s
        on oc.executor_profile_sk = s.executor_profile_sk
    left join RANGE($fct_order, $start_month) as o
        on s.order_id = o.order_id
    where
        executor_status_code in ('free', 'driving', 'waiting', 'transporting')
        and utc_valid_from_dttm between tag_valid_from_dttm and tag_valid_to_dttm
);


$time = (
    select
        calendar_dt
        , some(number_normalized) as number_normalized
        , full_name
        , executor_profile_sk
        , AGGREGATE_LIST_DISTINCT(order_id) as orders_list
        , count(distinct case when canc_flg = 'user_cancel' then order_id else null end) as cnt_user_cancelled_orders
        , count(distinct case when canc_flg = 'driver_cancel' then order_id else null end) as cnt_driver_cancelled_orders
        , min(utc_valid_from_dttm) as start_ether_dttm
        , min(case when tariff_class_code is not null then utc_valid_from_dttm else null end) as start_ride_dttm
        , max(utc_valid_to_dttm) as end_ether_dttm
        , coalesce(SUM_IF(duration_sec, executor_status_code='free'),0) as free_time_sec
        , coalesce(SUM_IF(duration_sec, executor_status_code='driving'),0) as driving_time_sec_ether
        , coalesce(SUM_IF(duration_sec, executor_status_code='waiting'),0) as waiting_time_sec_ether
        , coalesce(SUM_IF(duration_sec, executor_status_code='transporting'),0) as transporting_time_sec_ether
        , coalesce(sum(distance_km), 0) as ether_distance_km
        , coalesce(SUM_IF(distance_km, executor_status_code='driving'), 0) as driving_distance_km
    from $supply
    group by
        calendar_dt
        , full_name
        , executor_profile_sk
);


-- 3. ДЕНЬГИ ИСПОЛНИТЕЛЕЙ
$exec_with_orders = (
    select distinct
        executor_profile_sk
        , number_normalized
        , order_id
    from $time
    flatten by orders_list as order_id
    
);


$supply_money = (
    select utc_dt
    , s.executor_profile_sk as executor_profile_sk
    , coalesce(sum(CASE
                    WHEN (o.success_order_flg OR o.paid_cancel_order_flg) THEN
                        (o.driver_cost + o.subsidy_value + o.holded_subsidy_value +
                        o.subsidy_commission_discount_value - o.order_commission_w_discount_wo_vat_value -
                        o.order_commission_vat_value - o.shift_commission_w_vat_value - o.call_center_commission_w_vat_value -
                        o.childchair_rent_w_vat_value - o.voucher_commission_wo_vat_value - o.holded_subsidy_commission_value -
                        o.subsidy_commission_value - o.driver_fix_comission_wo_vat_amt -
                        o.driver_fix_comission_for_fraud_wo_vat_amt - o.acquiring_commission_value - o.rebate_w_vat_value -
                        o.agency_commission_w_vat_value) * o.currency_rate
                    ELSE 0
            END),0) as driver_income_rub_ether
        , count(o.order_id) as orders
        , coalesce(count_if(o.success_order_flg),0) as trips_ether
        , coalesce(count_if(o.user_status = 'finished' and o.driver_status = 'failed'),0) as cancelled_by_driver_ether
        , coalesce(count_if(o.user_status = 'finished' and o.driver_status = 'cancelled'),0) as cancelled_by_operator_ether
    from $exec_with_orders as s
    left join RANGE($fct_order, $start_month) as o on s.order_id = o.order_id
    where utc_order_created_dttm is not null
    group by $fivehrcutoff(utc_order_created_dttm) as utc_dt
      , s.executor_profile_sk
);



-- 4. ACCEPTANCE RATE ИСПОЛНИТЕЛЕЙ

$supply_ar = (
    select utc_dt
        , e.executor_profile_sk as executor_profile_sk
        , COALESCE(count_if(c.utc_seen_dttm is not null),0) as orders_seen_ether
        , COALESCE(count_if(c.utc_assigned_dttm is not null),0) as orders_assigned_ether
        , AGGREGATE_LIST(CASE WHEN c.utc_seen_dttm is not null and c.utc_assigned_dttm is null THEN c.order_id ELSE null END) as orders_rejected_list
    from $tagged_drivers as e
    inner join RANGE($candidates, $start_month) as c on e.executor_profile_sk=c.executor_profile_sk
    where e.executor_profile_sk is not null
        and c.utc_seen_dttm is not null
        and c.utc_seen_dttm between tag_valid_from_dttm and tag_valid_to_dttm
    group by e.executor_profile_sk
      , $fivehrcutoff(c.utc_seen_dttm) as utc_dt
);

-- 5. ВЫГРУЖАЕМ РЕГИОН

$geonode = (
    select
        calendar_dt as utc_dt
        , executor_profile_sk
        , max_by(agglomeration_geo_node_id, duration_sec) as agglomeration_geo_node_id
    from (
        select
            calendar_dt
            , executor_profile_sk
            , agglomeration_geo_node_id
            , sum(duration_sec) as duration_sec
        from $supply
        where agglomeration_geo_node_id is not null
        group by
            calendar_dt
            , executor_profile_sk
            , agglomeration_geo_node_id
        )
    group by
        calendar_dt
        , executor_profile_sk
);

-- Таблица

INSERT INTO $save_to WITH TRUNCATE 
select
    calendar_dt
    , t.number_normalized as number_normalized
    , t.executor_profile_sk as executor_profile_sk
    , full_name

    , cnt_user_cancelled_orders
    , cnt_driver_cancelled_orders
    , start_ether_dttm
    , start_ride_dttm
    , end_ether_dttm
    , free_time_sec
    , driving_time_sec_ether
    , waiting_time_sec_ether
    , transporting_time_sec_ether
    , ether_distance_km
    , driving_distance_km

    , driver_income_rub_ether ?? 0 as driver_income_rub_ether
    , trips_ether ?? 0 as trips_ether
    , cancelled_by_driver_ether ?? 0 as cancelled_by_driver_ether
    , cancelled_by_operator_ether ?? 0 as cancelled_by_operator_ether
    
    , orders_seen_ether ?? 0 as orders_seen_ether
    , orders_assigned_ether ?? 0 as orders_assigned_ether
    , orders_rejected_list

    , agglomeration_geo_node_id
from $time as t
left join $supply_money as sm
    on t.executor_profile_sk = sm.executor_profile_sk
    and t.calendar_dt = sm.utc_dt
left join $supply_ar as ar
    on t.executor_profile_sk = ar.executor_profile_sk
    and t.calendar_dt = ar.utc_dt
left join $geonode as gn
    on t.executor_profile_sk = gn.executor_profile_sk
    and t.calendar_dt = gn.utc_dt
;




INSERT INTO $save_to2 WITH TRUNCATE 
select
    fom.order_id as order_id
    , $fivehrcutoff(utc_order_created_dttm) as calendar_dt
    , fom.executor_profile_sk as executor_profile_sk
    , number_normalized
    , net_inflow_total_amt*currency_rate as ni_rub
    , gmv_amt*currency_rate as gmv_rub
    , (driver_net_income_incl_paid_cancel_amt)*currency_rate as driver_ni_rub
    , success_order_flg
    , agglomeration_node_id
    , (park_commission_w_vat_value)*currency_rate as park_comission_rub
from
    range($fct_order_metric, $start_month) as fom
inner join $exec_with_orders as oc
    on oc.order_id = fom.order_id
;
