use hahn;

$supply = '//home/taxi-delivery/analytics/dev/emilsharafiev/logdata-1828/supply_metrics_v2';
$money = '//home/taxi-delivery/analytics/dev/emilsharafiev/logdata-1828/money';
$save_to = '//home/taxi-delivery/analytics/dev/emilsharafiev/logdata-1828/pulseprof';


insert into $save_to WITH TRUNCATE
select
    number_normalized
    , executor_profile_sk
    , full_name
    , start_cargocorp_dttm
    , end_cargocorp_dttm
    , start_ether_dttm
    , start_ride_dttm
    , end_ether_dttm
    , trips_ether
    , ether_distance_km
    , sum(ni_rub) as ni_rub
    , sum(driver_ni_rub) as driver_ni_rub
    , sum(gmv_rub) as gmv_rub
    , sum(park_comission_rub) as park_comission_rub
    , free_time_sec
    , supply_time_sec
    , orders_rejected_list
    , orders_seen_ether
    , AGGREGATE_LIST(order_id) as orders
    , count(order_id) as cnt_orders
    , AGGREGATE_LIST(case when gmv_rub > 0 then order_id else null end) as trips
from $supply as s
inner join $money as m
    on s.executor_profile_sk = m.executor_profile_sk
    and s.calendar_dt = m.calendar_dt
group by
    s.number_normalized as number_normalized
    , s.executor_profile_sk as executor_profile_sk
    , s.full_name as full_name
    , s.start_cargocorp_dttm as start_cargocorp_dttm
    , s.end_cargocorp_dttm as end_cargocorp_dttm
    , s.start_ether_dttm as start_ether_dttm
    , s.start_ride_dttm as start_ride_dttm
    , s.trips_ether as trips_ether
    , s.end_ether_dttm as end_ether_dttm
    , s.ether_distance_km as ether_distance_km
    , s.free_time_sec as free_time_sec
    , s.free_time_sec + s.driving_time_sec_ether + s.waiting_time_sec_ether + s.transporting_time_sec_ether as supply_time_sec
    , s.orders_rejected_list as orders_rejected_list
    , s.orders_seen_ether as orders_seen_ether
;
