use chyt.hahn/taxi-delivery;

insert into "<append=false>//home/taxi-delivery/analytics/production/ndd/market_last_mile/stats"
select shiftDate
    , uniqExact(userShiftId) as shifts_cnt
    , uniqExact(province_capital_name) as cities_cnt
    , sum(totalReward) as gmv 
    , sum(deliveredOrdersCount) as orders_cnt
    , sum(routePointsCount) as points_cnt
from (
    select t1.*
        , t2.latitude
        , t2.longitude
        , t2.region_id
        , t2.province_capital_name
    from (
        select sortingCenterId
            , sortingCenterName
            , shiftDate
            , userShiftId
            , totalReward
            , deliveredOrdersCount
            , routePointsCount
        from concatYtTablesRange('//home/market/production/tpl/billing/courier/v_user_shift_aggregated_folder', '2022-01-01') as t1 
        where 1=1
            and companyName in ('Яндекс.GO', 'Яндекс.Доставка')
    ) as t1 
    left join "//home/market/production/mstat/dwh/calculation/agg_partner_region" as t2 on t1.sortingCenterId = t2.partner_id
)
group by shiftDate;
