use hahn;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;

$lead_hist ='//home/delivery-dwh/ods/amocrm/lead_hist/2022-01-01';
$employers_history = '//home/taxi/testing/export/taxi-logistic-platform-production/employers_history';
$dm_contract_snp = '//home/taxi-dwh/cdm/b2b/dm_contract_snp';
$stations_history = '//home/taxi/testing/export/taxi-logistic-platform-production/stations_history';
$requests_history = '//home/taxi/testing/export/taxi-logistic-platform-production/requests_history';

$SAVE_TO = '//home/taxi-delivery/analytics/production/ndd/ndd_customer_funnel/customer_funnel_total';

$start_dt = '2022-07-01';
$date_format = DateTime::Format("%Y-%m-%d %H:%M:%S");

$lead_info = 
    (select 
        lead_id
        , max_by(lead_name, utc_updated_dttm) as lead_name
        , max(company_id) as company_id
        , max_by(contract_num, utc_updated_dttm) as contract_num
        -- , lead_pipeline_id
        , min(if(pipeline_ndd_phase_name in ('3. Переговоры', 'Переговоры'), utc_updated_dttm, null)) as conversation_dttm
        , min(if(pipeline_ndd_phase_name in ('4. Заключение договора', 'Заключение договора', '5. Старт', 'Старт'), utc_updated_dttm, null)) as conclusion_contract_dttm
        , min(utc_updated_dttm) as min_utc_updated_dttm
        , max(utc_updated_dttm) as max_utc_updated_dttm
        , max_by(pipeline_ndd_phase_name, utc_updated_dttm) as last_pipeline_ndd_phase_name
    from $lead_hist 
    where 1=1
        and ListHas(Yson::ConvertToStringList(product_name_list), 'NDD')
        and pipeline_ndd_phase_name in ('3. Переговоры', 'Переговоры', '4. Заключение договора', 'Заключение договора', '5. Старт', 'Старт')
    group by lead_id
    having  substring(min(utc_updated_dttm),0,10) >= $start_dt
        );

$lead_info_total = (
    select 
        cast(lead_id as string) as lead_id
        , lead_name
        , cast(company_id as string) as company_id
        , contract_num
        , if(conversation_dttm is null and (conclusion_contract_dttm is not null or contract_num is not null), min_utc_updated_dttm, conversation_dttm) as conversation_dttm
        , if(conclusion_contract_dttm is null and contract_num is not null,min_utc_updated_dttm, conclusion_contract_dttm) as conclusion_contract_dttm
        , last_pipeline_ndd_phase_name
        , min_utc_updated_dttm
    from $lead_info
);
$employers_info = 
    (select 
        employer_id
            , employer_code
            , max_by(Yson::ConvertToString(unpacked_data.brand_name), history_event_id) as brand_name
            , max_by(Yson::ConvertToString(unpacked_data.brand_name_new.brand_name_eng), history_event_id) as brand_name_eng
            , max_by(Yson::ConvertToString(unpacked_data.brand_name_new.brand_name_ru), history_event_id) as brand_name_ru
            , max_by(Yson::ConvertToString(unpacked_data.corp_client_id), history_event_id) as corp_client_id
            , max_by(Yson::ConvertToBool(unpacked_data.self_registered), history_event_id) as self_registered
            , min(history_timestamp) as start_dttm_sec
            , min($date_format(DateTime::FromSeconds(cast(history_timestamp as Uint32)))) as start_employers_dttm
            , min(history_timestamp) as start_dttm
    from range($employers_history, $start_dt)
    group by employer_id
            , employer_code
    ); 


$contract_snp_info = (
    select 
        DISTINCT 
        e.corp_client_id as corp_client_id 
        , employer_code
        , employer_id
        , brand_name
        , brand_name_eng
        , brand_name_ru
        , corp_contract_id
        , self_registered
        , start_employers_dttm
    from $employers_info as e 
    left join range($dm_contract_snp, '2022') as d on e.corp_client_id = d.corp_client_id
);

$start_work_info = 
    (select 
        l.lead_id as lead_id 
        , lead_name
        , company_id
        , contract_num
        , substring(conversation_dttm,0,10) as conversation_dt
        , substring(conclusion_contract_dttm,0,10) as conclusion_contract_dt
        , corp_client_id
        , employer_code
        , employer_id
        , brand_name
        , self_registered
        , last_pipeline_ndd_phase_name
        , substring(start_employers_dttm,0,10) as start_employers_dt
    from $lead_info_total  as l
    left join $contract_snp_info as c on l.contract_num = c.corp_contract_id
); 

$stations_history_info = 
    (select 
        operator_id
        , min(history_timestamp) as history_timestamp
        , min($date_format(DateTime::FromSeconds(cast(history_timestamp as Uint32)))) as start_station_dttm
    from  range($stations_history, $start_dt)
    group by operator_id);

$requests_history_info = (
    select 
        employer_code 
        , min($date_format(DateTime::FromSeconds(cast(history_timestamp as Uint32)))) as first_order_dttm
    from range($requests_history, $start_dt)
    group by employer_code
);


INSERT INTO $SAVE_TO WITH TRUNCATE 

select 
    w.* 
    , substring(start_station_dttm,0,10) as start_station_dt
    , substring(first_order_dttm,0,10) as first_order_dt
    , case when first_order_dttm is not null then 100 
        when start_station_dttm is not null then 80 
        when start_employers_dt is not null then 60 
        when conclusion_contract_dt is not null then 40
        when conversation_dt is not null then 20
    else NULL 
    end as funnel_percentage
from $start_work_info as w
left join $stations_history_info as s on w.employer_code = s.operator_id
left join $requests_history_info as r on w.employer_code = r.employer_code
