use hahn;

$AVAILABLE_INTERVALS = '//home/taxi-delivery/analytics/production/ndd/delivery_regions/available_intervals_v2';
$MARKET_DESTINATIONS = '//home/taxi-delivery/analytics/production/ndd/post_codes/new_market_destinations_with_dues_subtree';
$POST_CODES = '//home/taxi-delivery/analytics/production/ndd/post_codes/russian_post_idx_with_coords_and_destinations';

$SAVE_TO = '//home/taxi-delivery/analytics/production/ndd/delivery_regions/available_index_v2';

$find_type = ($id, $type) -> {
    $parents = Geo::GetParents($id);

    $parents_with_meta = ListMap(
        $parents, 
        ($parent) -> {
            return Geo::RegionById($parent);
        }
    );

    $type_region = ListFilter(
        $parents_with_meta, 
        ($parent) -> {
            return $parent.type = $type;
        }
    )[0];

    return $type_region;
};

$intervals = (
    select city_delivery_schedule
        , geo_name
        , population
        , geo_id
        , formatted_delivery_date 
        , intervals 
        , $find_type(cast(geo_id as Int32), 5).name as type_5_geo_name
        , $find_type(cast(geo_id as Int32), 6).name as type_6_geo_name
        , $find_type(cast(geo_id as Int32), 10).name as type_10_geo_name
    from $AVAILABLE_INTERVALS
    where 1=1
        and geo_id_status = 'Есть интервал'
);

$destinations_long = (
    select t1.INDEX as index 
        , t1.geo_id as post_geo_id
        , t1.post_lat as post_lat
        , t1.post_lon as post_lon
        , t2.*
    from $POST_CODES as t1
    left join (
        select geo_subtree
            , mk_dostavki
            , delivery_period
            , final_delivery_period
            , return_period_min
            , return_period_max
        from $MARKET_DESTINATIONS
    )as t2 on t1.geo_id=t2.geo_subtree
);

$destinations = (
    select distinct index
        , post_geo_id
        , post_lat
        , post_lon
        , mk_dostavki
        , delivery_period
        , final_delivery_period
        , return_period_min
        , return_period_max
    from $destinations_long
);

$intervals_with_meta = (
    select intervals.*
        , destinations.*
    from $intervals as intervals
    cross join $destinations as destinations
);

$df = (
    select *
    from $intervals_with_meta
    where 1=1
        and geo_id is not null
);

$index_info_long = (
    select *
    from $df
    where 1=1
        and Geo::IsRegionInRegion(Geo::RegionByLocation(post_lat, post_lon).id, unwrap(cast(geo_id as Int32)))
);

$index_info = (
    select distinct city_delivery_schedule
        , delivery_period
        , index
        , geo_name
        , type_5_geo_name
        , type_6_geo_name
        , type_10_geo_name
        , final_delivery_period
        , formatted_delivery_date
        , intervals 
        , mk_dostavki 
        , post_geo_id 
        , post_lat
        , post_lon
        , return_period_max
        , return_period_min
    from $index_info_long
);

insert into $SAVE_TO WITH TRUNCATE 
select *
from $index_info;
