use hahn;
PRAGMA yt.Pool = 'taxi-delivery';

$STATION_TAGS_HISTORY = '//home/taxi/testing/export/taxi-logistic-platform-production/station_tags_history';
$MARKET_REGIONS = '//home/taxi-delivery/analytics/dev/ikhomyanin/LOGDATA-1247/top_regions_with_bit_masks_and_intervals_long_v2';
$POLYGONS = '//home/geotargeting/public/geobase/fallback_borders';

$SAVE_TO = '//home/taxi-delivery/analytics/production/ndd/delivery_regions/available_intervals';

$STATION_ID = '251921c0-dfdd-4d8a-bbb6-1b1d219aa130';
$HISTORY_USER_ID = 'tag_generators_watcher';
$TAG_NAME = 'abstract_supply_promise_ydNEW_reservation';

$START_DATE = '2022-02-09';

$extract_regions_with_intervals = ($meta) -> {
    $regions_list = Yson::YPathList($meta, '/dropoff_reservations');

    $names = ListMap(
        $regions_list, ($x) -> {
            return coalesce(
                Yson::YPathString($x, '/area/polygon_area_object/polygon_name'),
                Yson::YPathString($x, '/area/geo_id_area_object/geo_name')
            );
        }  
    );

    $ids = ListMap(
        $regions_list, ($x) -> {
            return Yson::YPathInt64($x, '/area/geo_id_area_object/geo_id');
        }  
    );

    $interval = ListMap(
        $regions_list, ($x) -> {
            return Yson::YPathString($x, '/interval/hr_interval');
        }  
    );

    return ListZip($names, $ids, $interval);
};

$list_to_tuples = ($list) -> {
    $new_list = ListMap($list, ($x) -> {
        return AsStruct(
            $x.0 AS name,
            $x.1 AS id,
            $x.2 AS hr_interval
        );
    });

    return $new_list;
};

$format = DateTime::Format('%z');
$parse = DateTime::Parse("%Y-%m-%dT%H:%M:%S,%Z");
$format2 = DateTime::Format('%Y-%m-%d %H:%M:%S');

$extract_interval = ($interval, $geo_id) -> {
    $timezone = Geo::GetTimezone($geo_id);
    $string_from = ListHead(String::SplitToList($interval, '/'));
    $string_to = ListLast(String::SplitToList($interval, '/'));

    $datetime_from = DateTime::ParseIso8601($string_from);
    $datetime_to = DateTime::ParseIso8601($string_to);

    $datetime_from_tz = AddTimezone(DateTime::MakeDatetime($datetime_from), $timezone);
    $datetime_to_tz = AddTimezone(DateTime::MakeDatetime($datetime_to), $timezone);

    $new_string_from = cast($datetime_from_tz as String);
    $new_string_to = cast($datetime_to_tz as String);

    $time_from = substring($new_string_from, 11, 5);
    $time_to = substring($new_string_to, 11, 5);

    $shift = $format(DateTime::Split(AddTimezone(CurrentUtcDatetime(), Geo::GetTimezone($geo_id))));
    $pretty_shift = substring($shift,0,3) || ':' || substring($shift,3,2);

    return $time_from || '-' || $time_to;
};

$extract_date = ($interval) -> {
    return substring($interval, 0, 10);
};

$schedule_mapper = ($schedule) -> {
    $new_schedule = case
                        when $schedule = 'Ежедневно' then 'Пн, Вт, Ср, Чт, Пт, Сб, Вс'
                        else $schedule
                    end;
                
    return String::SplitToList($new_schedule, ', ');
};

$script = @@
def list_to_str(my_list):
    string = ''

    for i in my_list:
        string += (i.decode('ascii') + '; \n')

    return string.strip()
@@;

$list_to_str = Python::list_to_str(
    Callable<(List<String>?)->String?>,
    $script
);

$script2 = @@
from shapely import wkt

def transform_wkt(text):
    if text.decode('ascii') == '':
        return None
    multy = wkt.loads(text.decode('ascii'))
    try:
        coords_list = []
        for poly in multy:
            poly_coords_list = []
            poly_coords = list(poly.exterior.coords)

            for coords in poly_coords:
                poly_coords_list.append([coords[1], coords[0]])


            coords_list.append(poly_coords_list)
    except:
        coords_list = []
        poly_coords_list = []
        poly_coords = list(multy.exterior.coords)
        for coords in poly_coords:
            poly_coords_list.append([coords[1], coords[0]])
        coords_list.append(poly_coords_list)
        
    return str(coords_list)
@@;

$transform_wkt = Python::transform_wkt(
    Callable<(String?)->String?>,
    $script2
);

$tags = (
    select $list_to_tuples($extract_regions_with_intervals(unpacked_data)) as tuples
        , history_action
        , history_event_id
        , history_timestamp
        , tag_id
        -- , tag_name
    from range($STATION_TAGS_HISTORY, $START_DATE)
    where 1=1
        and object_id = $STATION_ID
        and history_user_id = $HISTORY_USER_ID
        and tag_name = $TAG_NAME
        -- and tag_id = '02a02327-4ab8-4e94-86b4-a6389abfb519'
);

$tags_flattened = (
    select *
    from $tags
    flatten list by tuples
);

$intervals = (
    SELECT distinct *
    FROM $tags_flattened
    FLATTEN COLUMNS
);

$distinct_intervals = (
    select id as geo_id
        , name as geo_name
        , $extract_interval(hr_interval, cast(id as Int32)) as delivery_interval
        , $extract_date(hr_interval) as delivery_date
        , DateTime::GetDayOfWeek(DateTime::Split(cast($extract_date(hr_interval) as Date))) as day_of_week
        , max_by(history_timestamp, history_event_id) as last_history_timestamp
        , max(history_event_id) as last_history_event_id
        , max_by(history_action, history_event_id) as last_history_action
        , max_by(tag_id, history_event_id) as last_tag_id
    from $intervals
    where id is not null
    group by id 
        , name
        , hr_interval
);

$available_intervals = (
    select *
    from $distinct_intervals 
    where 1=1
        and delivery_date >= cast(CurrentUtcDate() as String)
);

$available_intervals_min = (
    select geo_id
        , geo_name
        , min(delivery_date) as min_delivery_date
    from $available_intervals 
    group by geo_id
        , geo_name
);

$available_intervals_only_min = (
    SELECT t1.*
    from $available_intervals as t1 
    inner join $available_intervals_min as t2 on t1.geo_id=t2.geo_id and t1.geo_name=t2.geo_name and t1.delivery_date=t2.min_delivery_date
);

$available_intervals_reduced = (
    SELECT geo_id
        , geo_name
        , substring(delivery_date,8,2) || '.' || substring(delivery_date, 5, 2) as formatted_delivery_date
        , $list_to_str(coalesce(ListSort(AGGREGATE_LIST(delivery_interval)), '')) as intervals
        , 1 as available_flg
    from $available_intervals_only_min 
    group by geo_id
        , geo_name
        , delivery_date
);

$regions_reduced = (
    SELECT geo_id
        , geo_name
        , 0 as available_flg
    from $MARKET_REGIONS
    group by geo_id
        , geo_name
);

$all_regions = (
    select *
    from $available_intervals_reduced
    union all
    select *
    from $regions_reduced
    where geo_id not in (select geo_id from $available_intervals_reduced)
);

INSERT INTO $SAVE_TO WITH TRUNCATE 
select r.*
    , Geo::RegionById(cast(r.geo_id as Int32)).population as population
    , $transform_wkt(coalesce(p.geometry_wkt, '')) as poly
    , $format2($parse(cast(AddTimezone(CurrentUtcDatetime(), "Europe/Moscow") as String))) as last_update_dttm 
from $all_regions as r 
left join $POLYGONS as p on r.geo_id = p.reg_id;
