use hahn;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;
$METRICA_VISITS = '//home/taxi-delivery/analytics/production/metrica/web_dostavka_visits';
$WEB_EVENTS = '//home/taxi-delivery/analytics/production/metrica/web_dostavka';
$employers_history = '//home/taxi/testing/export/taxi-logistic-platform-production/employers_history';



$today = CurrentUtcDate();
$today_str = cast($today as string);
$month = substring($today_str,0,7) || '-01';
$day_of_full_data = '2022-06-16';

$SAVE_TO = '//home/taxi-delivery/analytics/production/ndd/product/lk/order_form/' || $month;

-- функция для преобразавания списка в пары. 
$list_to_tuples = ($list) -> {
    $new_list = ListMap($list, ($x) -> {
        return AsStruct(
            $x.0 as goal,
            $x.1 AS time,
        );
    });

    return $new_list;
};
$format = DateTime::Format("%Y-%m-%d %H:%M:%S");

-- парсим в списки необходимые нам столбцы
$yson_goals = (
    select visit_id
        , utc_visit_start_dttm
        , Yson::ConvertToInt64List(goals_id) as goals_id
        , Yson::ConvertToInt64List(goals_event_time) as goals_event_time
        , metrica_user_id
        , yandex_uid
    FROM range($METRICA_VISITS, $month)
    where substring(utc_visit_start_dttm, 0,10) >= $day_of_full_data
);

$zip_goals = 
    (select f.*
        , ListZip(goals_id, goals_event_time) as zip_goals_id_goals_event_time
    from $yson_goals as f
    where 1=1
); 

$tuples = 
    (select t.*
    , $list_to_tuples(zip_goals_id_goals_event_time) as list_zip_goals_id_goals_event_time
    from $zip_goals as t
);

$flatten_goals = (
    select * 
    from $tuples 
    flatten by list_zip_goals_id_goals_event_time
);

$flatten_goal_to_colums = (
    select * 
    from $flatten_goals
    FLATTEN COLUMNS
);

$goal_name = 
    (select 
        visit_id
        , metrica_user_id
        , yandex_uid
        , utc_visit_start_dttm
        , goal
        , time
        , case 
            when goal = 236198479 then 'NDD-LK-OrderForm-Opened'
            when goal = 236198487 then 'NDD-LK-OrderForm-Shown'
            when goal = 236198510 then 'NDD-LK-OrderForm-BlockTo-Tapped'
            when goal = 236198516 then 'NDD-LK-OrderForm-BlockTo-City-Tapped'
            when goal = 236198532 then 'NDD-LK-OrderForm-BlockTo-Adress-Tapped'
            when goal = 236198541 then 'NDD-LK-OrderForm-BlockWhere-PickUp-Points-Shown'
            when goal = 236198568 then 'NDD-LK-OrderForm-BlockWhere-PickUp-Points-Search-Tapped'
            when goal = 236198577 then 'NDD-LK-OrderForm-BlockWhere-PickUp-Points-Map-Tapped'
            when goal = 236198588 then 'NDD-LK-OrderForm-BlockWhere-PickUp-Points-Choose-Tapped'
            when goal = 236198596 then 'NDD-LK-OrderForm-BlockTo-Phone-Tapped'
            when goal = 236198601 then 'NDD-LK-OrderForm-BlockPayment-PartialRedemption-Switched'
            when goal = 236198613 then 'NDD-LK-OrderForm-BlockPayment-PartialRedemption-Shown'
            when goal = 236198628 then 'NDD-LK-OrderForm-BlockPayment-ShippingcostForTheRecipient-Tapped'
            when goal = 236198644 then 'NDD-LK-OrderForm-BlockPayment-PaymentMethod-Tapped'
            when goal = 236198649 then 'NDD-LK-OrderForm-BlockShipment-OrderID-Tapped'
            when goal = 236198662 then 'NDD-LK-OrderForm-BlockShipment-AddBox-Tapped'
            when goal = 236198669 then 'NDD-LK-OrderForm-BlockShipment-DeleteBox-Tapped'
            when goal = 236198677 then 'NDD-LK-OrderForm-BlockShipment-AddProduct-Tapped'
            when goal = 236198683 then 'NDD-LK-OrderForm-BlockShipment-DeleteProduct-Tapped'
            when goal = 236198690 then 'NDD-LK-OrderForm-BlockWhen-SelectDate-Tapped'
            when goal = 236198699 then 'NDD-LK-OrderForm-BlockWhen-SelectTime-Tapped'
            when goal = 236198709 then 'NDD-LK-OrderForm-BlockWhen-Order-Tapped'
            when goal = 244006599 then 'NDD-LK-OrderForm-BlockFrom-Tapped'
            when goal = 244006746 then 'NDD-LK-OrderForm-BlockFrom-City-Tapped'
            when goal = 244006820 then 'NDD-LK-OrderForm-BlockFrom-Adress-Tapped'
            when goal = 244007077 then 'NDD-LK-OrderForm-BlockFrom-DropOff-Points-Shown'
            when goal = 244007295 then 'NDD-LK-OrderForm-BlockFrom-DropOff-Points-Search-Tapped'
            when goal = 244007350 then 'NDD-LK-OrderForm-BlockFrom-DropOff-Points-Map-Tapped'
            when goal = 244007510 then 'NDD-LK-OrderForm-BlockFrom-DropOff-Points-Choose-Tapped'
            when goal = 227758931 then 'Button-Click-Login'
            else NULL 
        end as goal_name
        , $format(DateTime::FromSeconds(cast(time as uint32))) as dttm
    from $flatten_goal_to_colums as f
    where goal in (236198479, 236198487, 236198510, 236198516, 236198532, 236198541, 236198568, 236198577, 236198588
                 , 236198596, 236198601, 236198613, 236198628, 236198644, 236198649, 236198662, 236198669, 236198677
                 , 236198683, 236198690, 236198699, 236198709, 244006599, 244006746, 244006820, 244007077, 244007295
                 , 244007350, 244007510)
                 -- дописать цели 

    );

$step1_parse = 
    (SELECT
        url
        , substring(url,26) as goal_name
        , event_value
        , utc_event_dttm
        , yandex_uid as yandex_uid_events
        , cast(userid as string) as userid
        , event_id
    from range($WEB_EVENTS, $month)
    where 
        url like 'goal://dostavka.yandex.ru%'
        and url like '%NDD%' 
        and substring(utc_event_dttm, 0, 10) >= $day_of_full_data
);

$two_table = (
    select 
        f.* 
        , w.event_value as event_value
        , w.yandex_uid_events as yandex_uid_events
        , w.event_id as event_id
        , Yson::ConvertToString(w.event_value.id) as id -- уникальный ключ формы
        , Yson::ConvertToString(w.event_value.formID) as formID
        , Yson::ConvertToString(w.event_value.from.flow) as from_flow
        , Yson::ConvertToString(w.event_value.to.flow) as to_flow
        , Yson::ConvertToString(w.event_value.clientID) as clientID
        , Yson::ConvertToString(w.event_value.payment.payment_method) as payment_method
        , Yson::ConvertToBool(w.event_value.from.address) as  from_adress
        , Yson::ConvertToBool(w.event_value.from.city) as  from_city
        , Yson::ConvertToBool(w.event_value.to.city) as  to_city
        , Yson::ConvertToBool(w.event_value.to.address) as  to_address
        , Yson::ConvertToBool(w.event_value.to.name) as  to_name
        , Yson::ConvertToBool(w.event_value.to.phone) as  to_phone
        , Yson::ConvertToBool(w.event_value.shipment.order_id) as  shipment_order_id
        , Yson::ConvertToBool(w.event_value.shipment.box_0.barcode) as  shipment_box_0_barcode
        , Yson::ConvertToBool(w.event_value.shipment.box_0.item_0.article) as  shipment_box_0_barcode_item_0_article
        , Yson::ConvertToBool(w.event_value.shipment.box_0.item_0.assessed_price) as  shipment_box_0_barcode_item_0_assessed_price
        , Yson::ConvertToBool(w.event_value.shipment.box_0.item_0.name) as  shipment_box_0_barcode_item_0_name
        , Yson::ConvertToBool(w.event_value.shipment.box_0.item_0.price) as  shipment_box_0_barcode_item_0_price
        , Yson::ConvertToBool(w.event_value.when.date) as  when_date
        , Yson::ConvertToBool(w.event_value.when.time) as  when_time
        

from $goal_name as f
left join $step1_parse as w on f.metrica_user_id=w.userid and f.dttm = w.utc_event_dttm and f.goal_name = w.goal_name
);



$time_info = 
    (select 
        visit_id 
        , metrica_user_id
        , utc_visit_start_dttm
        , form_id
        --, min(if(goal_name = 'NDD-LK-OrderForm-Opened', time, null)) as time_OrderForm_Opened
        , min(COALESCE
                    (
                if(goal_name = 'NDD-LK-OrderForm-Shown', time,null)
                , if(goal_name = 'NDD-LK-OrderForm-Opened', time, null)
                , if(goal_name = 'NDD-LK-OrderForm-BlockTo-Tapped', time, null) 
                , if(goal_name = 'NDD-LK-OrderForm-BlockTo-City-Tapped', time, null)
                , if(goal_name = 'NDD-LK-OrderForm-BlockTo-Adress-Tapped', time, null)  
                , if(goal_name = 'NDD-LK-OrderForm-BlockFrom-Tapped', time, null) 
                , if(goal_name = 'NDD-LK-OrderForm-BlockTo-Phone-Tapped', time, null)
                , if(goal_name = 'NDD-LK-OrderForm-BlockWhere-PickUp-Points-Search-Tapped', time, null)
                , if(goal_name = 'NDD-LK-OrderForm-BlockWhere-PickUp-Points-Map-Tapped', time, null)
                , if(goal_name = 'NDD-LK-OrderForm-BlockWhere-PickUp-Points-Choose-Tapped', time, null)

                    )
                ) as time_start_form
        , max(if(goal_name = 'NDD-LK-OrderForm-BlockWhen-Order-Tapped',time , null)) as time_final_order
        , max_by(from_flow, time) as from_flow
        , max_by(to_flow, time) as to_flow
        , max(if( goal_name = 'NDD-LK-OrderForm-BlockTo-Tapped', time, null)) as time_BlockTo_Tapped
        , max(if(goal_name = 'NDD-LK-OrderForm-BlockTo-City-Tapped', time, null)) as time_BlockTo_City_Tapped
        , max(if(goal_name = 'NDD-LK-OrderForm-BlockTo-Adress-Tapped', time, null)) as time_BlockTo_Adress_Tapped
        , max(if(goal_name = 'NDD-LK-OrderForm-BlockWhere-PickUp-Points-Shown', time, null)) as time_BlockWhere_PickUp_Points_Shown
        , max(if(goal_name = 'NDD-LK-OrderForm-BlockWhere-PickUp-Points-Search-Tapped', time, null)) as time_BlockWhere_PickUp_Points_Search_Tapped
        , max(if(goal_name = 'NDD-LK-OrderForm-BlockWhere-PickUp-Points-Map-Tapped', time, null)) as time_BlockWhere_PickUp_Points_Map_Tapped
        , max(if(goal_name = 'NDD-LK-OrderForm-BlockWhere-PickUp-Points-Choose-Tapped', time, null)) as time_BlockWhere_PickUp_Points_Choose_Tapped
        , max(if(goal_name = 'NDD-LK-OrderForm-BlockTo-Phone-Tapped', time, null)) as time_BlockTo_Phone_Tapped
        , max(if(goal_name = 'NDD-LK-OrderForm-BlockPayment-PartialRedemption-Switched', time, null)) as time_BlockPayment_PartialRedemption_Switched
        , max(if(goal_name = 'NDD-LK-OrderForm-BlockPayment-PartialRedemption-Shown', time, null)) as time_BlockPayment_PartialRedemption_Shown
        , max(if(goal_name = 'NDD-LK-OrderForm-BlockPayment-ShippingcostForTheRecipient-Tapped', time, null)) as time_BlockPayment_ShippingcostForTheRecipient_Tapped
        , max(if(goal_name = 'NDD-LK-OrderForm-BlockPayment-PaymentMethod-Tapped', time, null)) as time_BlockPayment_PaymentMethod_Tapped
        , max(if( goal_name = 'NDD-LK-OrderForm-BlockShipment-OrderID-Tapped', time, null)) as time_BlockShipment_OrderID_Tapped
        , max(if(goal_name = 'NDD-LK-OrderForm-BlockShipment-AddBox-Tapped', time, null)) as time_BlockShipment_AddBox_Tapped
        , max(if(goal_name = 'NDD-LK-OrderForm-BlockShipment-AddProduct-Tapped', time, null)) as time_BlockShipment_AddProduct_Tapped
        , max(if(goal_name = 'NDD-LK-OrderForm-BlockWhen-SelectDate-Tapped', time, null)) as time_BlockWhen_SelectDate_Tapped
        , max(if(goal_name = 'NDD-LK-OrderForm-BlockWhen-SelectTime-Tapped', time, null)) as time_BlockWhen_SelectTime_Tapped
        , max(if(goal_name = 'NDD-LK-OrderForm-BlockFrom-Tapped', time, null)) as time_BlockFrom_Tapped
        , max(if(goal_name = 'NDD-LK-OrderForm-BlockFrom-City-Tapped', time, null)) as time_BlockFrom_City_Tapped
        , max(if(goal_name = 'NDD-LK-OrderForm-BlockFrom-Adress-Tapped', time, null)) as time_BlockFrom_Adress_Tapped
        , max(if(goal_name = 'NDD-LK-OrderForm-BlockFrom-DropOff-Points-Shown', time, null)) as time_BlockFrom_DropOff_Points_Shown
        , max(if(goal_name = 'NDD-LK-OrderForm-BlockFrom-DropOff-Points-Search-Tapped', time, null)) as time_BlockFrom_DropOff_Points_Search_Tapped
        , max(if(goal_name = 'NDD-LK-OrderForm-BlockFrom-DropOff-Points-Map-Tapped', time, null)) as time_BlockFrom_DropOff_Points_Map_Tapped
        , max(if(goal_name = 'NDD-LK-OrderForm-BlockFrom-DropOff-Points-Choose-Tapped', time, null)) as time_BlockFrom_DropOff_Points_Choose_Tapped
        , max_by(clientID, time) as clientID
        , some(payment_method) as payment_method
        , some(from_adress) as from_adress
        , some(from_city) as from_city
        , some(to_city) as to_city
        , some(to_address) as to_address
        , some(to_name) as to_name
        , some(to_phone) as to_phone
        , some(shipment_order_id) as shipment_order_id
        , some(shipment_box_0_barcode) as shipment_box_0_barcode
        , some(shipment_box_0_barcode_item_0_article) as shipment_box_0_barcode_item_0_article
        , some(shipment_box_0_barcode_item_0_assessed_price) as shipment_box_0_barcode_item_0_assessed_price
        , some(when_date) as when_date 
        , some(when_time) as when_time
    from $two_table
    group by visit_id 
        , metrica_user_id
        , utc_visit_start_dttm
        , COALESCE(id, formID) as form_id
    );

$employers_info = 
    (select 
        employer_id
            , employer_code
            ,  max_by(Yson::ConvertToString(unpacked_data.brand_name), history_event_id) as brand_name
            , max_by(Yson::ConvertToString(unpacked_data.brand_name_new.brand_name_eng), history_event_id) as brand_name_eng
            , max_by(Yson::ConvertToString(unpacked_data.brand_name_new.brand_name_ru), history_event_id) as brand_name_ru
            , max_by(Yson::ConvertToString(unpacked_data.corp_client_id), history_event_id) as corp_client_id
            , max_by(Yson::ConvertToBool(unpacked_data.self_registered), history_event_id) as self_registered
            , min(history_timestamp) as start_dttm_sec
    from range($employers_history, '2022-06-01')
    group by employer_id
            , employer_code
); 

INSERT INTO $SAVE_TO WITH TRUNCATE 
select 
    visit_id 
    , metrica_user_id
    , utc_visit_start_dttm
    , clientID
    , employer_code
    , self_registered
    , brand_name
    , form_id
    , time_start_form
    , time_final_order
    , from_flow
    , to_flow
    , time_BlockTo_Tapped
    , time_BlockTo_City_Tapped
    , time_BlockTo_Adress_Tapped
    , time_BlockWhere_PickUp_Points_Shown
    , time_BlockWhere_PickUp_Points_Search_Tapped
    , time_BlockWhere_PickUp_Points_Map_Tapped
    , time_BlockWhere_PickUp_Points_Choose_Tapped
    , time_BlockTo_Phone_Tapped
    , time_BlockPayment_PartialRedemption_Switched
    , time_BlockPayment_PartialRedemption_Shown
    , time_BlockPayment_ShippingcostForTheRecipient_Tapped
    , time_BlockPayment_PaymentMethod_Tapped
    , time_BlockShipment_OrderID_Tapped
    , time_BlockShipment_AddBox_Tapped
    , time_BlockShipment_AddProduct_Tapped
    , time_BlockWhen_SelectDate_Tapped
    , time_BlockWhen_SelectTime_Tapped
    , time_BlockFrom_Tapped
    , time_BlockFrom_City_Tapped
    , time_BlockFrom_Adress_Tapped
    , time_BlockFrom_DropOff_Points_Shown
    , time_BlockFrom_DropOff_Points_Search_Tapped
    , time_BlockFrom_DropOff_Points_Map_Tapped
    , time_BlockFrom_DropOff_Points_Choose_Tapped
    , payment_method
    , from_adress
    , from_city
    , to_city
    , to_address
    , to_name
    , to_phone
    , shipment_order_id
    , shipment_box_0_barcode
    , shipment_box_0_barcode_item_0_article
    , shipment_box_0_barcode_item_0_assessed_price
    , when_date 
    , when_time
    , time_final_order - time_start_form as time_fill_the_form_sec
from $time_info as t
left join $employers_info as e on t.clientID = e.corp_client_id
;



$info = '//home/taxi-delivery/analytics/production/ndd/product/lk/order_form';
$seven_days_before = cast($today - Interval('P7D') as string);

$SAVE_TO_2 = '//home/taxi-delivery/analytics/production/ndd/product/lk/users_info';

$metrica_user_info = (
    select 
        metrica_user_id
        , clientID
        , employer_code
        , self_registered
        , case 
            when min(utc_visit_start_dttm) between $seven_days_before and $today_str then 'new user'
            else 'old user'
        end as user_info
    from range($info,'2022-06-01')
    group by metrica_user_id
        , clientID
        , employer_code
        , self_registered
);

$metrica_user_info_total = (
    select 
        i.metrica_user_id as metrica_user_id
        , m.clientID as clientID
        , m.employer_code as employer_code
        , m.self_registered as self_registered
        , utc_visit_start_dttm
        , form_id
        , substring(utc_visit_start_dttm,0,10) as utc_visit_start_dt
        , from_flow
        , to_flow
        , user_info
        , time_start_form
        , time_final_order
        , time_BlockFrom_DropOff_Points_Choose_Tapped
        , time_BlockFrom_DropOff_Points_Choose_Tapped - time_start_form as time_DropOff_Choose
    from range($info,'2022-06-01') as i
    left join $metrica_user_info as m on i.metrica_user_id = m.metrica_user_id
);

INSERT INTO $SAVE_TO_2 WITH TRUNCATE 
select *
from $metrica_user_info_total;
