use hahn;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;

$SUPPORT = '//home/taxi-dwh/ods/chatterbox_support_taxi/ticket';
$REQUEST_DATAMART = '//home/taxi-delivery/analytics/production/ndd/requests_datamart';
$FEEDBACKS = '//home/taxi/production/replica/postgres/cargo_c2c/clients_feedbacks';
$CLIENTS_ORDERS = '//home/taxi/production/replica/postgres/cargo_c2c/clients_orders';
$SAVE_TO = '//home/taxi-delivery/analytics/production/ndd/product/contact_rate/contact_rate_refresh';

-- $today = CurrentUtcDate();
-- $yesterday = cast($today - Interval('P1D') as string); 
$month_start = '2022-03-01';
$format = DateTime::Format("%Y-%m-%d %H:%M:%S");

$OPERATOR_ID = [
    'yd'
    , 'strizh'
    , 'top-delivery'
];


$orders = (
    select 
        corp_client_id
        , employer_code
        , request_id
        , created_dttm
        , planned_delivery_dt
        , operator_id
        , policy
        , max(event_instant_ddtm) as max_event_instant_ddtm
        , max_by(mapped_event_type, history_event_id) as last_order_status
    from $REQUEST_DATAMART
    where 1=1
    and substring(created_dttm,0,10) >= $month_start
        and operator_id in $OPERATOR_ID
    group by  corp_client_id
        , employer_code
        , request_id
        , created_dttm
        , planned_delivery_dt
        , operator_id
        , policy
);

$support_lp_orders = 
    (select  
        utc_created_dttm as utc_created_ticket_dttm
        , utc_updated_dttm as utc_updated_ticket_dttm
        , chatterbox_ticket_id
        , order_id
        , csat_value
        , csat_value_raw
        , first_answer_mnt
        , full_resolve_mnt
        , theme_name
        , chat_type
        , reopen_cnt
        , ticket_sector_name
        , calc_ticket_category_name
    from range($SUPPORT, $month_start) 
    where order_id in ( select request_id from $orders)
);

$orders_and_support = 
    (select * 
    from $orders as o
    left join $support_lp_orders as s on o.request_id = s.order_id
    );
   
$info = 
    (select 
        DateTime::Format('%Y-%m-%d %H:%M:%S')(DateTime::MakeDatetime(DateTime::ParseIso8601(max_event_instant_ddtm))) as max_event_instant_ddtm
        , DateTime::Format('%Y-%m-%d %H:%M:%S')(DateTime::MakeDatetime(DateTime::ParseIso8601(created_dttm))) as created_dttm
        , corp_client_id
        , employer_code
        , request_id
        , last_order_status
        , planned_delivery_dt
        , operator_id
        , policy
        , utc_created_ticket_dttm 
        , chatterbox_ticket_id
        , order_id as order_id_support
        , csat_value
        , csat_value_raw
        , first_answer_mnt
        , full_resolve_mnt
        , theme_name
        , chat_type
        , reopen_cnt
        , ticket_sector_name
        , calc_ticket_category_name
    from $orders_and_support);

$feedback = (
        select 
            phone_pd_id
            , order_id as order_id_feedback
            , score
            , comment
            , cancel_comment
            , cast($format(DateTime::FromSeconds(cast(updated_ts as Uint32))) as string) as ddt_feedback 
            , updated_ts
        from $FEEDBACKS
        where order_provider_id = 'logistic-platform'
    );

$order_roles_full_info = (
    SELECT
        order_id
        , order_provider_id 
        , phone_pd_id as phone_pd_id_o
        , roles
        , IF(ListHas(Yson::ConvertToStringList(roles), 'recipient'), 1, 0) AS is_recipient
        , IF(ListHas(Yson::ConvertToStringList(roles), 'initiator'), 1, 0) AS is_initiator
        , IF(ListHas(Yson::ConvertToStringList(roles), 'sender'), 1, 0) AS is_sender
    FROM $CLIENTS_ORDERS
    where  1=1
        and order_provider_id = 'logistic-platform'
);

$total_info = (
    select 
    i.*
    , f.*
    , o.*
    from $info as i
    left join $feedback as f on i.request_id = f.order_id_feedback
    left join $order_roles_full_info as o on i.request_id = o.order_id
);


insert into $SAVE_TO WITH TRUNCATE 
select 
    t.* 
    , case 
        when order_id_feedback is not null and order_id_support is not null then 'applied to support'
        when  order_id_feedback is not null and order_id_support is null then 'not applied to support'
        else 'not applied to support'
    end as feedback_score_support_status
    , case 
        when is_initiator = 1 then 'initiator'
        when is_recipient = 1 then 'recipient'
        when is_sender = 1 then 'sender'
        when is_initiator = 1 and is_recipient = 1 then 'initiator and recipient'
        when is_initiator = 1 and is_sender = 1 then 'initiator and sender'
        when is_recipient = 1 and is_sender = 1 then 'recipient and sender'
        else NULL 
    end as roles_info
from $total_info as t
;
