use hahn; 

PRAGMA AnsiInForEmptyOrNullableItemsCollections;
PRAGMA yson.DisableStrict;
PRAGMA AnsiOptionalAs;
PRAGMA yt.Pool = 'taxi-delivery';

$today = CurrentUtcDate();
$one_day_before = cast($today - Interval('P1D') as string);
$two_days_before = cast($today - Interval('P2D') as string);
$three_days_before = cast($today - Interval('P3D') as string);
$four_days_before = cast($today - Interval('P4D') as string); 


$days = [
    $one_day_before
    , $two_days_before
    , $three_days_before
    , $four_days_before
];



$format = DateTime::Format("%Y-%m-%d %H:%M:%S");

$script = @@
def list_to_str(my_list):
    string = ''

    for i in my_list:
        string += (i.decode('utf-8') + ',\n ')

    return string.strip()
@@;

$list_to_str = Python::list_to_str(
    Callable<(List<String>?)->String?>,
    $script
);


$processing_interval_policy_code = ['interval_strict', 'interval_with_fees', 'AFAP', 'min_by_request', 'self_pickup'];
$logistic_platform_source_type = ['ndd', 'market'];


$DT_START = '2022-02-01';


$FEEDBACKS = '//home/taxi/production/replica/postgres/cargo_c2c/clients_feedbacks';
$REQUEST_DATAMART = '//home/taxi-delivery/analytics/production/ndd/requests_datamart';

$SAVE_TO = '//home/taxi-delivery/analytics/production/k2/product_analytics/ndd_feedback/total';

    -- заказы с ЛогПлоатформы 
    $orders = (
    select 
         request_id
        , some(operator_id) as operator_code
        , some(employer_code) as employer_code
        , some(if(request_id is not null, 'ndd', null)) as logistic_platform_source_type
        , some(policy) as processing_interval_policy_code
        , utc_created_dttm
        -- , some(available_tariff_class_code_list) as available_tariff_class_code_list
        -- , some(taxi_user_phone_id) as taxi_user_phone_id
        -- , some(taxi_user_phone_pd_id) as taxi_user_phone_pd_id
        -- , some(lavka_order_id) as lavka_order_id
        -- , some(order_status) as order_status
        -- , some(status_code) as status_code
        , max($format(cast(event_instant_ddtm as Datetime))) as uts_end_dttm
        , some(policy) as product  
     --   , some(final_status) as final_status
    from $REQUEST_DATAMART
    where 1=1
       and substring(created_dttm,0,10) >= $DT_START 
       and operator_id != 'taxi-external'
       and operator_id != 'lavka'
       and employer_code != 'Eva' 
       and employer_code != 'tsa'
    group by 
        request_id
        , $format(cast(created_dttm as Datetime)) as utc_created_dttm
    );

    -- feedback 
    $feedback = (
        select 
            phone_pd_id
            , order_id
            , score
            , $list_to_str(Yson::ConvertToStringList(reasons)) as reasons
            , comment
            , $list_to_str(Yson::ConvertToStringList(cancel_reasons)) as cancel_reasons
            , cancel_comment
            , cast($format(DateTime::FromSeconds(cast(updated_ts as Uint32))) as string) as ddt_feedback 
            , updated_ts
        from $FEEDBACKS
        where order_provider_id = 'logistic-platform'
    );
    INSERT INTO $SAVE_TO WITH TRUNCATE 
    select 
        request_id
        , operator_code
        , employer_code
        , product
        , logistic_platform_source_type
        , processing_interval_policy_code
        , utc_created_dttm
        , phone_pd_id
        , order_id
        , score as score
        , reasons
        , comment
        , cancel_reasons
        , cancel_comment
        , ddt_feedback
        , if(reasons like '%above_expectations%', 1, 0) as above_expectations
        , if(reasons like '%fast_delivery%', 1, 0) as fast_delivery
        , if(reasons like '%perfect%', 1, 0) as perfect
        , if(reasons like '%polite_courier%', 1, 0) as polite_courier
        , if(reasons like '%another_courier_arrived%', 1, 0) as another_courier_arrived
        , if(reasons like '%unable_to_contact%', 1, 0) as unable_to_contact
        , if(reasons like '%long_delivery%', 1, 0) as long_delivery
        , if(reasons like '%comment%', 1, 0) as comment_reason
        , if(reasons like '%extra_funds%', 1, 0) as extra_funds
        , if(reasons like '%impolite%', 1, 0) as impolite
        , if(reasons like '%no_delivery%', 1, 0) as no_delivery
        , if(reasons like '%not_door_to_door%', 1, 0) as not_door_to_door
        , if(reasons like '%damaged_package%', 1, 0) as damaged_package
    from $orders as o
    left join $feedback as f on o.request_id = f.order_id;
