PRAGMA AnsiInForEmptyOrNullableItemsCollections;
PRAGMA yson.DisableStrict;

USE hahn;


$script = @@
def list_to_str(my_list):
    string = ''

    for i in my_list:
        string += (i.decode('utf-8') + ',\n ')

    return string.strip()
@@;

$list_to_str = Python::list_to_str(
    Callable<(List<String>?)->String?>,
    $script
);

$format = DateTime::Format("%Y-%m-%d %H:%M:%S");
$dt_format = DateTime::Format('%Y-%m-%d');


$DT_START = '2022-02-01';

$processing_interval_policy_code = ['interval_strict', 'interval_with_fees', 'AFAP', 'min_by_request', 'self_pickup'];
$logistic_platform_source_type = ['ndd', 'market'];



$REQUEST_DATAMART = '//home/taxi-delivery/analytics/production/ndd/requests_datamart';
$SMS_LOGS = '//home/logfeller/logs/taxi-ucommunications-user-sms-log/1d';
$SMS_STATUS_LOG = '//home/logfeller/logs/taxi-ucommunications-user-sms-status-log/1d';
$PUSH_LOGS = '//home/logfeller/logs/taxi-ucommunications-user-notfications-push-log/1d';
$PUSH_STATUS_LOGS = '//home/logfeller/logs/taxi-ucommunications-user-notfications-push-status-log/1d'; 
$APP_METRICA = '//home/taxi-delivery/analytics/production/product/sms_and_go_sharing/sharing_from_appmetrica'; 
$CLIENTS_ORDERS = '//home/taxi/production/replica/postgres/cargo_c2c/clients_orders';
$WEB_DOSTAVKA = '//home/taxi-delivery/analytics/production/metrica/web_dostavka' ;
$FEEDBACKS = '//home/taxi/production/replica/postgres/cargo_c2c/clients_feedbacks';

$SAVE_TO = '//home/taxi-delivery/analytics/production/k2/product_analytics/ndd_sharing/total';


$orders = (
    select 
         request_id
        , some(operator_id) as operator_code
        , some(employer_code) as employer_code
        , some(if(request_id is not null, 'ndd', null)) as logistic_platform_source_type
        , some(policy) as processing_interval_policy_code
        , utc_created_dttm
        -- , some(available_tariff_class_code_list) as available_tariff_class_code_list
        -- , some(taxi_user_phone_id) as taxi_user_phone_id
        -- , some(taxi_user_phone_pd_id) as taxi_user_phone_pd_id
        -- , some(lavka_order_id) as lavka_order_id
        -- , some(order_status) as order_status
        -- , some(status_code) as status_code
        , max($format(cast(event_instant_ddtm as Datetime))) as uts_end_dttm
        , some(policy) as product  
     --   , some(final_status) as final_status
    from $REQUEST_DATAMART
    where 1=1
       and substring(created_dttm,0,10) >= $DT_START 
       and operator_id != 'taxi-external'
       and operator_id != 'lavka'
       and employer_code != 'Eva' 
       and employer_code != 'tsa'
    group by 
        request_id
        , $format(cast(created_dttm as Datetime)) as utc_created_dttm
    );


--sms
    $messages = (
        SELECT
            message_id
            , intent AS m_intent
            , status AS m_status
            , phone_id AS phone_pd_id
            , Yson::ConvertToString(Yson::ParseJson(meta).order_id) AS order_id
            , Yson::ConvertToString(Yson::ParseJson(meta).order_provider_id) AS order_provider_id
            , iso_eventtime as uts_dt_m
            , intent as intent_m
            , text as text_m
            , Yson::ConvertToString(Yson::ParseJson(meta).info.description) AS description_m
        FROM range($SMS_LOGS, $DT_START)
        WHERE TRUE
            AND status = 'sent'
            AND Yson::ConvertToString(Yson::ParseJson(meta).order_provider_id) IS NOT NULL
            AND Yson::ConvertToString(Yson::ParseJson(meta).order_provider_id) = 'logistic-platform'
            AND Yson::ConvertToString(Yson::ParseJson(meta).order_id) IS NOT NULL
            and Yson::ConvertToString(Yson::ParseJson(meta).order_id) in (
                select request_id from $orders
                    
            )
    );

    $m_statuses = (
        SELECT
            DISTINCT(message_id)
            , 0 AS m_delivered
        FROM range($SMS_STATUS_LOG, $DT_START)
        WHERE status = 'undelivered'
            and message_id in (select message_id from $messages)
    );

    $m_total = (
        SELECT
            order_id
            , order_provider_id
            , phone_pd_id
            , message_id
            , COUNT(T1.message_id) AS m_sent
            , SUM(COALESCE(m_delivered, 1)) AS m_delivered
            , min(substring(uts_dt_m,0,10)) as uts_dt_m
            , intent_m
            , text_m
            , description_m
        FROM $messages AS T1
            LEFT JOIN $m_statuses AS T2 ON T1.message_id = T2.message_id
        GROUP BY
            T1.order_id AS order_id
            , T1.order_provider_id AS order_provider_id
            , T1.phone_pd_id AS phone_pd_id
            -- , T1.uts_dt_m as uts_dt_m
            , T1.intent_m as intent_m
            , T1.text_m as text_m
            , T1.description_m as description_m
            , T1.message_id as message_id
    );

--push
    $pushes = (
        SELECT
            notification_id
            , intent AS p_intent
            , iso_eventtime as uts_dt_p
            , Yson::ConvertToString(Yson::ParseJson(meta).order_id) AS order_id
            , Yson::ConvertToString(Yson::ParseJson(meta).order_provider_id) AS order_provider_id
            , Yson::ConvertToString(Yson::ParseJson(meta).phone_pd_id) AS phone_pd_id
        FROM range($PUSH_LOGS, $DT_START)
        WHERE TRUE
            AND status != 'error'
            AND Yson::ConvertToString(Yson::ParseJson(meta).order_provider_id) IS NOT NULL
            AND Yson::ConvertToString(Yson::ParseJson(meta).order_id) IS NOT NULL
            AND Yson::ConvertToString(Yson::ParseJson(meta).order_provider_id) = 'logistic-platform'
            AND Yson::ConvertToString(Yson::ParseJson(meta).phone_pd_id) IS NOT NULL
            AND Yson::ConvertToString(Yson::ParseJson(meta).order_id) in (
                select request_id from $orders
            )
    );

    $p_statuses = (
        SELECT
            DISTINCT(notification_id)
            , 1 AS p_delivered
        FROM range($PUSH_STATUS_LOGS, $DT_START)
        WHERE status = 'delivered'
            and notification_id in (select notification_id from $pushes)
    );

    $p_total = (
        SELECT
            order_id
            , order_provider_id
            , phone_pd_id
            , p_intent
            , notification_id
            , max(substring(uts_dt_p,0,10)) as uts_dt_p
            , COUNT(T1.notification_id) AS p_sent
            , SUM(COALESCE(p_delivered, 0)) AS p_delivered
        FROM $pushes AS T1
            LEFT JOIN $p_statuses AS T2 ON T1.notification_id = T2.notification_id
        GROUP BY
            T1.order_id AS order_id
            , T1.order_provider_id AS order_provider_id
            , T1.phone_pd_id AS phone_pd_id
            , T1.p_intent as p_intent
            , T1.notification_id as notification_id
    );

    $all_communications = (
        SELECT
            COALESCE(T1.order_id, T2.order_id) AS order_id
            , COALESCE(T1.order_provider_id, T2.order_provider_id) AS order_provider_id
            , COALESCE(T1.phone_pd_id, T2.phone_pd_id) AS phone_pd_id
            , COALESCE(p_sent, 0) AS p_sent
            , COALESCE(p_delivered, 0) AS p_delivered
            , COALESCE(m_sent, 0) AS m_sent
            , COALESCE(m_delivered, 0) AS m_delivered
            , COALESCE(uts_dt_p, null) as uts_dt_p
            , COALESCE(uts_dt_m, null) as uts_dt_m
            , COALESCE(intent_m, null) as intent_m
            , COALESCE(text_m, null) as text_m
            , COALESCE(description_m, null) as description_m
            , COALESCE(p_intent, null) as p_intent
            , COALESCE(notification_id, null) as notification_id
            , COALESCE(message_id, null) as message_id
            , CASE
                WHEN p_delivered > 0 THEN IF(m_delivered > 0, 'SMS + notification', 'notification')
                ELSE IF(m_delivered > 0, 'SMS', 'no_communication')
            END AS contacted_by
        FROM $m_total AS T1
            FULL JOIN $p_total AS T2 ON (
                T1.order_id = T2.order_id
                AND T1.order_provider_id = T2.order_provider_id
                AND T1.phone_pd_id = T2.phone_pd_id
                and T1.uts_dt_m = T2.uts_dt_p
            )
    );


    ---- сбор смс и пушей 
    $total_info_sms_and_push = (
        select 
            request_id 
            , employer_code
            , operator_code
            , utc_created_dttm
            , product 
            , order_id 
            , order_provider_id
            , phone_pd_id
            , p_sent
            , p_delivered
            , m_sent
            , m_delivered
            , contacted_by
            , uts_dt_p
            , uts_dt_m
            , uts_end_dttm
            , logistic_platform_source_type
            , processing_interval_policy_code
            , intent_m
            , text_m
            , description_m
            , p_intent
            , notification_id
            , message_id
        from $orders as o 
        left join $all_communications as a on o.request_id = a.order_id 
    );

    -- открытие шарилки в го 

    $go = (
        select 
            order_id
            , phone_pd_id
            --, session_id
            , user_id
            -- , SOME(substring(utc_event_dttm,0,10)) as utc_event_dt_go
            , SUM(if(event_name = 'PreviewOrderList.Shown', 1, 0) )as PreviewOrderList_Shown
            , SUM(if(event_name = 'PreviewOrderList.Tapped', 1, 0)) as PreviewOrderList_Tapped
            , SUM(if(event_name = 'SharedOrderCard.Shown', 1, 0)) as SharedOrderCard_Shown
            , SUM(if(event_name = 'SharedOrderCard.Opened', 1, 0)) as SharedOrderCard_Opened
            , SUM(if(event_name = 'SharedOrderCard.Tapped', 1, 0)) as SharedOrderCard_Tapped
        from range($APP_METRICA, $DT_START)
        where 1=1 
            and order_provider_id = 'logistic-platform'
            -- and substring(utc_event_dttm,0,10) between '2022-03-01' and '2022-03-06'
        group by order_id
            , phone_pd_id
            -- , session_id
            , user_id
            -- , substring(utc_event_dttm,0,10) as utc_event_dt_go

    );

    -- откртие шарилки на сайте 
    $web_dostavka = (
        select 
            sharing_key
            , cl.order_id as order_id
            , some(app_platform) as app_platform
            , some(cl.roles) as roles
            , some(cl.user_id) as user_id
            , some(cl.resolution) as resolution
            , max(substring(utc_event_dttm,0,10)) as utc_event_dt_web
            , count(*) as cnt 
        from range($WEB_DOSTAVKA, $DT_START) as web 
        left join  $CLIENTS_ORDERS as cl on web.sharing_key = cl.sharing_key
        where url = 'goal://dostavka.yandex.ru/OpenSharedRoute'
            and order_provider_id = 'logistic-platform'
        group by 
            web.sharing_key as sharing_key
           -- , substring(utc_event_dttm,0,10) as utc_event_dt
            , cl.order_id as order_id
    );

    -- feedback 
    $feedback = (
        select 
            phone_pd_id
            , order_id
            , score
            , $list_to_str(Yson::ConvertToStringList(reasons)) as reasons
            , comment
            , $list_to_str(Yson::ConvertToStringList(cancel_reasons)) as cancel_reasons
            , cancel_comment
            , cast($format(DateTime::FromSeconds(cast(updated_ts as Uint32))) as string) as ddt_feedback 
            -- , updated_ts
        from $FEEDBACKS
        where order_provider_id = 'logistic-platform'
    );


    -- INSERT INTO $table_to WITH TRUNCATE 
    ----все вместе 
    -- $sms_and_push_flag = (
    --     select 
    --         request_id
    --         , if(m_sent>0, 1, 0) as m_sent_flg
    --         , if(p_sent>0, 1, 0) as p_sent_flg
    --         , if(m_delivered>0, 1, 0) as m_delivered_flg
    --         , if(p_delivered>0, 1, 0) as p_delivered_flg
    --     from $total_info_sms_and_push
    -- );

    INSERT INTO $SAVE_TO WITH TRUNCATE 
    ----все вместе 
    select DISTINCT 
        t.request_id as request_id
            , employer_code
            , operator_code
            , utc_created_dttm
            , product 
            , t.order_id as order_id
            , order_provider_id
            , t.phone_pd_id as phone_pd_id
            , COALESCE(p_sent,0) as p_sent
            , COALESCE(p_delivered,0) as p_delivered
            , COALESCE(m_sent, 0)as m_sent
            , COALESCE(m_delivered, 0) as m_delivered
            , contacted_by
            , uts_dt_p
            , uts_dt_m
            -- , utc_event_dt_go
            , PreviewOrderList_Shown
            , PreviewOrderList_Tapped
            , SharedOrderCard_Shown
            , SharedOrderCard_Opened
            , SharedOrderCard_Tapped
            , IF(COALESCE(PreviewOrderList_Shown, SharedOrderCard_Shown, 0)>0, 1, 0) as it_is_shown
            , sharing_key
            , utc_event_dt_web
            , COALESCE(cnt,0) as cnt_web 
            , score
            , reasons
            , comment
            , cancel_reasons
            , cancel_comment
            , uts_end_dttm
            , ddt_feedback
            , logistic_platform_source_type
            , processing_interval_policy_code
            , app_platform
            , intent_m
            , text_m
            , description_m
            , p_intent
            , notification_id
            , message_id
            -- , case when p_intent = intent_m then intent_m 
            --     else 'different intent'
            -- end as general_intent
            -- , m_sent_flg
            -- , p_sent_flg
            -- , m_delivered_flg
            -- , p_delivered_flg
    from $total_info_sms_and_push as t
    left join $go as g on t.request_id = g.order_id
    left join $web_dostavka as w on t.request_id = w.order_id
    left join $feedback as f on t.request_id = f.order_id
    -- left join $sms_and_push_flag as fl on t.request_id = fl.request_id
    ;
