use hahn;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;

$SUPPORT = '//home/taxi-dwh/ods/chatterbox_support_taxi/ticket';
$REQUEST_DATAMART = '//home/taxi-delivery/analytics/production/ndd/requests_datamart';

$SAVE_TO = '//home/taxi-delivery/analytics/production/ndd/product/sms_alerts/support';

$today = CurrentUtcDate();
$yesterday = cast($today - Interval('P1D') as string); 
$month_start = substring($yesterday,0,7) || '-01';

$OPERATOR_ID = [
    'yd'
    , 'strizh'
    , 'top-delivery'
];


$orders = (
    select 
        corp_client_id
        , employer_code
        , request_id
        , created_dttm
        , planned_delivery_dt
        , operator_id
        , max(event_instant_ddtm) as max_event_instant_ddtm
        , max_by(mapped_event_type, history_event_id) as last_order_status
    from $REQUEST_DATAMART
    where 1=1
    and substring(created_dttm,0,10) >= $month_start
        and operator_id in $OPERATOR_ID
    group by  corp_client_id
        , employer_code
        , request_id
        , created_dttm
        , planned_delivery_dt
        , operator_id
);

$support_lp_orders = 
    (select  utc_created_dttm as utc_created_ticket_dttm
        , chatterbox_ticket_id
        , order_id
    from range($SUPPORT, $month_start) 
    where order_id in ( select request_id from $orders)
);

$test = 
    (select * 
    from $orders as o
    left join $support_lp_orders as s on o.request_id = s.order_id
    );
   
INSERT INTO $SAVE_TO WITH TRUNCATE 
select 
    DateTime::Format('%Y-%m-%d %H:%M:%S')(DateTime::MakeDatetime(DateTime::ParseIso8601(max_event_instant_ddtm))) as max_event_instant_ddtm
    , DateTime::Format('%Y-%m-%d %H:%M:%S')(DateTime::MakeDatetime(DateTime::ParseIso8601(created_dttm))) as created_dttm
    , corp_client_id
    , employer_code
    , request_id
    , last_order_status
    , planned_delivery_dt
    , operator_id
    , utc_created_ticket_dttm 
    , chatterbox_ticket_id
    , order_id
from $test;
