
use hahn; 
PRAGMA AnsiInForEmptyOrNullableItemsCollections;
PRAGMA yson.Strict = 'false';

$REQUEST_DATAMART = '//home/taxi-delivery/analytics/production/ndd/requests_datamart';
$SMS_LOGS_D = '//home/logfeller/logs/taxi-ucommunications-user-sms-log/1d';
$SMS_STATUS_LOG_D = '//home/logfeller/logs/taxi-ucommunications-user-sms-status-log/1d';
$SMS_LOGS_H = '//home/logfeller/logs/taxi-ucommunications-user-sms-log/1h';
$SMS_STATUS_LOG_H = '//home/logfeller/logs/taxi-ucommunications-user-sms-status-log/1h';

$SAVE_TO = '//home/taxi-delivery/analytics/production/ndd/product/sms_alerts/updating_table_7_days';

$today = CurrentUtcDate();
$today_string = cast($today as string);
$days_before_35 = cast($today - Interval('P7D') as string); 

$parse3 = DateTime::Parse("%Y-%m-%d");
$format = DateTime::Format('%Y-%m-%d %H:%M:%S');

$OPERATOR_ID = [
    'yd'
    , 'strizh'
    , 'top-delivery'
];

$STATUS = 
    [
        'DELIVERY_TRANSPORTATION_RECIPIENT'
        , 'CREATED'
    ];

$orders = (
    select 
        corp_client_id
        , employer_code
        , request_id
        , created_dttm
        , planned_delivery_dt
        , operator_id
        , max(event_instant_ddtm) as max_event_instant_ddtm
        -- , event_instant_ddtm
        , COUNT_IF(operator_lp_status = 'DELIVERY_TRANSPORTATION_RECIPIENT') as cnt_del_trans 
        , COUNT_IF(operator_lp_status = 'CREATED') as cnt_created
        , MAX(if (operator_lp_status = 'CREATED', event_instant_ddtm, null)) as utc_created_ddtm_status 
        , MAX(if (operator_lp_status = 'DELIVERY_TRANSPORTATION_RECIPIENT', event_instant_ddtm, null)) as utc_transportation_ddtm 
    from $REQUEST_DATAMART
    where 1=1
    and substring(event_instant_ddtm,0,10) between $days_before_35 and $today_string
        and operator_lp_status in $STATUS
        and operator_id in $OPERATOR_ID
    group by  corp_client_id
        , employer_code
        , request_id
        , created_dttm
        , planned_delivery_dt
        , operator_id
);
$orders2 = 
    (select 
        corp_client_id
        , request_id
        , employer_code
        , planned_delivery_dt
        , operator_id
        , max_event_instant_ddtm
        , cnt_del_trans
        , cnt_created
        , utc_created_ddtm_status
        , utc_transportation_ddtm
        , created_dttm
        , DateTime::ToSeconds(DateTime::MakeDate($parse3(planned_delivery_dt))) - DateTime::ToSeconds(DateTime::MakeDate($parse3(substring(created_dttm,0,10)))) as diff_time
    from $orders)
; 
$sms_logs = 
    (SELECT
        message_id
        , intent AS m_intent
        , status AS m_status
        , phone_id AS phone_pd_id
        , Yson::ConvertToString(Yson::ParseJson(meta).order_id) AS order_id
        , Yson::ConvertToString(Yson::ParseJson(meta).order_provider_id) AS order_provider_id
        , iso_eventtime as uts_dt_m
        , $format(DateTime::FromMicroseconds(cast(created / 1000 as Uint64)))  as uts_dttm_m
        , intent as intent_m
        , text as text_m
        , Yson::ConvertToString(Yson::ParseJson(meta).info.description) AS description_m
    from range($SMS_LOGS_D,$days_before_35)
    WHERE TRUE
            AND status = 'sent'
            AND Yson::ConvertToString(Yson::ParseJson(meta).order_provider_id) IS NOT NULL
            AND Yson::ConvertToString(Yson::ParseJson(meta).order_provider_id) = 'logistic-platform'
            AND Yson::ConvertToString(Yson::ParseJson(meta).order_id) IS NOT NULL
            and Yson::ConvertToString(Yson::ParseJson(meta).order_id) in (
                select request_id from $orders2    
            )

    union all 

    SELECT
        message_id
        , intent AS m_intent
        , status AS m_status
        , phone_id AS phone_pd_id
        , Yson::ConvertToString(Yson::ParseJson(meta).order_id) AS order_id
        , Yson::ConvertToString(Yson::ParseJson(meta).order_provider_id) AS order_provider_id
        , iso_eventtime as uts_dt_m
        , $format(DateTime::FromMicroseconds(cast(created / 1000 as Uint64)))  as uts_dttm_m
        , intent as intent_m
        , text as text_m
        , Yson::ConvertToString(Yson::ParseJson(meta).info.description) AS description_m
    from range($SMS_LOGS_H,$today_string)
    WHERE TRUE
            AND status = 'sent'
            AND Yson::ConvertToString(Yson::ParseJson(meta).order_provider_id) IS NOT NULL
            AND Yson::ConvertToString(Yson::ParseJson(meta).order_provider_id) = 'logistic-platform'
            AND Yson::ConvertToString(Yson::ParseJson(meta).order_id) IS NOT NULL
            and Yson::ConvertToString(Yson::ParseJson(meta).order_id) in (
                select request_id from $orders2    
            )

    
 );

$sms_status_logs = (
    SELECT
        DISTINCT(message_id)
        , 0 AS m_delivered
        FROM range($SMS_STATUS_LOG_D, $days_before_35)
        WHERE status = 'undelivered'
            and message_id in (select message_id from $sms_logs)
    
    union all 

     SELECT
        DISTINCT(message_id)
        , 0 AS m_delivered
        FROM range($SMS_STATUS_LOG_H, $today_string)
        WHERE status = 'undelivered'
            and message_id in (select message_id from $sms_logs)
);

$total_sms = 
    (select order_id 
        , order_provider_id
        , max(uts_dttm_m) as last_uts_dttm_m
        , some(if(intent_m = 'delivery_ndd_new_order', uts_dttm_m, null)) as delivery_ndd_new_order_uts_dttm
        -- , max(if(intent_m = 'delivery_ndd_transportation_recipient', uts_dttm_m, null)) as last_delivery_ndd_transportation_recipient_uts_dttm
        , COUNT(T1.message_id) AS m_sent
        , SUM(COALESCE(T2.m_delivered, 1)) AS m_delivered
        , count_if(intent_m = 'delivery_ndd_new_order') as sum_delivery_ndd_new_order
        , count_IF(intent_m = 'delivery_ndd_transportation_recipient') as sum_delivery_ndd_transportation_recipient
    FROM $sms_logs AS T1
                LEFT JOIN $sms_status_logs AS T2 ON T1.message_id = T2.message_id
    group by T1.order_id as order_id
        , T1.order_provider_id as order_provider_id 
       --  , T1.uts_dttm_m  as uts_dttm_m
    );

$final_table = 
    (select 
        request_id
        , corp_client_id
        , employer_code
        , created_dttm
        , utc_created_ddtm_status
        , planned_delivery_dt
        , diff_time
        , operator_id
        , max_event_instant_ddtm
        , cnt_del_trans as number_of_statuses_del_trans_recipient
        , cnt_created as number_of_statuses_created
        , utc_transportation_ddtm as last_utc_transportation_ddtm
        , delivery_ndd_new_order_uts_dttm as sms_delivery_ndd_new_order_uts_dttm
        , last_uts_dttm_m as last_uts_dttm_sms_sent
        , sum_delivery_ndd_new_order
        , sum_delivery_ndd_transportation_recipient
        , m_sent
        , m_delivered
    from $orders2 as o2
    left join $total_sms as t on o2.request_id = t.order_id
);

insert into $SAVE_TO WITH TRUNCATE 
select 
    request_id
    , DateTime::Format('%Y-%m-%d %H:%M:%S')(DateTime::MakeDatetime(DateTime::ParseIso8601(created_dttm))) as created_dttm
    , planned_delivery_dt as planned_delivery_dt
    , operator_id
    , employer_code
    , case 
        when diff_time > 1728000 then 'order more than 20 days'
        else 'everything is fine'
    end as long_delivery_flg
    , DateTime::Format('%Y-%m-%d %H:%M:%S')(DateTime::MakeDatetime(DateTime::ParseIso8601(sms_delivery_ndd_new_order_uts_dttm))) as sms_delivery_ndd_new_order_uts_dttm 
    , case 
        when utc_created_ddtm_status is not null and sms_delivery_ndd_new_order_uts_dttm is null then 'first sms has not been sent'
        else 'first sms has been sent'
    end as first_sms_flg
    , number_of_statuses_del_trans_recipient
    , sum_delivery_ndd_transportation_recipient
    , case 
        when number_of_statuses_del_trans_recipient = 0 and sum_delivery_ndd_transportation_recipient= 0 then 'delivery has not started yet'
        when number_of_statuses_del_trans_recipient = 0 and sum_delivery_ndd_transportation_recipient is null then 'delivery has not started yet'
        when number_of_statuses_del_trans_recipient > sum_delivery_ndd_transportation_recipient then 'sms about delivery has not been sent'
        else 'sms about delivery has been sent'
    end as delivery_sms_flg
    , DateTime::Format('%Y-%m-%d %H:%M:%S')(DateTime::MakeDatetime(DateTime::ParseIso8601(last_uts_dttm_sms_sent))) as last_uts_dttm_sms_sent
    , DateTime::Format('%Y-%m-%d %H:%M:%S')(DateTime::MakeDatetime(DateTime::ParseIso8601(max_event_instant_ddtm))) as max_event_instant_ddtm
from $final_table;


