use hahn; 
PRAGMA yson.DisableStrict;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;

$leads = '//home/delivery-dwh/ods/amocrm/lead/lead';
$lead_lost = '//home/delivery-dwh/ods/amocrm/lead_loss_reason/lead_loss_reason';
$employers_history = '//home/taxi/testing/export/taxi-logistic-platform-production/employers_history';
$dm_contract_snp = '//home/taxi-dwh/cdm/b2b/dm_contract_snp';
$request_datamart = '//home/taxi-delivery/analytics/production/ndd/requests_datamart';
$tele = '//home/taxi-delivery/analytics/dev/fedorivashkin/touch/Telemarketing'; 

$SAVE_TO_reasons_for_outflow = '//home/taxi-delivery/analytics/production/ndd/product/lk/reasons_for_outflow';
$SAVE_TO_first_touch = '//home/taxi-delivery/analytics/production/ndd/product/lk/first_touch';

$dt_start = '2022-07-15';

$lead_info = 
    (select 
        lead_id
        , utc_created_dttm
        , leak_ndd_reason_code
        , wish_ndd_name_list
        , loss_ndd_reason_code
        , loss_express_reason_code
        , integration_ndd_status
        , channel_name
        , contract_num
        , lead_loss_reason_id
        , Yson::ConvertToStringList(product_name_list) as product_name_list
    from $leads 
    where ListHas(Yson::ConvertToStringList(product_name_list), 'NDD')
        and channel_name = 'САМООБРАЩЕНИЕ'
        and substring(utc_created_dttm,0,10) >= $dt_start
        and loss_ndd_reason_code is not null 
    );

$employers_info = 
    (select 
        employer_id
            , employer_code
            ,  max_by(Yson::ConvertToString(unpacked_data.brand_name), history_event_id) as brand_name
            , max_by(Yson::ConvertToString(unpacked_data.brand_name_new.brand_name_eng), history_event_id) as brand_name_eng
            , max_by(Yson::ConvertToString(unpacked_data.brand_name_new.brand_name_ru), history_event_id) as brand_name_ru
            , max_by(Yson::ConvertToString(unpacked_data.corp_client_id), history_event_id) as corp_client_id
            , max_by(Yson::ConvertToBool(unpacked_data.self_registered), history_event_id) as self_registered
            , min(history_timestamp) as start_dttm_sec
            , min(history_timestamp) as start_dttm
    from range($employers_history, '2022-07-10')
    
    group by employer_id
            , employer_code
    ); 


$contract_snp_info = (
    select 
        DISTINCT 
        e.corp_client_id as corp_client_id 
        , employer_code
        , employer_id
        , brand_name
        , brand_name_eng
        , brand_name_ru
        , corp_contract_id
        , self_registered
        , start_dttm_sec
    from $employers_info as e 
    left join range($dm_contract_snp, '2022') as d on e.corp_client_id = d.corp_client_id
);
$request_datamart_info = (
    select 
         corp_client_id
           , min(substring(created_dttm,0,10)) as first_delivery_dt
           , min(created_dttm) as first_delivery_dttm
           , max( substring(created_dttm,0,10)) as last_delivery_dt
           , count(DISTINCT request_id) as cnt_deliveries
    from $request_datamart
    where corp_client_id is not null
        and corp_client_id != ''
        and mapped_event_type in ('Доставлен', 'Доставлен частично')
        and corp_client_id in (select corp_client_id from $employers_info)
        and substring(created_dttm,0,10) >= $dt_start
    group by corp_client_id  
);

INSERT INTO $SAVE_TO_reasons_for_outflow WITH TRUNCATE 

select 
    l.* 
    , c.*
    , r.*
    , case when start_dttm_sec is not null then 'завели клиента'
        -- when activated_dttm is not null then 'активировали клиента'
        when first_delivery_dttm is not null then 'сделал первую поездку'
        when cnt_deliveries >=5  then 'сделал 5 поездок'
        when cnt_deliveries >=10  then 'сделал 10 поездок'
        else 'первое косание'
    end as funnel_stage
    , lead_loss_reason_name
from $lead_info as l
left join $lead_lost as ls on l.lead_loss_reason_id=cast(ls.lead_loss_reason_id as Int64)
left join $contract_snp_info as c on l.contract_num = c.corp_contract_id
left join $request_datamart_info as r on c.corp_client_id = r.corp_client_id
;


INSERT INTO $SAVE_TO_first_touch WITH TRUNCATE 

select
    ticket_code
    , main_product
    , non_target_reason
    , reject_reason
    , archi_source_type_value
    , min(if(call_dttm is null,event_dttm, substring(call_dttm,0,19))) as full_call_dttm
from $tele 
where 1=1
    and archi_source_type_value = 'Самообращения'
    and main_product = 'Доставка на следующий день (NDD)'
    and call_status_value = 'Звонок состоялся'
    and (non_target_reason is not null or reject_reason is not null)
group by ticket_code
    , main_product
    , non_target_reason
    , reject_reason
    , archi_source_type_value
having  min(if(call_dttm is null,event_dttm, substring(call_dttm,0,19))) >= $dt_start
; 
