use hahn; 
PRAGMA AnsiInForEmptyOrNullableItemsCollections;


$requests_datamart = '//home/taxi-delivery/analytics/production/ndd/requests_datamart';
$employers_history = '//home/taxi/testing/export/taxi-logistic-platform-production/employers_history';
$dm_contract_snp = '//home/taxi-dwh/cdm/b2b/dm_contract_snp';
$web_info = '//home/taxi-delivery/analytics/production/ndd/product/lk/order_form';


$dt_start = '2022-07-01';


$today = CurrentUtcDate();
$days_before_5 = $today - Interval('P5D');
$days_before_3 = $today - Interval('P3D');
$date_format = DateTime::Format("%Y-%m-%d %H:%M:%S");

$SAVE_to_table_employers_info = '//home/taxi-delivery/analytics/production/ndd/product/lk/employers_info_self_reg';

$SAVE_TO_5_days_without_orders = '//home/taxi-delivery/analytics/production/ndd/product/lk/5_days_without_orders';

$SAVE_TO_3_days_without_orders_after_emloyer = '//home/taxi-delivery/analytics/production/ndd/product/lk/3_days_without_orders_after_emloyer';

$web_info_1 = (
    select
        clientID
        , min(utc_visit_start_dttm) as min_utc_visit_start_dttm
        , substring(min(utc_visit_start_dttm),0,10) as min_utc_visit_start_dt
    from range($web_info, '2022-07-01')
    group by clientID
);


$employers_info = 
    (select 
        employer_id
            , employer_code
            ,  max_by(Yson::ConvertToString(unpacked_data.brand_name), history_event_id) as brand_name
            , max_by(Yson::ConvertToString(unpacked_data.brand_name_new.brand_name_eng), history_event_id) as brand_name_eng
            , max_by(Yson::ConvertToString(unpacked_data.brand_name_new.brand_name_ru), history_event_id) as brand_name_ru
            , max_by(Yson::ConvertToString(unpacked_data.corp_client_id), history_event_id) as corp_client_id
            , max_by(Yson::ConvertToBool(unpacked_data.self_registered), history_event_id) as self_registered
            , min(history_timestamp) as start_dttm_sec
            , $date_format(DateTime::FromSeconds(cast(min(history_timestamp) as Uint32))) as start_dttm
    from range($employers_history, '2022-07-01')
    group by employer_id
            , employer_code
); 

 
$request_datamart_info = (
    select 
        corp_client_id
            , employer_id
            , min(substring(created_dttm,0,10)) as first_order_dt
            , min(created_dttm) as first_order_dttm
            , max(substring(created_dttm,0,10)) as last_order_dt
            , max(created_dttm) as last_order_dttm
            , max_by(request_id, created_dttm) as max_request_id
            , min_by(request_id, created_dttm) as min_request_id
            , count(DISTINCT request_id) as cnt_orders
            , count(DISTINCT if(mapped_event_type in ('Доставлен', 'Доставлен частично'),request_id, null)) as cnt_deliveries
            
            -- , if(cast(max(substring(created_dttm,0,10)) as date) >= cast(min(substring(created_dttm,0,10)) as date) + Interval('P1D'),'1days', null) as day1_flg
            -- , if(cast(max(substring(created_dttm,0,10)) as date) >= cast(min(substring(created_dttm,0,10)) as date) + Interval('P7D'),'7days', null) as day7_flg
            -- , if(cast(max(substring(created_dttm,0,10)) as date) >= cast(min(substring(created_dttm,0,10)) as date) + Interval('P14D'),'14days', null) as day14_flg
            -- , if(cast(max(substring(created_dttm,0,10)) as date) >= cast(min(substring(created_dttm,0,10)) as date) + Interval('P30D'),'30days', null) as day30_flg
            , if(cast(max(substring(created_dttm,0,10)) as date) <= $days_before_5, '5 days without orders', null) as five_days_without_orders
    from $requests_datamart
    where corp_client_id is not null
        and corp_client_id != ''
    group by corp_client_id 
        , employer_id 
    having substring(min(created_dttm),0,10) >= $dt_start
);

INSERT INTO $SAVE_to_table_employers_info WITH TRUNCATE 

select 
    r.corp_client_id as corp_client_id
    , e.employer_id as employer_id
    , start_dttm
    , min_utc_visit_start_dt
    , first_order_dt
    , last_order_dttm
    , last_order_dt
    , employer_code
    , brand_name_eng
    , brand_name_ru
    , brand_name
    , self_registered
    , min_request_id
    , max_request_id
    , cnt_orders
    , cnt_deliveries
    , min_utc_visit_start_dttm
    , if(min_utc_visit_start_dt = first_order_dt,1,0) as day1_flg
    -- , day1_flg
    -- , day7_flg
    -- , day14_flg
    -- , day30_flg
from $employers_info as e 
left join $request_datamart_info as r on r.corp_client_id = e.corp_client_id
left join $web_info_1 as w on e.corp_client_id = w.clientID
where self_registered = true
;


$contract_snp_info = (
    select 
        DISTINCT 
        e.corp_client_id as corp_client_id 
        , employer_code
        , employer_id
        , brand_name
        , brand_name_eng
        , brand_name_ru
        , corp_contract_id
        , self_registered
        , $date_format(DateTime::FromSeconds(cast(start_dttm_sec as Uint32))) as start_dttm
    from $employers_info as e 
    left join range($dm_contract_snp, '2022') as d on e.corp_client_id = d.corp_client_id
);

 


INSERT INTO $SAVE_TO_5_days_without_orders WITH TRUNCATE 

select 
    r.corp_client_id as corp_client_id
    , e.employer_id as employer_id
    , corp_contract_id as contruct_num
    , first_order_dt
    , last_order_dttm
    , last_order_dt
    , employer_code
    , brand_name_eng
    , brand_name_ru
    , brand_name
    , self_registered
    , min_request_id
    , max_request_id
from $contract_snp_info as e 
left join $request_datamart_info as r on r.corp_client_id = e.corp_client_id
where self_registered = true
and five_days_without_orders = '5 days without orders'
;
    

$total = 
    (SELECT
        c.* 
        , c.corp_client_id as corp_client_id_r
        , first_order_dt
    from $contract_snp_info as c 
    left join $request_datamart_info as r on c.corp_client_id = r.corp_client_id);


INSERT INTO $SAVE_TO_3_days_without_orders_after_emloyer WITH TRUNCATE 
SELECT 
    corp_client_id
    , corp_contract_id as contract_num
    , employer_id
    , start_dttm
    , employer_code
    , if(cast(substring(start_dttm,0,10) as date) <= $days_before_3 and first_order_dt is null, '3 days without orders', null) as three_days_without_orders
    , first_order_dt
from $total
where 1=1
    and self_registered  = true
;
