use hahn;

$requests_datamart = '//home/taxi-delivery/analytics/production/ndd/requests_datamart';
$market_orders = '//home/market/production/tpl/cdc/market_tpl_production_orders';
$order_history_event = '//home/market/production/mstat/dwh/raw/market_tpl/order_history_event';
$order_status_history = '//home/market/production/tpl/sc/cdc/order_ff_status_history';
$start_month = '2022-03';
$save_to = '//home/taxi-delivery/analytics/dev/emilsharafiev/logdata-1968/orders';

----убираем t и z из timestamp
$symbols = [("T"," "), ("Z"," ")];
$mapping_cyr2lat = ToDict(
    ListMap(
        $symbols,
        ($pair) -> ((
            Unwrap(Unicode::ToCodePointList(CAST($pair.0 AS Utf8))[0]),
            Unwrap(Unicode::ToCodePointList(CAST($pair.1 AS Utf8))[0])
        ))
    )
);
$remove = ($word) -> (CAST(Unicode::FromCodePointList(ListMap(
    Unicode::ToCodePointList(CAST($word AS Utf8)),
    ($cp) -> ($mapping_cyr2lat[$cp] ?? $cp)
)) AS String));
----------

$tsa_orders = (
    select distinct
        request_code,
        external_order_id,
        cast(external_order_id as int64) as external_order_id_int,
        request_id,
        "LO-"|| external_order_id as barcode,
        created_dttm,
        operator_id,
        policy
    from 
        $requests_datamart
    where employer_code = 'tsa'
);

$osh = (
    select
        request_code,
        max(created_at) as sc_created_at,
        MAX_BY(ff_status,created_at) as last_ff_status
    from $order_status_history as osh
    inner join $tsa_orders as to
        on to.external_order_id_int = osh.order_id
    group by
        to.request_code as request_code
);

INSERT INTO $save_to WITH TRUNCATE 
select
    t1.request_code as request_code,
    t1.external_order_id as external_order_id,
    $remove(substring(created_dttm, 0, 19)) as created_dttm,
    order_flow_status as pi_status,
    $remove(substring(cast(order_flow_status_updated_at as string), 0, 19)) as pi_status_dttm,
    tariff,
    last_ff_status as sc_status,
    $remove(substring(cast(sc_created_at as string), 0, 19)) as sc_status_dttm,
    operator_id,
    policy,
    request_id as logplatform_id
from
    $tsa_orders as t1
left join $market_orders as t2
    on t1.barcode = t2.external_order_id
left join $osh as t3
    on t1.request_code = t3.request_code
;
