-- https://st.yandex-team.ru/LOGDATA-417
-- Отчет 1

USE hahn;
PRAGMA yt.InferSchema;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;
PRAGMA yt.UseNativeYtTypes;

-- CORP_CLIENT_ID - Название
------------------------------------------------------------
-- 1a3a4511c8004fd1896d003c2ab06808 - Икстрим
-- 4c438b35503947319fde61b943a567ab - Носимо
-- 3f9df08db4084a8d9e6d6bbc6e676a04 - Реинвент
-- ddd5277ed27342ccb85e73c643c4b5bb - Рестор
-- 63ba685360f24dc4ad1258d9bb0905ae - Агентство Книга Сервис
-- e393ac7ec1974da5bdffa0708548a9f9 - ИП Одиноков
-- 602888cae1ab4026a24ce7a763a39ef8 - ИП Суворова
-- 100d513731f149cab40d2408b0c08aba - Модена
-- f028e22f2a014f1dbbfea702488acdd2 - Главзвук/ СПЛ Таганка
-- f2b09e63b57d41688487b121ffc54dc6 - Бариста
-- 100d513731f149cab40d2408b0c08aba - Маркет

-- МЕНЯТЬ ПАРАМЕТРЫ ЗДЕСЬ ==============================================================================================
$CORP_CLIENT_ID = 'f2b09e63b57d41688487b121ffc54dc6';
$START_DATE = '2021-06-01'; -- ГГГГ-ММ-ДД, иначе будет долго отрабатывать
$END_DATE = '2021-06-20'; -- ГГГГ-ММ-ДД, иначе будет долго отрабатывать
-- =====================================================================================================================

-- Источники
$REQUESTS = '//home/taxi-delivery/analytics/production/ndd/requests_datamart';

-- ПРОВЕРКА НА РАСПОЛОЖЕНИЕ ВНУТРИ МКАД ================================================================================
$py_poly = @@
from shapely.geometry import Polygon, Point

mkad = [
    [37.842762,55.774558],
    [37.842789,55.76522],
    [37.842627,55.755723],
    [37.841828,55.747399],
    [37.841217,55.739103],
    [37.840175,55.730482],
    [37.83916,55.721939],
    [37.837121,55.712203],
    [37.83262,55.703048],
    [37.829512,55.694287],
    [37.831353,55.68529],
    [37.834605,55.675945],
    [37.837597,55.667752],
    [37.839348,55.658667],
    [37.833842,55.650053],
    [37.824787,55.643713],
    [37.814564,55.637347],
    [37.802473,55.62913],
    [37.794235,55.623758],
    [37.781928,55.617713],
    [37.771139,55.611755],
    [37.758725,55.604956],
    [37.747945,55.599677],
    [37.734785,55.594143],
    [37.723062,55.589234],
    [37.709425,55.583983],
    [37.696256,55.578834],
    [37.683167,55.574019],
    [37.668911,55.571999],
    [37.647765,55.573093],
    [37.633419,55.573928],
    [37.616719,55.574732],
    [37.60107,55.575816],
    [37.586536,55.5778],
    [37.571938,55.581271],
    [37.555732,55.585143],
    [37.545132,55.587509],
    [37.526366,55.5922],
    [37.516108,55.594728],
    [37.502274,55.60249],
    [37.49391,55.609685],
    [37.484846,55.617424],
    [37.474668,55.625801],
    [37.469925,55.630207],
    [37.456864,55.641041],
    [37.448195,55.648794],
    [37.441125,55.654675],
    [37.434424,55.660424],
    [37.42598,55.670701],
    [37.418712,55.67994],
    [37.414868,55.686873],
    [37.407528,55.695697],
    [37.397952,55.702805],
    [37.388969,55.709657],
    [37.383283,55.718273],
    [37.378369,55.728581],
    [37.374991,55.735201],
    [37.370248,55.744789],
    [37.369188,55.75435],
    [37.369053,55.762936],
    [37.369619,55.771444],
    [37.369853,55.779722],
    [37.372943,55.789542],
    [37.379824,55.79723],
    [37.386876,55.805796],
    [37.390397,55.814629],
    [37.393236,55.823606],
    [37.395275,55.83251],
    [37.394709,55.840376],
    [37.393056,55.850141],
    [37.397314,55.858801],
    [37.405588,55.867051],
    [37.416601,55.872703],
    [37.429429,55.877041],
    [37.443596,55.881091],
    [37.459065,55.882828],
    [37.473096,55.884625],
    [37.48861,55.888897],
    [37.5016,55.894232],
    [37.513206,55.899578],
    [37.527597,55.90526],
    [37.543443,55.907687],
    [37.559577,55.909388],
    [37.575531,55.910907],
    [37.590344,55.909257],
    [37.604637,55.905472],
    [37.619603,55.901637],
    [37.635961,55.898533],
    [37.647648,55.896973],
    [37.667878,55.895449],
    [37.681721,55.894868],
    [37.698807,55.893884],
    [37.712363,55.889094],
    [37.723636,55.883555],
    [37.735791,55.877501],
    [37.741261,55.874698],
    [37.764519,55.862464],
    [37.765992,55.861979],
    [37.788216,55.850257],
    [37.788522,55.850383],
    [37.800586,55.844167],
    [37.822819,55.832707],
    [37.829754,55.828789],
    [37.837148,55.821072],
    [37.838926,55.811599],
    [37.840004,55.802781],
    [37.840965,55.793991],
    [37.841576,55.785017]
]

def in_mkad(lon, lat):
    poly = Polygon(mkad)
    point = Point(lat, lon)
    if poly.contains(point):
        return True
    else:
        return False
@@;

$in_polygon = Python3::in_mkad(Callable<(Double?, Double?) -> Bool?>, $py_poly);

-- Определеяем первую дату доставки с учетом ограничения на временной период и клиента
$orders_delivery_dttm = (
    select request_id
      , min(tech_event_instant_ddtm) as delivered_first_dttm
    from $REQUESTS
    where mapped_event_type in ('Доставлен', 
                                'Доставлен частично')
      and corp_client_id = $CORP_CLIENT_ID
    group by request_id
    having substring(min(tech_event_instant_ddtm), 0, 10) between $START_DATE and $END_DATE
);

-- Определяем наиболее актуальный статус заказа
$orders_final_status = (
    select request_id
      , max(tech_event_instant_ddtm) as last_status_update_dttm
    from $REQUESTS
    where request_id in (
        select request_id from $orders_delivery_dttm
    )
    group by request_id
);

-- Заказы, по которым не было доставки, но был возврат
$returned_orders = (
    SELECT request_id
      , request_code
      , payment_method
      , items_assessed_price
      , null as delivered_first_dttm
      , tech_event_instant_ddtm as last_status_update_dttm
      , AsList(mapped_event_type) as last_status
      , 1.0*weight/1000 as weight
      , x_coord as latitude
      , y_coord as longitude
      , $in_polygon(y_coord, x_coord) as in_mkad
    from $REQUESTS
    where corp_client_id = $CORP_CLIENT_ID
      and substring(tech_event_instant_ddtm, 0, 10) between $START_DATE and $END_DATE 
      and mapped_event_type = 'Возвращен в магазин' 
);

-- Данные по заказам 
$requests_data = (
    select r.request_id as request_id
      , r.request_code as request_code
      , r.payment_method as payment_method
      , r.items_assessed_price as items_assessed_price
      , d.delivered_first_dttm as delivered_first_dttm
      , f.last_status_update_dttm as last_status_update_dttm
      , r.mapped_event_type as last_status
      , 1.0*r.weight/1000 as weight
      , r.x_coord as latitude
      , r.y_coord as longitude
      , $in_polygon(r.y_coord, r.x_coord) as in_mkad
    from $REQUESTS as r
    inner join $orders_final_status as f on r.request_id=f.request_id and r.tech_event_instant_ddtm=f.last_status_update_dttm
    inner join $orders_delivery_dttm as d on r.request_id=d.request_id
);

$almost_final = (
    select request_id
    , request_code
    , payment_method
    , items_assessed_price
    , delivered_first_dttm
    , last_status_update_dttm
    , weight
    , latitude
    , longitude
    , in_mkad
    , AGGREGATE_LIST(last_status) as last_status
    from $requests_data
    group by request_id
    , request_code
    , payment_method
    , items_assessed_price
    , delivered_first_dttm
    , last_status_update_dttm
    , weight
    , latitude
    , longitude
    , in_mkad
    
    union all

    select * from $returned_orders
);

SELECT request_id
  , request_code
  , delivered_first_dttm
  , items_assessed_price
  , weight
  , in_mkad
  , payment_method
  , latitude
  , longitude
  , unwrap(CASE 
      when ListLength(last_status) > 1 THEN (
          case 
            when 'Доставлен - подтверждено' in last_status then 'Доставлен - подтверждено'
            when 'Доставлен частично - подтверждено' in last_status then 'Доставлен частично - подтверждено'
            when 'Возвращен в магазин' in last_status then 'Возвращен в магазин'
            else last_status[0]
          end
      ) 
      else last_status[0]
    END) as last_status
  , last_status_update_dttm
from $almost_final