-- https://st.yandex-team.ru/LOGDATA-417
-- Отчет 2

USE hahn;
PRAGMA yt.InferSchema;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;

-- CORP_CLIENT_ID - Название
------------------------------------------------------------
-- 1a3a4511c8004fd1896d003c2ab06808 - Икстрим
-- 4c438b35503947319fde61b943a567ab - Носимо
-- 3f9df08db4084a8d9e6d6bbc6e676a04 - Реинвент
-- ddd5277ed27342ccb85e73c643c4b5bb - Рестор
-- 63ba685360f24dc4ad1258d9bb0905ae - Агентство Книга Сервис
-- e393ac7ec1974da5bdffa0708548a9f9 - ИП Одиноков
-- 602888cae1ab4026a24ce7a763a39ef8 - ИП Суворова
-- 100d513731f149cab40d2408b0c08aba - Модена
-- f028e22f2a014f1dbbfea702488acdd2 - Главзвук/ СПЛ Таганка
-- f2b09e63b57d41688487b121ffc54dc6 - Бариста
-- 100d513731f149cab40d2408b0c08aba - Маркет

-- МЕНЯТЬ ПАРАМЕТРЫ ЗДЕСЬ ==============================================================================================
$CORP_CLIENT_ID = 'f2b09e63b57d41688487b121ffc54dc6';
$START_DATE = '2021-06-01'; -- ГГГГ-ММ-ДД, иначе будет долго отрабатывать
$END_DATE = '2021-06-20'; -- ГГГГ-ММ-ДД, иначе будет долго отрабатывать
-- =====================================================================================================================

-- Источники
$REQUESTS = '//home/taxi-delivery/analytics/production/ndd/requests_datamart';
$PAYMENTS = '//home/taxi/testing/export/taxi-logistic-platform-production/payment_history';

-- Вспомогательные функции для работы с временем
$FORMAT = DateTime::Format("%d-%m-%Y");
$OTHER_FORMAT = DateTime::Format("%Y-%m-%d");

$dttm_from_sec = ($sec) -> {
    return cast($FORMAT(Datetime::Split(Datetime::FromSeconds(cast($sec as Uint32)))) as String)
};
$other_dttm_from_sec = ($sec) -> {
    return cast($OTHER_FORMAT(Datetime::Split(Datetime::FromSeconds(cast($sec as Uint32)))) as String)
};

-- Определеяем первую дату доставки
$orders_delivery_dttm = (
    select request_id
      , min(event_instant_ddtm) as delivered_first_dttm
    from $REQUESTS
    where mapped_event_type in ('Доставлен', 'Доставлен частично')
      and corp_client_id = $CORP_CLIENT_ID
    group by request_id
);

-- Данные по оплате
$payment_history = (
  select account_id
    , cast(amount as float)/100 as amount
    , billing_doc_id
    , corp_client_id
    , request_id
    , status
    , $dttm_from_sec(history_timestamp) as payment_approved_dttm
    , $other_dttm_from_sec(history_timestamp) as other_payment_approved_dttm
  from range($PAYMENTS)
  where corp_client_id = $CORP_CLIENT_ID
    and status = 'Approved'
);

-- Данные по заказам 
$requests_data = (
    select distinct request_id
      , request_code
      , payment_method
    from $REQUESTS
    where corp_client_id = $CORP_CLIENT_ID
);

-- Мерджим все
SELECT t1.request_id as `ID заявки`
  , t1.request_code as `Номер заказа` 
  , t2.payment_approved_dttm as `Дата перевода денег`
  , $FORMAT(Datetime::Split(cast(t3.delivered_first_dttm as Datetime))) as `Дата доставки`
  , t1.payment_method as `Тип оплаты`
  , t2.amount as `Сумма по заказу`
  , CASE 
      when t1.payment_method='cash_on_receipt' then Math::Round(t2.amount*0.01, -2)
      when t1.payment_method='card_on_receipt' then Math::Round(t2.amount*0.02, -2)
      else 0
    end as `Вознаграждение`
  , t2.billing_doc_id as billing_doc_id
from $requests_data as t1
inner join $payment_history as t2 on t1.request_id=t2.request_id
left join $orders_delivery_dttm as t3 on t1.request_id=t3.request_id
where t2.other_payment_approved_dttm between $START_DATE and $END_DATE;
