use hahn;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;

$requests_datamart = '//home/taxi-delivery/analytics/production/ndd/requests_datamart';
$save_to = '//home/taxi-delivery/analytics/production/ndd/leomax/jewelry';

$cheques = (
    select
        oc.id as id,
        o.external_order_id as external_order_id,                    -- Заказ LO-**
        lom_o.external_id as partner_order_id,  -- Заказ в ЛогПлатформе
        lom_o.sender_name as sender_name,       -- Имя мерча
        rd.type as type,                                -- Тип чека : INCOME = Приход, RETURN_INCOME = Возврат прихода
        rd.status as status,                              -- Статус чека: OK - выбит, ERROR,  PROCESSING - в обработке
        rd.card_amount, rd.cash_amount, rd.prepayment_amount, 
        rfd.ofd_url as ofd_url,
        rfd.fn_sn as fn_sn,                              -- Сер. номер ФН
        rfd.fd as fd,                                 -- Тип фискального документа
        rfd.document_num as document_num,                       -- Номер ФД в смене
        rfd.dt as dt,                                 -- Дата Время печати чека
        rfd.shift_num,                          -- Номер смены 
        rfd.fp,                                 -- ФПД
        rfd.kkt_rn,                             -- Рег. номер ККТ в ФНС
        rfd.kkt_sn,                             -- Сер. номер ККТ
        rfd.total as total,                              -- Сумма чека
        oc.original_cheque_id as original_cheque_id
    from
        `//home/market/production/tpl/cdc/market_tpl_production_orders` as o
    inner join `//home/market/production/tpl/cdc/market_tpl_production_order_cheque` as oc 
        on oc.order_id = o.id
    inner join `//home/market/production/tpl/cdc/market_tpl_production_receipt_data` as rd 
        on rd.receipt_id = oc.receipt_id
    inner join `//home/market/production/tpl/cdc/market_tpl_production_receipt_fiscal_data` as rfd 
        on rd.id = rfd.receipt_data_id
    inner join `//home/cdc/prod/market/logistics_lom/orders` as lom_o 
        on lom_o.barcode = o.external_order_id
    where o.external_order_id like '%LO-%' -- только заказы Яндекс Доставки
);

$logplatform_data = (
    select distinct
        t1.external_order_id as external_order_id,
        Re2::Replace('-\\d')(request_code, '') as request_code,
        request_id,
        -- count(distinct request_code) over (partition by t1.external_order_id) as codes_per_order_id
    from
        $cheques as t1
    inner join $requests_datamart as t2
        on t1.external_order_id = "LO-" || t2.external_order_id
    where t2.employer_code in ('ptv', 'tov')
);

INSERT INTO $save_to WITH TRUNCATE 
-- c.id,c.external_order_id,c.partner_order_id,c.sender_name,c.type,c.status,c.total,c.fn_sn,c.fd,c.document_num,c.dt,c2.fn_sn,c2.fd,c2.document_num,c2.dt
select
    c3.request_code,
    c3.request_id,
    c.id, 
    c.external_order_id,                    -- Заказ LO-**
    c.partner_order_id,  -- Заказ в ЛогПлатформе
    c.sender_name,       -- Имя мерча
    c.type,                                -- Тип чека : INCOME = Приход, RETURN_INCOME = Возврат прихода
    c.status,                              -- Статус 
    c.total,
    c.fn_sn,                              -- Сер. номер ФН
    c.fd,                                 -- Тип фискального документа
    c.document_num,                       -- Номер ФД в смене
    c.dt,                                 -- Дата Время печати чека
    c2.fn_sn,                              -- Сер. номер ФН
    c2.fd,                                 -- Тип фискального документа
    c2.document_num,                       -- Номер ФД в смене
    c2.dt                                 -- Дата Время печати чека
from $cheques as c
left join $cheques as c2 on c.original_cheque_id = c2.id
inner join $logplatform_data as c3 on c.external_order_id = c3.external_order_id
;
