use hahn;
PRAGMA yson.DisableStrict;
-- 4f6b271330049b12e72e3ef3 = bug

$issues = '//home/startrek/tables/prod/yandex-team/queue/CARGODEV/issues';
$requests_datamart = '//home/taxi-delivery/analytics/production/ndd/requests_datamart';
$save_to = '//home/taxi-delivery/analytics/dev/emilsharafiev/LOGDATA-2496/numbugs';

$parse_date = DateTime::Parse("%Y-%m-%d");
$week = ($x) -> {
    return DateTime::StartOfWeek($parse_date(substring($x, 0, 10)));
};

$a = (
select
    key
    , DateTime::FromMilliseconds(created) as created_dttm
    , DateTime::FromMilliseconds(resolved) as resolved_dttm
    , DateTime::StartOfWeek(DateTime::FromMilliseconds(created)) as created_week
    , DateTime::StartOfWeek(DateTime::FromMilliseconds(resolved)) as resolved_week
from $issues
where
    type = '4f6b271330049b12e72e3ef3'
    and 'log_platform' in Yson::ConvertToStringList(tags)
);


$created = (
    select
        created_week as week_dt
        , count(distinct key) as num_created
    from $a
    group by
        created_week
);

$resolved = (
    select
        resolved_week as week_dt
        , count(distinct key) as num_resolved
    from $a
    group by
        resolved_week
);


$wau = (
    select
        week_dt
        , count(distinct employer_code) as wau
        , count(distinct request_id) as num_orders
    from
        (
            select
                $week(created_dttm) as week_dt
                , employer_code
                , request_id
            from $requests_datamart
        )
    group by
        week_dt
);

INSERT INTO $save_to WITH TRUNCATE 
select
    substring(cast(a.week_dt as string), 0, 10) as week_dt
    , wau
    , num_orders
    , num_resolved ?? 0 as num_resolved
    , num_created ?? 0 as num_created
    , sum((num_created ?? 0) - (num_resolved ?? 0)) over (order by a.week_dt) as issues_open
from $wau as a
left join $created as c
    on a.week_dt = c.week_dt
left join $resolved as v
    on a.week_dt = v.week_dt
;
