PRAGMA AnsiInForEmptyOrNullableItemsCollections;
USE hahn;
PRAGMA yson.DisableStrict;

--PRAGMA yt.Pool="taxi-delivery";

$delivery_date_changes = (
SELECT order_id
    
    , original_delivery_from_date
    , IF(original_delivery_from_time == '00:00:00', NULL, original_delivery_from_time)
        as original_delivery_from_time
    
    , original_delivery_to_date
    , IF(original_delivery_to_time == '23:59:59', NULL, original_delivery_to_time)
        as original_delivery_to_time
    
    , plan_min_delivery_service_delayed_date
    , IF(plan_min_delivery_service_delayed_time == '00:00:00', NULL, plan_min_delivery_service_delayed_time)
        as plan_min_delivery_service_delayed_time
    
    , plan_max_delivery_service_delayed_date
    , IF(plan_max_delivery_service_delayed_time == '23:59:59', NULL, plan_max_delivery_service_delayed_time)
        as plan_max_delivery_service_delayed_time
FROM
(
    SELECT order_id
        , MIN_BY(SUBSTRING(old_delivery_date_time_from, 0, 10), id) as original_delivery_from_date
        , MIN_BY(SUBSTRING(old_delivery_date_time_from, 11, 8), id) as original_delivery_from_time
        
        , MIN_BY(SUBSTRING(old_delivery_date_time_to, 0, 10), id) as original_delivery_to_date
        , MIN_BY(SUBSTRING(old_delivery_date_time_to, 11, 8), id) as original_delivery_to_time
        
        , MIN_BY(SUBSTRING(old_delivery_date_time_from, 0, 10)
            , IF(delay_reason == 'DELIVERY_SERVICE_DELAYED', id, NULL)) 
            as plan_min_delivery_service_delayed_date
        , MIN_BY(SUBSTRING(old_delivery_date_time_from, 11, 8)
            , IF(delay_reason == 'DELIVERY_SERVICE_DELAYED', id, NULL)) 
            as plan_min_delivery_service_delayed_time
        
        , MIN_BY(SUBSTRING(old_delivery_date_time_to, 0, 10)
            , IF(delay_reason == 'DELIVERY_SERVICE_DELAYED', id, NULL)) 
            as plan_max_delivery_service_delayed_date
        , MIN_BY(SUBSTRING(old_delivery_date_time_to, 11, 8)
            , IF(delay_reason == 'DELIVERY_SERVICE_DELAYED', id, NULL)) 
            as plan_max_delivery_service_delayed_time
    FROM 
    (
        SELECT order_id, CAST(reason as String) as delay_reason, id
            , CAST(old_delivery_date_time_from as String) as old_delivery_date_time_from
            , CAST(old_delivery_date_time_to as String) as old_delivery_date_time_to
        FROM `//home/cdc/prod/market/logistics_lom/change_delivery_date_meta`
    )
    GROUP BY order_id
)
);


$raw_orders = (
SELECT cps.order_id as order_id 
    , cps.ds_order_id as ds_order_id
    , COALESCE(
        COALESCE(changes.original_delivery_from_date, orders.plan_delivery_from_date) || 'T'
        || COALESCE(changes.original_delivery_from_time, orders.plan_delivery_from_time)
        , '1970-01-01T00:00:00') as original_delivery_from_datetime
    , COALESCE(
        COALESCE(changes.original_delivery_to_date, orders.plan_delivery_to_date) || 'T'
        || COALESCE(changes.original_delivery_to_time, orders.plan_delivery_to_time)
        , '1970-01-01T00:00:00') as original_delivery_to_datetime
    , cps.order_logistic_status as order_logistic_status
    , LEAST(COALESCE(cp110, '2100-01-01T00:00:00'), COALESCE(cp120, '2100-01-01T00:00:00')
        , COALESCE(cp130, '2100-01-01T00:00:00'), COALESCE(cp10, '2100-01-01T00:00:00')
        , COALESCE(cp30, '2100-01-01T00:00:00'), COALESCE(cp40, '2100-01-01T00:00:00')
        , COALESCE(cp45, '2100-01-01T00:00:00'), COALESCE(cp48, '2100-01-01T00:00:00')
        , COALESCE(cp49, '2100-01-01T00:00:00'), COALESCE(cp50, '2100-01-01T00:00:00'))
        as fact_shipment_from_shop_datetime
    , LEAST(COALESCE(cp130, '2100-01-01T00:00:00'), COALESCE(cp10, '2100-01-01T00:00:00')
        , COALESCE(cp30, '2100-01-01T00:00:00'), COALESCE(cp40, '2100-01-01T00:00:00')
        , COALESCE(cp45, '2100-01-01T00:00:00'), COALESCE(cp48, '2100-01-01T00:00:00')
        , COALESCE(cp49, '2100-01-01T00:00:00'), COALESCE(cp50, '2100-01-01T00:00:00')) 
        as fact_shipment_to_delivery_service_datetime
    , LEAST(COALESCE(cp10, '2100-01-01T00:00:00'), COALESCE(cp30, '2100-01-01T00:00:00')
        , COALESCE(cp40, '2100-01-01T00:00:00'), COALESCE(cp45, '2100-01-01T00:00:00')
        , COALESCE(cp48, '2100-01-01T00:00:00'), COALESCE(cp49, '2100-01-01T00:00:00')
        , COALESCE(cp50, '2100-01-01T00:00:00'))
        as fact_delivery_start_datetime
    , LEAST(COALESCE(cp45, '2100-01-01T00:00:00'), COALESCE(cp49, '2100-01-01T00:00:00')
        , COALESCE(cp50, '2100-01-01T00:00:00')) 
        as fact_delivery_datetime
    , LEAST(COALESCE(cp43, '2100-01-01T00:00:00'), COALESCE(cp60, '2100-01-01T00:00:00')
        , COALESCE(cp70, '2100-01-01T00:00:00')) 
        as fact_return_beginning_datetime

    , IF(COALESCE(cp110, '2100') like '2100%', '1970-01-01T00:00:00', CAST(cp110 as String)) as cp110_datetime
    , IF(COALESCE(cp120, '2100') like '2100%', '1970-01-01T00:00:00', CAST(cp120 as String)) as cp120_datetime
    , IF(COALESCE(cp130, '2100') like '2100%', '1970-01-01T00:00:00', CAST(cp130 as String)) as cp130_datetime
    , IF(COALESCE(cp170, '2100') like '2100%', '1970-01-01T00:00:00', CAST(cp170 as String)) as cp170_datetime
    , IF(COALESCE(cp180, '2100') like '2100%', '1970-01-01T00:00:00', CAST(cp180 as String)) as cp180_datetime
    , IF(COALESCE(cp10, '2100') like '2100%', '1970-01-01T00:00:00', CAST(cp10 as String)) as cp10_datetime
    , IF(COALESCE(cp30, '2100') like '2100%', '1970-01-01T00:00:00', CAST(cp30 as String)) as cp30_datetime
    , IF(COALESCE(cp40, '2100') like '2100%', '1970-01-01T00:00:00', CAST(cp40 as String)) as cp40_datetime
    , IF(COALESCE(cp43, '2100') like '2100%', '1970-01-01T00:00:00', CAST(cp43 as String)) as cp43_datetime
    , IF(COALESCE(cp44, '2100') like '2100%', '1970-01-01T00:00:00', CAST(cp44 as String)) as cp44_datetime
    , IF(COALESCE(cp45, '2100') like '2100%', '1970-01-01T00:00:00', CAST(cp45 as String)) as cp45_datetime
    , IF(COALESCE(cp46, '2100') like '2100%', '1970-01-01T00:00:00', CAST(cp46 as String)) as cp46_datetime
    , IF(COALESCE(cp47, '2100') like '2100%', '1970-01-01T00:00:00', CAST(cp47 as String)) as cp47_datetime
    , IF(COALESCE(cp48, '2100') like '2100%', '1970-01-01T00:00:00', CAST(cp48 as String)) as cp48_datetime
    , IF(COALESCE(cp49, '2100') like '2100%', '1970-01-01T00:00:00', CAST(cp49 as String)) as cp49_datetime
    , IF(COALESCE(cp50, '2100') like '2100%', '1970-01-01T00:00:00', CAST(cp50 as String)) as cp50_datetime
    , IF(COALESCE(cp60, '2100') like '2100%', '1970-01-01T00:00:00', CAST(cp60 as String)) as cp60_datetime
    , IF(COALESCE(cp70, '2100') like '2100%', '1970-01-01T00:00:00', CAST(cp70 as String)) as cp70_datetime
    , IF(COALESCE(cp80, '2100') like '2100%', '1970-01-01T00:00:00', CAST(cp80 as String)) as cp80_datetime
    , IF(COALESCE(cp90, '2100') like '2100%', '1970-01-01T00:00:00', CAST(cp90 as String)) as cp90_datetime
from 
(    SELECT orders.id as order_id

        , SUBSTRING(CAST(orders.delivery_date_min as String), 0, 10) as plan_delivery_from_date
        , COALESCE(SUBSTRING(CAST(orders.delivery_start_time as String), 0, 8), '00:00:00') as plan_delivery_from_time
        , SUBSTRING(CAST(orders.delivery_date_max as String), 0, 10) as plan_delivery_to_date
        , COALESCE(SUBSTRING(CAST(orders.delivery_end_time as String), 0, 8), '00:00:00') as plan_delivery_to_time
    from `//home/cdc/prod/market/logistics_lom/orders` as orders
) as orders
left join 
(
    SELECT segments.order_id as order_id
        , MAX(IF(segments.waybill_segment_index == 0, Unicode::Substring(shipment_date, 0, 10), NULL)) 
            as plan_first_shipment_date
        , MAX(IF(segments.waybill_segment_index == 1, Unicode::Substring(shipment_date, 0, 10), NULL)) 
            as plan_second_shipment_date
        , MAX(IF(segments.waybill_segment_index == 0, partner_type, NULL)) as first_partner_type
        , MAX(IF(segments.waybill_segment_index == 1, partner_type, NULL)) as second_partner_type
        , MIN_BY(partner_id, IF(partner_type == 'DELIVERY', waybill_segment_index, NULL)) 
            as delivery_service_id
        , MIN_BY(partner_id, IF(partner_type == 'SORTING_CENTER', waybill_segment_index, NULL)) 
            as sorting_center_id
        , MIN_BY(tracks.track_code, IF(partner_type == 'DELIVERY', waybill_segment_index, NULL))
            as ds_order_id
        , MAX_BY(history.tracker_status, history.`date`) as order_logistic_status
        , MAX(history.`date`) as order_logistic_status_datetime
        
        -- Чекпоинты складов
        , MIN(IF(history.tracker_status == 'SORTING_CENTER_AT_START', history.`date`
            , NULL)) ?? '2100-01-01T00:00:00' as cp110
        , MIN(IF(history.tracker_status == 'SORTING_CENTER_PREPARED', history.`date`
            , NULL)) ?? '2100-01-01T00:00:00' as cp120
        , MIN(IF(history.tracker_status == 'SORTING_CENTER_TRANSMITTED', history.`date`
            , NULL)) ?? '2100-01-01T00:00:00' as cp130
        , MIN(IF(history.tracker_status == 'SORTING_CENTER_RETURN_ARRIVED', history.`date`
            , NULL)) ?? '2100-01-01T00:00:00' as cp170
        , MIN(IF(history.tracker_status == 'SORTING_CENTER_RETURN_RETURNED', history.`date`
            , NULL)) ?? '2100-01-01T00:00:00' as cp180
        
        -- Чекпоинты СД
        , MIN(IF(history.tracker_status == 'DELIVERY_AT_START', history.`date`
            , NULL)) ?? '2100-01-01T00:00:00' as cp10
        , MIN(IF(history.tracker_status == 'DELIVERY_TRANSPORTATION', history.`date`
            , NULL)) ?? '2100-01-01T00:00:00' as cp30
        , MIN(IF(history.tracker_status == 'DELIVERY_ARRIVED', history.`date`
            , NULL)) ?? '2100-01-01T00:00:00' as cp40
        , MIN(IF(history.tracker_status == 'DELIVERY_STORAGE_PERIOD_EXPIRED', history.`date`
            , NULL)) ?? '2100-01-01T00:00:00' as cp43
        , MIN(IF(history.tracker_status == 'DELIVERY_UPDATED_BY_SHOP', history.`date`
            , NULL)) ?? '2100-01-01T00:00:00' as cp44 -- Доставка перенесена по вине маркетплейса
        , MIN(IF(history.tracker_status == 'DELIVERY_ARRIVED_PICKUP_POINT', history.`date`
            , NULL)) ?? '2100-01-01T00:00:00' as cp45 -- В пункте самовывоза
        , MIN(IF(history.tracker_status == 'DELIVERY_UPDATED_BY_RECIPIENT', history.`date`
            , NULL)) ?? '2100-01-01T00:00:00' as cp46 -- Доставка перенесена по просьбе клиента
        , MIN(IF(history.tracker_status == 'DELIVERY_UPDATED_BY_DELIVERY', history.`date`
            , NULL)) ?? '2100-01-01T00:00:00' as cp47 -- Доставка перенесена по инициативе СД
        , MIN(IF(history.tracker_status == 'DELIVERY_TRANSPORTATION_RECIPIENT', history.`date`
            , NULL)) ?? '2100-01-01T00:00:00' as cp48 -- Доставляется по городу
        , MIN(IF(history.tracker_status == 'DELIVERY_TRANSMITTED_TO_RECIPIENT', history.`date`
            , NULL)) ?? '2100-01-01T00:00:00' as cp49
        , MIN(IF(history.tracker_status == 'DELIVERY_DELIVERED', history.`date`
            , NULL)) ?? '2100-01-01T00:00:00' as cp50
        , MIN(IF(history.tracker_status == 'RETURN_PREPARING', history.`date`
            , NULL)) ?? '2100-01-01T00:00:00' as cp60
        , MIN(IF(history.tracker_status == 'RETURN_ARRIVED_DELIVERY', history.`date`
            , NULL)) ?? '2100-01-01T00:00:00' as cp70
        , MIN(IF(history.tracker_status == 'RETURN_TRANSMITTED_FULFILMENT', history.`date`
            , NULL)) ?? '2100-01-01T00:00:00' as cp80
        , MIN(IF(history.tracker_status == 'DELIVERY_ATTEMPT_FAILED', history.`date`
            , NULL)) ?? '2100-01-01T00:00:00' as cp90 -- Вручить не удалось
    from `//home/cdc/prod/market/logistics_lom/waybill_segment` as segments
    left join 
    (
        SELECT CAST(tracker_status as String) as tracker_status
            , SUBSTRING(CAST(`date` as String), 0, 19) as `date`
            , waybill_segment_id
        FROM `//home/cdc/prod/market/logistics_lom/waybill_segment_status_history`
    ) as history
    on segments.id = history.waybill_segment_id
    left join `//home/market/production/mstat/dwh/detail/link_logistics_entity_track` as tracks
    on segments.tracker_id = tracks.id
    GROUP BY segments.order_id
) as cps
on cps.order_id = orders.order_id
left join $delivery_date_changes as changes
on cps.order_id = changes.order_id
)
;

$tpl = (
select 
    Yson::YPathInt64(raw.doc, '/order_id') as order_id
    , eoi.external_order_id as external_order_id
    , Yson2::ConvertToString(raw.doc.context) as tpl_context
    , Yson::YPathString(raw.doc, '/source') as tpl_source
    , Yson::YPathString(raw.doc, '/type') as tpl_type
    , utc_created_dttm as tpl_dttm
from 
range(`//home/market/production/mstat/dwh/raw/market_tpl/order_history_event`, '2022-01') as raw
left join 
(select id, external_order_id from `//home/market/production/tpl/cdc/market_tpl_production_orders`) as eoi
on eoi.id  = Yson::YPathInt64(raw.doc, '/order_id')
)
;

$tpl_reschedules = 
(
    SELECT
        external_order_id
        , MAX_BY(tpl_context, tpl_dttm) as resc_context
        , MAX(tpl_dttm) as resc_dttm
    FROM
        $tpl
    WHERE 
        tpl_type = 'DELIVERY_RESCHEDULE'
    GROUP BY 
        external_order_id
);

$tpl_postpone = 
(
    SELECT
        external_order_id
        , MAX_BY(tpl_context, tpl_dttm) as post_context
        , MAX(tpl_dttm) as post_dttm
    FROM
        $tpl
    WHERE 
        tpl_type = 'ORDER_POSTPONED'
    GROUP BY 
        external_order_id
);

$tpl_at_delivery = 
(
    SELECT
        external_order_id
        , MAX_BY(tpl_context, tpl_dttm) as ad_context
        , MAX(tpl_dttm) as ad_dttm
    FROM
        $tpl
    WHERE 
        tpl_context = 'Заказ выдан курьеру и доставляется клиенту (48)'
    GROUP BY 
        external_order_id
);

$tpl_cancells = 
(
    SELECT
        external_order_id
        , MAX_BY(tpl_context, tpl_dttm) as canc_context
        , MAX(tpl_dttm) as canc_dttm
    FROM
        $tpl
    WHERE 
        tpl_type = 'CANCELLED'
    GROUP BY 
        external_order_id
);

$tpl_courier_acc = 
(
    SELECT
        external_order_id
        , MAX_BY(tpl_context, tpl_dttm) as acc_context
        , MAX(tpl_dttm) as acc_dttm
    FROM
        $tpl
    WHERE 
        tpl_type = 'ACCEPTED_BY_COURIER'
    GROUP BY 
        external_order_id
);

$tpl_act_status = 
(
    SELECT 
        external_order_id
        , MAX_BY(tpl_context, tpl_dttm) as tpl_context
        , MAX_BY(tpl_source, tpl_dttm) as tpl_source
        , MAX_BY(tpl_type, tpl_dttm) as tpl_type
        , MAX(tpl_dttm) as tpl_dttm
    FROM
        $tpl
    GROUP BY 
        external_order_id
)
;

$calls = (
    SELECT
    `id`,
    case when status = 'NOT_CALLED' then SUBSTRING(cast(expected_call_time as String), null, 10) else null end as status_dttm_NOT_CALLED
    , case when status = 'FAILED' then SUBSTRING(cast(expected_call_time as String), null, 10) else null end as status_dttm_FAILED
    , case when status = 'SUCCESS' then SUBSTRING(cast(expected_call_time as String), null, 10) else null end as status_dttm_SUCCESS
    , case when status = 'CLOSED' then SUBSTRING(cast(expected_call_time as String), null, 10) else null end as status_dttm_CLOSED
    , case when status = 'RECALL_REQUIRED' then SUBSTRING(cast(expected_call_time as String), null, 10) else null end as status_dttm_RECALL_REQUIRED
    , case when status = 'SUCCESS_CLIENT_CONFIRM' then SUBSTRING(cast(expected_call_time as String), null, 10) else null end as status_dttm_SUCCESS_CLIENT_CONFIRM
    , case when status = 'CLIENT_ASK_NOT_TO_CALL' then SUBSTRING(cast(expected_call_time as String), null, 10) else null end as status_dttm_CLIENT_ASK_NOT_TO_CALL
FROM `//home/market/production/tpl/cdc/market_tpl_production_task_call_to_recipient`
)
;

$calls_with_ids = (
    SELECT
    CAST(o.id as utf8) as cwi_id,
    MIN(status_dttm_NOT_CALLED) as status_dttm_NOT_CALLED,
    MIN(status_dttm_FAILED) as status_dttm_FAILED,
    MIN(status_dttm_SUCCESS) as status_dttm_SUCCESS,
    MIN(status_dttm_CLOSED) as status_dttm_CLOSED,
    MIN(status_dttm_RECALL_REQUIRED) as status_dttm_RECALL_REQUIRED,
    MIN(status_dttm_SUCCESS_CLIENT_CONFIRM) as status_dttm_SUCCESS_CLIENT_CONFIRM,
    MIN(status_dttm_CLIENT_ASK_NOT_TO_CALL) as status_dttm_CLIENT_ASK_NOT_TO_CALL
    FROM `//home/market/production/tpl/cdc/market_tpl_production_task_order_delivery` as o
    left join 
        $calls as c 
        on c.id = o.call_to_recipient_task_id
    group by 
        o.id
)
;

INSERT INTO `//home/taxi-delivery/analytics/dev/ndd/market_courier_delivery_2h`
WITH TRUNCATE

SELECT
    l.*,
    canc.cancelled_datetime,
    canc.tracker_status,
    sla.cp110_datetime,
    sla.cp48_datetime,
    sla.fact_delivery_datetime,
    sla.order_logistic_status,
    sla.original_delivery_from_datetime,
    sla.original_delivery_to_datetime,
    w.partner_subtype as partner_subtype,
    r.employer_code as employer_code,
    r.payment_method as payment_method,
    r.operator_id as operator_id,
    r.request_code as request_code,
    cd.new_delivery_date_time_from as new_delivery_date_time_from,
    cd.new_delivery_date_time_to as new_delivery_date_time_to,
    cd.reason as reason,
    cd.date_changed_at as date_changed_at,
    ss_canc.cancelled_datetime as sort_center_cancelled_dttm,
    canc_r.cancel_reason as cancel_reason,
    tpl_act_status.tpl_context as tpl_context,
    tpl_act_status.tpl_source as tpl_source,
    tpl_act_status.tpl_type as tpl_type,
    tpl_act_status.tpl_dttm as tpl_dttm,
    tpl_cancells.canc_dttm as canc_dttm,
    tpl_cancells.canc_context as canc_context,
    tpl_reschedules.resc_context as resc_context,
    tpl_reschedules.resc_dttm as resc_dttm,
    tpl_postpone.post_context as post_context,
    tpl_postpone.post_dttm as post_dttm,
    tpl_courier_acc.acc_context as acc_context,
    tpl_courier_acc.acc_dttm as acc_dttm,
    tpl_at_delivery.ad_context as ad_context,
    tpl_at_delivery.ad_dttm as ad_dttm,
    cwi.*
FROM hahn.`//home/cdc/prod/market/logistics_lom/orders` as l
LEFT JOIN $raw_orders as sla
ON l.id = sla.order_id
LEFT JOIN $calls_with_ids as cwi 
ON cwi.cwi_id = sla.ds_order_id
inner JOIN  hahn.`//home/taxi-delivery/analytics/production/ndd/requests_datamart` as r
ON r.external_order_id = cast(l.id as utf8)
LEFT JOIN hahn.`//home/cdc/prod/market/logistics_lom/waybill_segment` as w
ON l.id = w.order_id
left join 
    (
        SELECT waybill_segment_id
            , MAX_BY(tracker_status, tracker_checkpoint_id) as tracker_status
            , MAX_BY(SUBSTRING(CAST(`date` as String), 0, 19), tracker_checkpoint_id) as `cancelled_datetime`
        FROM `//home/cdc/prod/market/logistics_lom/waybill_segment_status_history`
        GROUP BY 
             waybill_segment_id
    ) as canc
ON w.id = canc.waybill_segment_id
left join 
    (
        SELECT waybill_segment_id
            , MAX_BY(SUBSTRING(CAST(`date` as String), 0, 19), tracker_checkpoint_id) as `cancelled_datetime`
        FROM `//home/cdc/prod/market/logistics_lom/waybill_segment_status_history`
        WHERE tracker_status = "RETURN_PREPARING"
        GROUP BY 
             waybill_segment_id
    ) as ss_canc
ON w.id = ss_canc.waybill_segment_id
LEFT JOIN (
    select 
    MAX_BY(new_delivery_date_time_from, id) as new_delivery_date_time_from,
    MAX_BY(new_delivery_date_time_to, id) as new_delivery_date_time_to, 
    MAX_BY(`date_changed_at`, id) as date_changed_at,
    order_id, reason
from 
 hahn.`//home/cdc/prod/market/logistics_lom/change_delivery_date_meta` as cd 
group by 
    order_id, reason
) as cd
ON cd.order_id = l.id
LEFT JOIN (
    SELECT
     order_id
     , MAX_BY(`reason`, created) as cancel_reason
FROM `//home/cdc/prod/market/logistics_lom/cancellation_order_request`
    group by order_id
) as canc_r 
on canc_r.order_id = l.id
LEFT JOIN
    $tpl_act_status as tpl_act_status
    ON tpl_act_status.external_order_id = l.barcode
LEFT JOIN
    $tpl_reschedules as tpl_reschedules
    ON tpl_reschedules.external_order_id = l.barcode
LEFT JOIN
    $tpl_cancells as tpl_cancells
    ON tpl_cancells.external_order_id = l.barcode
LEFT JOIN
    $tpl_postpone as tpl_postpone
    ON tpl_postpone.external_order_id = l.barcode
LEFT JOIN 
    $tpl_courier_acc as tpl_courier_acc
    ON tpl_courier_acc.external_order_id = l.barcode
LEFT JOIN 
    $tpl_at_delivery as tpl_at_delivery 
    ON tpl_at_delivery.external_order_id = l.barcode
where l.platform_client_id in (3, 6)
--and l.created LIKE ("%2021-11%")
--and w.partner_subtype = "MARKET_COURIER"
and l.credentials_inn = "7716760301"
and l.credentials_inn != "772794164100"
