USE chyt.hahn/taxi-delivery;


--create table "//home/taxi-delivery/analytics/dev/ndd/alert_client_avg_week" engine=YtTable() as 
insert into "<append=false>//home/taxi-delivery/analytics/dev/ndd/alert_client_avg_week"
select 
employer_code, corp_client_id, avg_curr_week, avg_last_week, avg_curr_week < (avg_last_week - avg_last_week*0.3) as alert
from
(select
employer_code, corp_client_id, avg(cnt) as avg_curr_week
from  
(SELECT
-- 
    case 
        when creation_method_human = 'ЛК (внешние клиенты)' then 'smol'
        else employer_code
    end as employer_code,
    case 
        when creation_method_human = 'ЛК (внешние клиенты)' then 'Агрегация по тем, кто платит через ЛК'
        else corp_client_id
    end as corp_client_id,
-- 
    toDate(left(created_dttm, 10)) as dt,
    count(distinct request_code) as cnt
FROM `//home/taxi-delivery/analytics/production/ndd/requests_datamart`
group by 
 employer_code,
    corp_client_id, dt 
having dt between toDate(timestamp_add(today(), interval -6 day)) and  toDate(today())
) as raw 
group by 
employer_code, corp_client_id
) as cw
left join 
(select
employer_code, corp_client_id, avg(cnt) as avg_last_week
from  
(SELECT
-- 
    case 
        when creation_method_human = 'ЛК (внешние клиенты)' then 'smol'
        else employer_code
    end as employer_code,
    case 
        when creation_method_human = 'ЛК (внешние клиенты)' then 'Агрегация по тем, кто платит через ЛК'
        else corp_client_id
    end as corp_client_id,
-- 
    toDate(left(created_dttm, 10)) as dt,
    count(distinct request_code) as cnt
FROM `//home/taxi-delivery/analytics/production/ndd/requests_datamart`
group by 
 employer_code,
    corp_client_id, dt 
having dt between toDate(timestamp_add(today(), interval -13 day)) and  toDate(timestamp_add(today(), interval -7 day))
) as raw 
group by 
employer_code, corp_client_id
) as lw
on lw.employer_code = cw.employer_code
    and lw.corp_client_id = cw.corp_client_id

