USE chyt.hahn/taxi-delivery;


--create table "//home/taxi-delivery/analytics/dev/ndd/alert_two_days" engine=YtTable() as 
insert into "<append=false>//home/taxi-delivery/analytics/dev/ndd/alert_two_days"
select 
    employer_code,
    corp_client_id,
    sum(case when dt between toDate(timestamp_add(today(), interval -8 day)) and toDate(timestamp_add(today(), interval -2 day)) then cnt else 0 end) as prev_week,
    sum(case when dt between toDate(timestamp_add(today(), interval -1 day)) and today() then cnt else 0 end) as today_and_yesterday,
    prev_week = 7 and today_and_yesterday = 0 as alert
from (
SELECT
-- 
    case 
        when creation_method_human = 'ЛК (внешние клиенты)' then 'smol'
        else employer_code
    end as employer_code,
    case 
        when creation_method_human = 'ЛК (внешние клиенты)' then 'Агрегация по тем, кто платит через ЛК'
        else corp_client_id
    end as corp_client_id,
-- 
    toDate(left(created_dttm, 10)) as dt,
    case when count(distinct request_code) >= 1 then 1 else 0 end as cnt
FROM `//home/taxi-delivery/analytics/production/ndd/requests_datamart`
group by 
 employer_code,
    corp_client_id, dt 
having dt between toDate(timestamp_add(today(), interval -8 day)) and  toDate(today())
)
group by 
employer_code,
    corp_client_id
;
